/*
 * Decompiled with CFR 0.152.
 */
package com.lowagie.text.pdf;

import com.lowagie.text.DocumentException;
import com.lowagie.text.Rectangle;
import com.lowagie.text.error_messages.MessageLocalization;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfAppearance;
import com.lowagie.text.pdf.PdfCopyFieldsImp;
import com.lowagie.text.pdf.PdfDictionary;
import com.lowagie.text.pdf.PdfName;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class BaseField {
    public static final float BORDER_WIDTH_THIN = 1.0f;
    public static final float BORDER_WIDTH_MEDIUM = 2.0f;
    public static final float BORDER_WIDTH_THICK = 3.0f;
    public static final int VISIBLE = 0;
    public static final int HIDDEN = 1;
    public static final int VISIBLE_BUT_DOES_NOT_PRINT = 2;
    public static final int HIDDEN_BUT_PRINTABLE = 3;
    public static final int INVISIBLE = 1;
    public static final int PRINT = 4;
    public static final int NOVIEW = 32;
    public static final int LOCKED = 128;
    public static final int READ_ONLY = 1;
    public static final int REQUIRED = 2;
    public static final int MULTILINE = 4096;
    public static final int DO_NOT_SCROLL = 0x800000;
    public static final int PASSWORD = 8192;
    public static final int FILE_SELECTION = 0x100000;
    public static final int DO_NOT_SPELL_CHECK = 0x400000;
    public static final int EDIT = 262144;
    public static final int MULTISELECT = 0x200000;
    public static final int COMB = 0x1000000;
    private static final Map<PdfName, Integer> fieldKeys = new HashMap<PdfName, Integer>();
    protected float borderWidth = 1.0f;
    protected int borderStyle = 0;
    protected Color borderColor;
    protected Color backgroundColor;
    protected Color textColor;
    protected BaseFont font;
    protected float fontSize = 0.0f;
    protected int alignment = 0;
    protected PdfWriter writer;
    protected String text;
    protected Rectangle box;
    protected int rotation = 0;
    protected int visibility;
    protected String fieldName;
    protected String alternateFieldName;
    protected String mappingName;
    protected int options;
    protected int maxCharacterLength;

    public BaseField(PdfWriter writer, Rectangle box, String fieldName) {
        this.writer = writer;
        this.setBox(box);
        this.fieldName = fieldName;
    }

    protected static PdfAppearance getBorderAppearance(PdfWriter writer, Rectangle box, int rotation, Color backgroundColor, int borderStyle, float borderWidth, Color borderColor, int options, int maxCharacterLength) {
        PdfAppearance app = PdfAppearance.createAppearance(writer, box.getWidth(), box.getHeight());
        switch (rotation) {
            case 90: {
                app.setMatrix(0.0f, 1.0f, -1.0f, 0.0f, box.getHeight(), 0.0f);
                break;
            }
            case 180: {
                app.setMatrix(-1.0f, 0.0f, 0.0f, -1.0f, box.getWidth(), box.getHeight());
                break;
            }
            case 270: {
                app.setMatrix(0.0f, -1.0f, 1.0f, 0.0f, 0.0f, box.getWidth());
            }
        }
        app.saveState();
        if (backgroundColor != null) {
            app.setColorFill(backgroundColor);
            app.rectangle(0.0f, 0.0f, box.getWidth(), box.getHeight());
            app.fill();
        }
        if (borderStyle == 4) {
            if (borderWidth != 0.0f && borderColor != null) {
                app.setColorStroke(borderColor);
                app.setLineWidth(borderWidth);
                app.moveTo(0.0f, borderWidth / 2.0f);
                app.lineTo(box.getWidth(), borderWidth / 2.0f);
                app.stroke();
            }
        } else if (borderStyle == 2) {
            Color actual;
            if (borderWidth != 0.0f && borderColor != null) {
                app.setColorStroke(borderColor);
                app.setLineWidth(borderWidth);
                app.rectangle(borderWidth / 2.0f, borderWidth / 2.0f, box.getWidth() - borderWidth, box.getHeight() - borderWidth);
                app.stroke();
            }
            if ((actual = backgroundColor) == null) {
                actual = Color.white;
            }
            app.setGrayFill(1.0f);
            BaseField.drawTopFrame(app, borderWidth, box);
            app.setColorFill(actual.darker());
            BaseField.drawBottomFrame(app, borderWidth, box);
        } else if (borderStyle == 3) {
            if (borderWidth != 0.0f && borderColor != null) {
                app.setColorStroke(borderColor);
                app.setLineWidth(borderWidth);
                app.rectangle(borderWidth / 2.0f, borderWidth / 2.0f, box.getWidth() - borderWidth, box.getHeight() - borderWidth);
                app.stroke();
            }
            app.setGrayFill(0.5f);
            BaseField.drawTopFrame(app, borderWidth, box);
            app.setGrayFill(0.75f);
            BaseField.drawBottomFrame(app, borderWidth, box);
        } else if (borderWidth != 0.0f && borderColor != null) {
            if (borderStyle == 1) {
                app.setLineDash(3.0f, 0.0f);
            }
            app.setColorStroke(borderColor);
            app.setLineWidth(borderWidth);
            app.rectangle(borderWidth / 2.0f, borderWidth / 2.0f, box.getWidth() - borderWidth, box.getHeight() - borderWidth);
            app.stroke();
            if ((options & 0x1000000) != 0 && maxCharacterLength > 1) {
                float step = box.getWidth() / (float)maxCharacterLength;
                float yb = borderWidth / 2.0f;
                float yt = box.getHeight() - borderWidth / 2.0f;
                for (int k = 1; k < maxCharacterLength; ++k) {
                    float x = step * (float)k;
                    app.moveTo(x, yb);
                    app.lineTo(x, yt);
                }
                app.stroke();
            }
        }
        app.restoreState();
        return app;
    }

    @Deprecated
    protected static ArrayList getHardBreaks(String text) {
        return (ArrayList)BaseField.getAllHardBreaks(text);
    }

    protected static List<String> getAllHardBreaks(String text) {
        ArrayList<String> arr = new ArrayList<String>();
        char[] cs = text.toCharArray();
        int len = cs.length;
        StringBuffer buf = new StringBuffer();
        for (int k = 0; k < len; ++k) {
            char c = cs[k];
            if (c == '\r') {
                if (k + 1 < len && cs[k + 1] == '\n') {
                    ++k;
                }
                arr.add(buf.toString());
                buf = new StringBuffer();
                continue;
            }
            if (c == '\n') {
                arr.add(buf.toString());
                buf = new StringBuffer();
                continue;
            }
            buf.append(c);
        }
        arr.add(buf.toString());
        return arr;
    }

    protected static void trimRight(StringBuffer buf) {
        int len = buf.length();
        while (len != 0) {
            if (buf.charAt(--len) != ' ') {
                return;
            }
            buf.setLength(len);
        }
        return;
    }

    @Deprecated
    protected static ArrayList breakLines(ArrayList breaks, BaseFont font, float fontSize, float width) {
        return (ArrayList)BaseField.breakLines((List<String>)breaks, font, fontSize, width);
    }

    protected static List<String> breakLines(List<String> breaks, BaseFont font, float fontSize, float width) {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer buf = new StringBuffer();
        for (String aBreak : breaks) {
            buf.setLength(0);
            float w = 0.0f;
            char[] cs = aBreak.toCharArray();
            int len = cs.length;
            int state = 0;
            int lastspace = -1;
            char c = '\u0000';
            int refk = 0;
            block6: for (int k = 0; k < len; ++k) {
                c = cs[k];
                switch (state) {
                    case 0: {
                        w += font.getWidthPoint(c, fontSize);
                        buf.append(c);
                        if (w > width) {
                            w = 0.0f;
                            if (buf.length() > 1) {
                                buf.setLength(buf.length() - 1);
                            }
                            lines.add(buf.toString());
                            buf.setLength(0);
                            refk = --k;
                            if (c == ' ') {
                                state = 2;
                                continue block6;
                            }
                            state = 1;
                            continue block6;
                        }
                        if (c == ' ') continue block6;
                        state = 1;
                        continue block6;
                    }
                    case 1: {
                        w += font.getWidthPoint(c, fontSize);
                        buf.append(c);
                        if (c == ' ') {
                            lastspace = k;
                        }
                        if (!(w > width)) continue block6;
                        w = 0.0f;
                        if (lastspace >= 0) {
                            k = lastspace;
                            buf.setLength(lastspace - refk);
                            BaseField.trimRight(buf);
                            lines.add(buf.toString());
                            buf.setLength(0);
                            refk = k;
                            lastspace = -1;
                            state = 2;
                            continue block6;
                        }
                        if (buf.length() > 1) {
                            buf.setLength(buf.length() - 1);
                        }
                        lines.add(buf.toString());
                        buf.setLength(0);
                        refk = --k;
                        if (c != ' ') continue block6;
                        state = 2;
                        continue block6;
                    }
                    case 2: {
                        if (c == ' ') continue block6;
                        w = 0.0f;
                        --k;
                        state = 1;
                    }
                }
            }
            BaseField.trimRight(buf);
            lines.add(buf.toString());
        }
        return lines;
    }

    private static void drawTopFrame(PdfAppearance app, float borderWidth, Rectangle box) {
        app.moveTo(borderWidth, borderWidth);
        app.lineTo(borderWidth, box.getHeight() - borderWidth);
        app.lineTo(box.getWidth() - borderWidth, box.getHeight() - borderWidth);
        app.lineTo(box.getWidth() - 2.0f * borderWidth, box.getHeight() - 2.0f * borderWidth);
        app.lineTo(2.0f * borderWidth, box.getHeight() - 2.0f * borderWidth);
        app.lineTo(2.0f * borderWidth, 2.0f * borderWidth);
        app.lineTo(borderWidth, borderWidth);
        app.fill();
    }

    private static void drawBottomFrame(PdfAppearance app, float borderWidth, Rectangle box) {
        app.moveTo(borderWidth, borderWidth);
        app.lineTo(box.getWidth() - borderWidth, borderWidth);
        app.lineTo(box.getWidth() - borderWidth, box.getHeight() - borderWidth);
        app.lineTo(box.getWidth() - 2.0f * borderWidth, box.getHeight() - 2.0f * borderWidth);
        app.lineTo(box.getWidth() - 2.0f * borderWidth, 2.0f * borderWidth);
        app.lineTo(2.0f * borderWidth, 2.0f * borderWidth);
        app.lineTo(borderWidth, borderWidth);
        app.fill();
    }

    public static void moveFields(PdfDictionary from, PdfDictionary to) {
        Iterator<PdfName> i = from.getKeys().iterator();
        while (i.hasNext()) {
            PdfName key = i.next();
            if (!fieldKeys.containsKey(key)) continue;
            if (to != null) {
                to.put(key, from.get(key));
            }
            i.remove();
        }
    }

    protected BaseFont getRealFont() throws IOException, DocumentException {
        if (this.font == null) {
            return BaseFont.createFont("Helvetica", "Cp1252", false);
        }
        return this.font;
    }

    public float getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderWidth(float borderWidth) {
        this.borderWidth = borderWidth;
    }

    public int getBorderStyle() {
        return this.borderStyle;
    }

    public void setBorderStyle(int borderStyle) {
        this.borderStyle = borderStyle;
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public Color getTextColor() {
        return this.textColor;
    }

    public void setTextColor(Color textColor) {
        this.textColor = textColor;
    }

    public BaseFont getFont() {
        return this.font;
    }

    public void setFont(BaseFont font) {
        this.font = font;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(float fontSize) {
        this.fontSize = fontSize;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int alignment) {
        this.alignment = alignment;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public Rectangle getBox() {
        return this.box;
    }

    public void setBox(Rectangle box) {
        if (box == null) {
            this.box = null;
        } else {
            this.box = new Rectangle(box);
            this.box.normalize();
        }
    }

    public int getRotation() {
        return this.rotation;
    }

    public void setRotation(int rotation) {
        if (rotation % 90 != 0) {
            throw new IllegalArgumentException(MessageLocalization.getComposedMessage("rotation.must.be.a.multiple.of.90"));
        }
        if ((rotation %= 360) < 0) {
            rotation += 360;
        }
        this.rotation = rotation;
    }

    public void setRotationFromPage(Rectangle page) {
        this.setRotation(page.getRotation());
    }

    public int getVisibility() {
        return this.visibility;
    }

    public void setVisibility(int visibility) {
        this.visibility = visibility;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getAlternateFieldName() {
        return this.alternateFieldName;
    }

    public void setAlternateFieldName(String alternateFieldName) {
        this.alternateFieldName = alternateFieldName;
    }

    public String getMappingName() {
        return this.mappingName;
    }

    public void setMappingName(String mappingName) {
        this.mappingName = mappingName;
    }

    public int getOptions() {
        return this.options;
    }

    public void setOptions(int options) {
        this.options = options;
    }

    public int getMaxCharacterLength() {
        return this.maxCharacterLength;
    }

    public void setMaxCharacterLength(int maxCharacterLength) {
        this.maxCharacterLength = maxCharacterLength;
    }

    public PdfWriter getWriter() {
        return this.writer;
    }

    public void setWriter(PdfWriter writer) {
        this.writer = writer;
    }

    static {
        fieldKeys.putAll(PdfCopyFieldsImp.fieldKeys);
        fieldKeys.put(PdfName.T, 1);
    }
}

