/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.messagingcenter.miniproxy.core;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.zip.GZIPOutputStream;

public class BasicHttpSerializer {
    private OutputStream os;

    public BasicHttpSerializer(OutputStream os) {
        this.os = os;
    }

    public void writeInt(int a) throws IOException {
        this.os.write(ByteBuffer.allocate(4).putInt(a).array());
    }

    public void writeLong(long a) throws IOException {
        this.os.write(ByteBuffer.allocate(8).putLong(a).array());
    }

    public void writeString(String str) throws IOException {
        byte[] bs = str.getBytes("UTF-8");
        this.writeInt(bs.length);
        this.os.write(bs);
    }

    public void writeGzipString(String str) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gos = new GZIPOutputStream(baos);
        gos.write(str.getBytes("UTF-8"));
        gos.close();
        this.writeInt(baos.size());
        baos.writeTo(this.os);
    }

    public void writeFile(File f) throws IOException {
        this.writeString(f.getName());
        this.writeLong(f.length());
        try (FileInputStream fis = new FileInputStream(f);){
            byte[] bs = new byte[131072];
            int len = fis.read(bs);
            while (len != -1) {
                this.os.write(bs, 0, len);
                len = fis.read(bs);
            }
        }
    }

    public void flush() throws IOException {
        this.os.flush();
    }
}

