/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.messagingcenter.miniproxy.core;

import fr.amapj.messagingcenter.miniproxy.core.BasicHttpClient;
import fr.amapj.messagingcenter.miniproxy.core.BasicHttpDeserializer;
import fr.amapj.messagingcenter.miniproxy.core.BasicHttpSerializer;
import fr.amapj.messagingcenter.miniproxy.core.MiniProxyGson;
import fr.amapj.messagingcenter.miniproxy.core.ServiceNotAvailableException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class MiniProxyClient<T extends Enum<?>> {
    private static final Logger logger = LogManager.getLogger();
    private String key;
    private String urlWebServer;

    protected MiniProxyClient(String key, String urlWebServer) {
        this.key = key;
        this.urlWebServer = urlWebServer;
    }

    protected <RESPONSE> RESPONSE doCall(T method, Object request, Class<RESPONSE> responseClass) throws ServiceNotAvailableException {
        try {
            logger.info("MiniProxy :  " + method);
            BasicHttpClient c = new BasicHttpClient(this.urlWebServer, 10000);
            BasicHttpSerializer bos = c.startWrite();
            bos.writeString(this.key);
            bos.writeString(((Enum)method).name());
            String str = MiniProxyGson.createGson().toJson(request);
            bos.writeGzipString(str);
            BasicHttpDeserializer bis = c.startRead();
            str = bis.readGzipString();
            c.end();
            return (RESPONSE)MiniProxyGson.createGson().fromJson(str, responseClass);
        }
        catch (Exception e) {
            logger.warn("Erreur MiniProxy", (Throwable)e);
            throw new ServiceNotAvailableException();
        }
    }
}

