/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.common;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.GenericUtils;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class CollectionUtils {
    public static <T> List<List<T>> cutInSubList(List<T> listIn, int nbElem) {
        if (nbElem <= 0) {
            throw new AmapjRuntimeException("Impossible de d\u00e9couper une liste avec nbElem=" + nbElem);
        }
        ArrayList<List<T>> res = new ArrayList<List<T>>();
        ArrayList<T> tmp = new ArrayList<T>();
        int size = listIn.size();
        int i = 0;
        while (i < size) {
            if (i != 0 && i % nbElem == 0) {
                res.add(tmp);
                tmp = new ArrayList();
            }
            tmp.add(listIn.get(i));
            ++i;
        }
        if (tmp.size() != 0) {
            res.add(tmp);
        }
        return res;
    }

    public static <T> String asString(List<T> ls, String sep, ToString<T> f) {
        return CollectionUtils.asString(ls, sep, f, false);
    }

    public static <T> String asString(List<T> ls, String sep, ToString<T> f, boolean excludeEmpty) {
        if (ls.size() == 0) {
            return "";
        }
        StringBuffer str = new StringBuffer();
        int i = 0;
        while (i < ls.size() - 1) {
            T l = ls.get(i);
            if (l != null) {
                String s = f.toString(l);
                if (s != null && s.length() > 0) {
                    str.append(s);
                } else if (!excludeEmpty) {
                    str.append(s);
                }
            } else {
                str.append("null");
            }
            str.append(sep);
            ++i;
        }
        T l = ls.get(ls.size() - 1);
        if (l != null) {
            String s = f.toString(l);
            if (s != null && s.length() > 0) {
                str.append(s);
            } else if (!excludeEmpty) {
                str.append(s);
            }
        } else {
            str.append("null");
        }
        return str.toString();
    }

    public static <T> String asString(List<T> ls, String sep) {
        ToString f = new ToString<T>(){

            @Override
            public String toString(T t) {
                return t.toString();
            }
        };
        return CollectionUtils.asString(ls, sep, f);
    }

    public static <T> String asStdString(List<T> ls, ToString<T> f) {
        return "(" + CollectionUtils.asString(ls, ",", f) + ")";
    }

    public static <T> String asStringFinalSep(List<T> ls, String sep, ToString<T> f) {
        if (ls.size() == 0) {
            return "";
        }
        StringBuffer str = new StringBuffer();
        int i = 0;
        while (i < ls.size()) {
            T l = ls.get(i);
            if (l != null) {
                str.append(f.toString(l));
            } else {
                str.append("null");
            }
            str.append(sep);
            ++i;
        }
        return str.toString();
    }

    public static <T> void sort(List<T> ls, GenericUtils.GetField<T> f1) {
        CollectionUtils.sortInternal(ls, new GenericUtils.GetField[]{f1}, new boolean[]{true});
    }

    public static <T> void sortWithCache(List<T> ls, GenericUtils.GetField<T> f1) {
        CollectionUtils.sortInternalWithCache(ls, new GenericUtils.GetField[]{f1}, new boolean[]{true});
    }

    public static <T> void sort(List<T> ls, GenericUtils.GetField<T> f1, boolean asc1) {
        CollectionUtils.sortInternal(ls, new GenericUtils.GetField[]{f1}, new boolean[]{asc1});
    }

    public static <T> void sort(List<T> ls, GenericUtils.GetField<T> f1, GenericUtils.GetField<T> f2) {
        CollectionUtils.sortInternal(ls, new GenericUtils.GetField[]{f1, f2}, new boolean[]{true, true});
    }

    public static <T> void sort(List<T> ls, GenericUtils.GetField<T> f1, boolean asc1, GenericUtils.GetField<T> f2, boolean asc2) {
        CollectionUtils.sortInternal(ls, new GenericUtils.GetField[]{f1, f2}, new boolean[]{asc1, asc2});
    }

    public static <T> void sortWithCache(List<T> ls, GenericUtils.GetField<T> f1, boolean asc1, GenericUtils.GetField<T> f2, boolean asc2) {
        CollectionUtils.sortInternalWithCache(ls, new GenericUtils.GetField[]{f1, f2}, new boolean[]{asc1, asc2});
    }

    public static <T> void sort(List<T> ls, GenericUtils.GetField<T> f1, GenericUtils.GetField<T> f2, GenericUtils.GetField<T> f3) {
        CollectionUtils.sortInternal(ls, new GenericUtils.GetField[]{f1, f2, f3}, new boolean[]{true, true, true});
    }

    public static <T> void sort(List<T> ls, GenericUtils.GetField<T> f1, boolean asc1, GenericUtils.GetField<T> f2, boolean asc2, GenericUtils.GetField<T> f3, boolean asc3) {
        CollectionUtils.sortInternal(ls, new GenericUtils.GetField[]{f1, f2, f3}, new boolean[]{asc1, asc2, asc3});
    }

    public static <T> void sort(List<T> ls, GenericUtils.GetField<T> f1, GenericUtils.GetField<T> f2, GenericUtils.GetField<T> f3, GenericUtils.GetField<T> f4) {
        CollectionUtils.sortInternal(ls, new GenericUtils.GetField[]{f1, f2, f3, f4}, new boolean[]{true, true, true, true});
    }

    public static <T> void sort(List<T> ls, GenericUtils.GetField<T> f1, boolean asc1, GenericUtils.GetField<T> f2, boolean asc2, GenericUtils.GetField<T> f3, boolean asc3, GenericUtils.GetField<T> f4, boolean asc4) {
        CollectionUtils.sortInternal(ls, new GenericUtils.GetField[]{f1, f2, f3, f4}, new boolean[]{asc1, asc2, asc3, asc4});
    }

    public static <T> void sortInternal(List<T> ls, final GenericUtils.GetField<T>[] fs, final boolean[] asc) {
        Comparator c = new Comparator<T>(){

            @Override
            public int compare(T t1, T t2) {
                int i = 0;
                while (i < fs.length) {
                    GenericUtils.GetField f = fs[i];
                    int a = this.doCompare(f, t1, t2);
                    if (!asc[i]) {
                        a = -a;
                    }
                    if (a != 0) {
                        return a;
                    }
                    ++i;
                }
                return 0;
            }

            public int doCompare(GenericUtils.GetField<T> f, T t1, T t2) {
                Comparable o1 = (Comparable)f.getField(t1);
                Comparable o2 = (Comparable)f.getField(t2);
                if (o1 == null && o2 == null) {
                    return 0;
                }
                if (o1 == null) {
                    return -1;
                }
                if (o2 == null) {
                    return 1;
                }
                return o1.compareTo(o2);
            }
        };
        Collections.sort(ls, c);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> void sortInternalWithCache(List<T> ls, GenericUtils.GetField<T>[] fs, boolean[] asc) {
        void var5_6;
        ArrayList<SortCache<T>> caches = new ArrayList<SortCache<T>>();
        for (T t : ls) {
            SortCache<T> cache = new SortCache<T>(t, fs);
            caches.add(cache);
        }
        GenericUtils.GetField[] fs2 = new GenericUtils.GetField[fs.length];
        boolean bl = false;
        while (var5_6 < fs2.length) {
            void index = var5_6;
            fs2[var5_6] = arg_0 -> CollectionUtils.lambda$0((int)index, arg_0);
            ++var5_6;
        }
        CollectionUtils.sortInternal(caches, fs2, asc);
        ls.clear();
        for (SortCache sortCache : caches) {
            ls.add(sortCache.t);
        }
    }

    public static <T> void collatorSort(List<T> ls, Function<T, String> f1) {
        ls.sort((p1, p2) -> Collator.getInstance().compare((String)f1.apply(p1), (String)f1.apply(p2)));
    }

    public static <T> void collatorSort(List<T> ls, Function<T, String> f1, Function<T, String> f2) {
        Collator c = Collator.getInstance();
        ls.sort((p1, p2) -> {
            int a = c.compare((String)f1.apply(p1), (String)f1.apply(p2));
            if (a != 0) {
                return a;
            }
            a = c.compare((String)f2.apply(p1), (String)f2.apply(p2));
            return a;
        });
    }

    public static <T> T findMatching(List<T> ls, GenericUtils.ToBoolean<T> f1) {
        for (T t : ls) {
            if (!f1.toBoolean(t)) continue;
            return t;
        }
        return null;
    }

    public static <T> int findIndex(List<T> ls, GenericUtils.ToBoolean<T> f1) {
        int i = 0;
        while (i < ls.size()) {
            T t = ls.get(i);
            if (f1.toBoolean(t)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T> Date findMatching(List<T> ls, GenericUtils.ToBoolean<T> f1, GenericUtils.ToDate<T> field) {
        T t = CollectionUtils.findMatching(ls, f1);
        if (t != null) {
            return field.toDate(t);
        }
        return null;
    }

    public static <T, V> List<V> selectDistinct(List<T> ls, GenericUtils.GetFieldTyped<T, V> f1) {
        ArrayList<V> res = new ArrayList<V>();
        for (T t : ls) {
            V field = f1.getField(t);
            if (res.contains(field)) continue;
            res.add(field);
        }
        return res;
    }

    public static <T, V> List<V> select(List<T> ls, GenericUtils.GetFieldTyped<T, V> f1) {
        ArrayList<V> res = new ArrayList<V>();
        for (T t : ls) {
            V field = f1.getField(t);
            res.add(field);
        }
        return res;
    }

    public static <T> List<T> filter(List<T> ls, GenericUtils.ToBoolean<T> f1) {
        ArrayList<T> res = new ArrayList<T>();
        for (T t : ls) {
            if (!f1.toBoolean(t)) continue;
            res.add(t);
        }
        return res;
    }

    public static <T> boolean exists(List<T> ls, GenericUtils.ToBoolean<T> f1) {
        return CollectionUtils.findMatching(ls, f1) != null;
    }

    public static <T, V> List<V> convert(List<T> ls, GenericUtils.GetFieldTyped<T, V> f1) {
        ArrayList<V> res = new ArrayList<V>();
        for (T t : ls) {
            V field = f1.getField(t);
            res.add(field);
        }
        return res;
    }

    public static <T> T firstMatch(List<T> ls, GenericUtils.ToBoolean<T> f1) {
        for (T t : ls) {
            if (!f1.toBoolean(t)) continue;
            return t;
        }
        return null;
    }

    public static <T> int count(List<T> ls, GenericUtils.ToBoolean<T> f1) {
        int nb = 0;
        for (T t : ls) {
            if (!f1.toBoolean(t)) continue;
            ++nb;
        }
        return nb;
    }

    public static <IN> int accumulateInt(List<IN> ls, GenericUtils.GetFieldTyped<IN, Integer> f1) {
        int nb = 0;
        for (IN t : ls) {
            nb += f1.getField(t).intValue();
        }
        return nb;
    }

    public static <T> T getFirstOrNull(List<T> values) {
        if (values.size() == 0) {
            return null;
        }
        return values.get(0);
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap seen = new ConcurrentHashMap();
        return t -> seen.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    public static <T> void removeDuplicate(List<T> ls) {
        List l2 = ls.stream().distinct().collect(Collectors.toList());
        ls.clear();
        ls.addAll(l2);
    }

    public static <T, U> void forEach(List<T> ls, Function<T, List<U>> level1, Consumer<U> action) {
        ls.stream().flatMap(e -> ((List)level1.apply(e)).stream()).forEach(action);
    }

    public static <T, U, V> void forEach(List<T> ls, Function<T, List<U>> level1, Function<U, List<V>> level2, Consumer<V> action) {
        ls.stream().flatMap(e -> ((List)level1.apply(e)).stream()).flatMap(e -> ((List)level2.apply(e)).stream()).forEach(action);
    }

    public static <T> List<T> concat(List<T> l1, List<T> l2) {
        ArrayList<T> res = new ArrayList<T>();
        res.addAll(l1);
        res.addAll(l2);
        return res;
    }

    public static <T> T rangeClosedFirstNotNull(int firstIndex, int lastIndex, IntFunction<T> f) {
        int i = firstIndex;
        while (i <= lastIndex) {
            T t = f.apply(i);
            if (t != null) {
                return t;
            }
            ++i;
        }
        return null;
    }

    public static <T> T rangeFirstNotNull(int firstIndex, int lastIndex, IntFunction<T> f) {
        int i = firstIndex;
        while (i < lastIndex) {
            T t = f.apply(i);
            if (t != null) {
                return t;
            }
            ++i;
        }
        return null;
    }

    private static class SortCache<T> {
        public T t;
        public Object[] elts;
        public boolean[] calculated;
        public GenericUtils.GetField<T>[] fs;

        public SortCache(T t, GenericUtils.GetField<T>[] fs) {
            this.t = t;
            this.fs = fs;
            this.elts = new Object[fs.length];
            this.calculated = new boolean[fs.length];
            int i = 0;
            while (i < this.calculated.length) {
                this.calculated[i] = false;
                ++i;
            }
        }

        public Object getElt(int index) {
            if (!this.calculated[index]) {
                this.elts[index] = this.fs[index].getField(this.t);
                this.calculated[index] = true;
            }
            return this.elts[index];
        }
    }

    public static interface ToString<T> {
        public String toString(T var1);
    }
}

