/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.common;

import fr.amapj.common.AmapjRuntimeException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.codec.binary.Base64OutputStream;
import org.apache.commons.io.IOUtils;

public class GzipUtils {
    public static String compressByteArray(byte[] in) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Base64OutputStream b64os = new Base64OutputStream((OutputStream)baos, true, 0, null);
            GZIPOutputStream os = new GZIPOutputStream((OutputStream)b64os);
            os.write(in);
            os.close();
            return new String(baos.toByteArray(), "UTF-8");
        }
        catch (IOException e) {
            throw new AmapjRuntimeException(e);
        }
    }

    public static byte[] uncompressByteArray(String in) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(in.getBytes("UTF-8"));
            Base64InputStream b64is = new Base64InputStream((InputStream)bais);
            GZIPInputStream is = new GZIPInputStream((InputStream)b64is);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            IOUtils.copy((InputStream)is, (OutputStream)baos);
            baos.close();
            is.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new AmapjRuntimeException(e);
        }
    }

    public static String compress(String in) {
        try {
            return GzipUtils.compressByteArray(in.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new AmapjRuntimeException(e);
        }
    }

    public static String uncompress(String in) {
        try {
            return new String(GzipUtils.uncompressByteArray(in), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new AmapjRuntimeException(e);
        }
    }
}

