/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.common;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;

public class RandomUtils {
    public static String generatePasswordMaj(int length) {
        return RandomUtils.generatePassword(length, 'A', 26);
    }

    public static String generatePasswordMin(int length) {
        return RandomUtils.generatePassword(length, 'a', 26);
    }

    private static String generatePassword(int length, char firstChar, int nbCar) {
        try {
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            byte[] buf = new byte[length];
            int i = 0;
            while (i < length) {
                buf[i] = (byte)(firstChar + random.nextInt(nbCar));
                ++i;
            }
            return new String(buf);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException("Erreur inattendue", e);
        }
    }

    public static void main(String[] args) {
        String str;
        int i = 0;
        while (i < 100) {
            str = RandomUtils.generatePasswordMaj(10);
            System.out.println("str=" + str);
            ++i;
        }
        System.out.println("=============================================");
        i = 0;
        while (i < 100) {
            str = RandomUtils.generatePasswordMin(10);
            System.out.println("str=" + str);
            ++i;
        }
    }
}

