/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.common;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class SafeHtmlUtils {
    private static final RegExp AMP_RE = RegExp.compile("&", "g");
    private static final RegExp GT_RE = RegExp.compile(">", "g");
    private static final RegExp LT_RE = RegExp.compile("<", "g");
    private static final RegExp SQUOT_RE = RegExp.compile("'", "g");
    private static final RegExp QUOT_RE = RegExp.compile("\"", "g");

    public static String htmlEscape(String s) {
        if (s.indexOf("&") != -1) {
            s = AMP_RE.replace(s, "&amp;");
        }
        if (s.indexOf("<") != -1) {
            s = LT_RE.replace(s, "&lt;");
        }
        if (s.indexOf(">") != -1) {
            s = GT_RE.replace(s, "&gt;");
        }
        if (s.indexOf("\"") != -1) {
            s = QUOT_RE.replace(s, "&quot;");
        }
        if (s.indexOf("'") != -1) {
            s = SQUOT_RE.replace(s, "&#39;");
        }
        return s;
    }

    private SafeHtmlUtils() {
    }

    private static class MatchResult {
        private final List<String> groups;
        private final int index;
        private final String input;

        public MatchResult(int index, String input, List<String> groups) {
            this.index = index;
            this.input = input;
            this.groups = new ArrayList<String>(groups);
        }

        public String getGroup(int index) {
            return this.groups.get(index);
        }

        public int getGroupCount() {
            return this.groups.size();
        }

        public int getIndex() {
            return this.index;
        }

        public String getInput() {
            return this.input;
        }
    }

    private static class RegExp {
        private static final Pattern REPLACEMENT_BACKSLASH = Pattern.compile("\\\\");
        private static final String REPLACEMENT_BACKSLASH_FOR_JAVA = "\\\\\\\\";
        private static final Pattern REPLACEMENT_DOLLAR_AMPERSAND = Pattern.compile("((?:^|\\G|[^$])(?:\\$\\$)*)\\$&");
        private static final String REPLACEMENT_DOLLAR_AMPERSAND_FOR_JAVA = "$1\\$0";
        private static final Pattern REPLACEMENT_DOLLAR_APOSTROPHE = Pattern.compile("(?:^|[^$])(?:\\$\\$)*\\$[`']");
        private static final Pattern REPLACEMENT_DOLLAR_DOLLAR = Pattern.compile("\\$\\$");
        private static final String REPLACEMENT_DOLLAR_DOLLAR_FOR_JAVA = "\\\\\\$";
        private final boolean globalFlag;
        private int lastIndex;
        private final Pattern pattern;
        private final String source;

        public static RegExp compile(String pattern) {
            return RegExp.compile(pattern, "");
        }

        public static RegExp compile(String pattern, String flags) {
            boolean globalFlag = false;
            int javaPatternFlags = 1;
            for (char flag : RegExp.parseFlags(flags)) {
                switch (flag) {
                    case 'g': {
                        globalFlag = true;
                        break;
                    }
                    case 'i': {
                        javaPatternFlags |= 0x42;
                        break;
                    }
                    case 'm': {
                        javaPatternFlags |= 8;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException("Unknown regexp flag: '" + flag + "'");
                    }
                }
            }
            Pattern javaPattern = Pattern.compile(pattern, javaPatternFlags);
            return new RegExp(pattern, javaPattern, globalFlag);
        }

        public static String quote(String input) {
            return Pattern.quote(input);
        }

        private static Set<Character> parseFlags(String flags) {
            HashSet<Character> flagsSet = new HashSet<Character>(flags.length());
            int flagIndex = 0;
            while (flagIndex < flags.length()) {
                char flag = flags.charAt(flagIndex);
                if (!flagsSet.add(Character.valueOf(flag))) {
                    throw new IllegalArgumentException("Flag cannot be specified twice: '" + flag + "'");
                }
                ++flagIndex;
            }
            return flagsSet;
        }

        private RegExp(String source, Pattern pattern, boolean globalFlag) {
            this.source = source;
            this.pattern = pattern;
            this.globalFlag = globalFlag;
            this.lastIndex = 0;
        }

        public MatchResult exec(String input) {
            Matcher matcher;
            int searchStartIndex;
            int n = searchStartIndex = this.globalFlag ? this.lastIndex : 0;
            if (input == null || searchStartIndex < 0 || searchStartIndex > input.length()) {
                matcher = null;
            } else {
                matcher = this.pattern.matcher(input);
                if (!matcher.find(searchStartIndex)) {
                    matcher = null;
                }
            }
            if (matcher != null) {
                int groupCount = matcher.groupCount();
                ArrayList<String> groups = new ArrayList<String>(1 + groupCount);
                int group = 0;
                while (group <= groupCount) {
                    groups.add(matcher.group(group));
                    ++group;
                }
                if (this.globalFlag) {
                    this.lastIndex = matcher.end();
                }
                return new MatchResult(matcher.start(), input, groups);
            }
            if (this.globalFlag) {
                this.lastIndex = 0;
            }
            return null;
        }

        public boolean getGlobal() {
            return this.globalFlag;
        }

        public boolean getIgnoreCase() {
            return (this.pattern.flags() & 2) != 0;
        }

        public int getLastIndex() {
            return this.lastIndex;
        }

        public boolean getMultiline() {
            return (this.pattern.flags() & 8) != 0;
        }

        public String getSource() {
            return this.source;
        }

        public String replace(String input, String replacement) {
            replacement = REPLACEMENT_BACKSLASH.matcher(replacement).replaceAll(REPLACEMENT_BACKSLASH_FOR_JAVA);
            if (REPLACEMENT_DOLLAR_APOSTROPHE.matcher(replacement = REPLACEMENT_DOLLAR_AMPERSAND.matcher(replacement).replaceAll(REPLACEMENT_DOLLAR_AMPERSAND_FOR_JAVA)).find()) {
                throw new UnsupportedOperationException("$` and $' replacements are not supported");
            }
            replacement = REPLACEMENT_DOLLAR_DOLLAR.matcher(replacement).replaceAll(REPLACEMENT_DOLLAR_DOLLAR_FOR_JAVA);
            return this.globalFlag ? this.pattern.matcher(input).replaceAll(replacement) : this.pattern.matcher(input).replaceFirst(replacement);
        }

        public void setLastIndex(int lastIndex) {
            this.lastIndex = lastIndex;
        }

        public SplitResult split(String input) {
            return this.split(input, -1);
        }

        public SplitResult split(String input, int limit) {
            String[] result;
            if (this.source.length() == 0) {
                int resultLength = input.length();
                if (resultLength > limit && limit >= 0) {
                    resultLength = limit;
                }
                result = new String[resultLength];
                int i = 0;
                while (i < resultLength) {
                    result[i] = input.substring(i, i + 1);
                    ++i;
                }
            } else {
                result = this.pattern.split(input, limit < 0 ? -1 : limit + 1);
                if (result.length > limit && limit >= 0) {
                    String[] realResult = new String[limit];
                    int i = 0;
                    while (i < limit) {
                        realResult[i] = result[i];
                        ++i;
                    }
                    result = realResult;
                }
            }
            return new SplitResult(result);
        }

        public boolean test(String input) {
            return this.exec(input) != null;
        }
    }

    private static class SplitResult {
        private final String[] result;

        public SplitResult(String[] result) {
            this.result = result;
        }

        public String get(int index) {
            return this.result[index];
        }

        public int length() {
            return this.result.length;
        }

        public void set(int index, String value) {
            this.result[index] = value;
        }
    }
}

