/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.common;

import fr.amapj.common.StackUtils;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;

public class SequenceFileInputStream
extends InputStream {
    List<String> fileNames;
    InputStream in;
    int current = -1;

    public SequenceFileInputStream(List<String> fileNames) {
        this.fileNames = fileNames;
        try {
            this.nextStream();
        }
        catch (IOException iOException) {
            throw new Error("panic");
        }
    }

    final void nextStream() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
        this.in = this.getNext();
    }

    @Override
    public int available() throws IOException {
        if (this.in == null) {
            return 0;
        }
        return this.in.available();
    }

    @Override
    public int read() throws IOException {
        while (this.in != null) {
            int c = this.in.read();
            if (c != -1) {
                return c;
            }
            this.nextStream();
        }
        return -1;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.in == null) {
            return -1;
        }
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        do {
            int n;
            if ((n = this.in.read(b, off, len)) > 0) {
                return n;
            }
            this.nextStream();
        } while (this.in != null);
        return -1;
    }

    @Override
    public void close() throws IOException {
        if (this.in != null) {
            this.in.close();
        }
    }

    private InputStream getNext() {
        ++this.current;
        if (this.current >= this.fileNames.size()) {
            return null;
        }
        String fileName = this.fileNames.get(this.current);
        try {
            return new FileInputStream(fileName);
        }
        catch (FileNotFoundException e) {
            String message = "Impossible de charger le fichier." + StackUtils.asString(e) + "\n";
            return new ByteArrayInputStream(message.getBytes());
        }
    }
}

