/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.common.collections;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.CollectionUtils;
import fr.amapj.common.GenericUtils;
import fr.amapj.common.collections.ComparatorByField;
import fr.amapj.common.collections.ab.TwoGetFieldHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class G2D<LIG, COL, CONTENT> {
    private List<CONTENT> items;
    private List<TwoGetFieldHolder<LIG, CONTENT>> ligSortGetField = new ArrayList<TwoGetFieldHolder<LIG, CONTENT>>();
    private List<Boolean> ligSortAscendant = new ArrayList<Boolean>();
    private List<TwoGetFieldHolder<COL, CONTENT>> colSortGetField = new ArrayList<TwoGetFieldHolder<COL, CONTENT>>();
    private List<Boolean> colSortAscendant = new ArrayList<Boolean>();
    private List<GenericUtils.GetField<CONTENT>> cellSortGetField = new ArrayList<GenericUtils.GetField<CONTENT>>();
    private List<Boolean> cellSortAscendant = new ArrayList<Boolean>();
    private GenericUtils.GetFieldTyped<CONTENT, LIG> groupByLig;
    private GenericUtils.GetFieldTyped<CONTENT, COL> groupByCol;
    private boolean computeDone = false;
    private List<List<Cell2<LIG, COL, CONTENT>>> content = new ArrayList<List<Cell2<LIG, COL, CONTENT>>>();
    private List<LIG> enteteLigs;
    private List<COL> enteteCols;
    private List<InternalCell2<LIG, CONTENT>> fullEnteteLigs;
    private List<InternalCell2<COL, CONTENT>> fullEnteteCols;

    public G2D<LIG, COL, CONTENT> fill(List<CONTENT> items) {
        this.items = items;
        return this;
    }

    public G2D<LIG, COL, CONTENT> groupByLig(GenericUtils.GetFieldTyped<CONTENT, LIG> groupByLig) {
        this.groupByLig = groupByLig;
        return this;
    }

    public G2D<LIG, COL, CONTENT> groupByCol(GenericUtils.GetFieldTyped<CONTENT, COL> groupByCol) {
        this.groupByCol = groupByCol;
        return this;
    }

    public void sortLig(GenericUtils.GetField<LIG> f, boolean asc) {
        TwoGetFieldHolder f1 = new TwoGetFieldHolder();
        f1.initA(f);
        this.ligSortGetField.add(f1);
        this.ligSortAscendant.add(asc);
    }

    public void sortLigNatural(boolean asc) {
        TwoGetFieldHolder f1 = new TwoGetFieldHolder();
        f1.initA(e -> e);
        this.ligSortGetField.add(f1);
        this.ligSortAscendant.add(asc);
    }

    public void sortLigAdvanced(GenericUtils.GetField<CONTENT> f, boolean asc) {
        TwoGetFieldHolder f1 = new TwoGetFieldHolder();
        f1.initB(f);
        this.ligSortGetField.add(f1);
        this.ligSortAscendant.add(asc);
    }

    public void sortCol(GenericUtils.GetField<COL> f, boolean asc) {
        TwoGetFieldHolder f1 = new TwoGetFieldHolder();
        f1.initA(f);
        this.colSortGetField.add(f1);
        this.colSortAscendant.add(asc);
    }

    public void sortColNatural(boolean asc) {
        TwoGetFieldHolder f1 = new TwoGetFieldHolder();
        f1.initA(e -> e);
        this.colSortGetField.add(f1);
        this.colSortAscendant.add(asc);
    }

    public void sortColAdvanced(GenericUtils.GetField<CONTENT> f, boolean asc) {
        TwoGetFieldHolder f1 = new TwoGetFieldHolder();
        f1.initB(f);
        this.colSortGetField.add(f1);
        this.colSortAscendant.add(asc);
    }

    public void sortCell(GenericUtils.GetField<CONTENT> f, boolean asc) {
        this.cellSortGetField.add(f);
        this.cellSortAscendant.add(asc);
    }

    public void sortCellNatural(boolean asc) {
        this.cellSortGetField.add(e -> e);
        this.cellSortAscendant.add(asc);
    }

    public G2D<LIG, COL, CONTENT> compute() {
        boolean asc;
        GenericUtils.GetField<Object> f;
        TwoGetFieldHolder<Object, CONTENT> holder;
        if (this.groupByLig == null) {
            throw new AmapjRuntimeException("Vous devez appeler d'abord la m\u00e9thode groupByLig");
        }
        if (this.groupByCol == null) {
            throw new AmapjRuntimeException("Vous devez appeler d'abord la m\u00e9thode groupByCol");
        }
        Map<Key2<LIG, COL>, List<CONTENT>> map = this.items.stream().collect(Collectors.groupingBy(e -> new Key2<LIG, COL>(this.groupByLig.getField(e), this.groupByCol.getField(e))));
        if (this.cellSortGetField.size() > 0) {
            ComparatorByField comparator = new ComparatorByField(this.cellSortGetField, this.cellSortAscendant);
            for (List<CONTENT> cells : map.values()) {
                Collections.sort(cells, comparator);
            }
        }
        this.fullEnteteLigs = this.computeEnteteLig(map);
        this.fullEnteteCols = this.computeEnteteCol(map);
        if (this.ligSortGetField.size() > 0) {
            ComparatorByField<InternalCell2> comparatorLig = new ComparatorByField<InternalCell2>();
            int i = 0;
            while (i < this.ligSortGetField.size()) {
                holder = this.ligSortGetField.get(i);
                if (holder.isA()) {
                    f = holder.getGetFieldA();
                    asc = this.ligSortAscendant.get(i);
                    comparatorLig.add(e -> f.getField(e.a), asc);
                } else {
                    f = holder.getGetFieldB();
                    asc = this.ligSortAscendant.get(i);
                    comparatorLig.add(e -> f.getField(e.b), asc);
                }
                ++i;
            }
            Collections.sort(this.fullEnteteLigs, comparatorLig);
        }
        this.enteteLigs = this.fullEnteteLigs.stream().map(e -> e.a).collect(Collectors.toList());
        if (this.colSortGetField.size() > 0) {
            ComparatorByField<InternalCell2> comparatorCol = new ComparatorByField<InternalCell2>();
            int i = 0;
            while (i < this.colSortGetField.size()) {
                holder = this.colSortGetField.get(i);
                if (holder.isA()) {
                    f = holder.getGetFieldA();
                    asc = this.colSortAscendant.get(i);
                    comparatorCol.add(e -> f.getField(e.a), asc);
                } else {
                    f = holder.getGetFieldB();
                    asc = this.colSortAscendant.get(i);
                    comparatorCol.add(e -> f.getField(e.b), asc);
                }
                ++i;
            }
            Collections.sort(this.fullEnteteCols, comparatorCol);
        }
        this.enteteCols = this.fullEnteteCols.stream().map(e -> e.a).collect(Collectors.toList());
        for (LIG lig : this.enteteLigs) {
            ArrayList ligneCells = new ArrayList(this.enteteCols.size());
            for (COL col : this.enteteCols) {
                List values = map.getOrDefault(new Key2<LIG, COL>(lig, col), Collections.emptyList());
                Cell2 cell = new Cell2(lig, col, values);
                ligneCells.add(cell);
            }
            this.content.add(ligneCells);
        }
        this.computeDone = true;
        return this;
    }

    private List<InternalCell2<LIG, CONTENT>> computeEnteteLig(Map<Key2<LIG, COL>, List<CONTENT>> map) {
        Stream<Map.Entry> s = map.entrySet().stream().filter(CollectionUtils.distinctByKey(e -> ((Key2)e.getKey()).ligVal));
        return s.map(e -> new InternalCell2(((Key2)e.getKey()).ligVal, CollectionUtils.getFirstOrNull((List)e.getValue()))).collect(Collectors.toList());
    }

    private List<InternalCell2<COL, CONTENT>> computeEnteteCol(Map<Key2<LIG, COL>, List<CONTENT>> map) {
        Stream<Map.Entry> s = map.entrySet().stream().filter(CollectionUtils.distinctByKey(e -> ((Key2)e.getKey()).colVal));
        return s.map(e -> new InternalCell2(((Key2)e.getKey()).colVal, CollectionUtils.getFirstOrNull((List)e.getValue()))).collect(Collectors.toList());
    }

    public List<COL> getCols() {
        this.checkComputeDone();
        return this.enteteCols;
    }

    public List<LIG> getLigs() {
        this.checkComputeDone();
        return this.enteteLigs;
    }

    public List<List<CONTENT>> getLine(int index) {
        this.checkComputeDone();
        return this.content.get(index).stream().map(e -> e.values).collect(Collectors.toList());
    }

    public List<Cell2<LIG, COL, CONTENT>> getFullLine(int index) {
        this.checkComputeDone();
        return this.content.get(index);
    }

    public List<CONTENT> findCellContent(int ligIndex, COL col) {
        this.checkComputeDone();
        for (Cell2<LIG, COL, CONTENT> c : this.content.get(ligIndex)) {
            if (!c.col.equals(col)) continue;
            return c.values;
        }
        return Collections.emptyList();
    }

    private void checkComputeDone() {
        if (!this.computeDone) {
            throw new AmapjRuntimeException("Vous devez d'abord appeler la m\u00e9thode compute");
        }
    }

    public static class Cell2<LIG, COL, CONTENT> {
        public LIG lig;
        public COL col;
        public List<CONTENT> values;

        public Cell2(LIG lig, COL col, List<CONTENT> values) {
            this.lig = lig;
            this.col = col;
            this.values = values;
        }

        public Cell2() {
        }
    }

    private static class InternalCell2<A, B> {
        public A a;
        public B b;

        public InternalCell2(A a, B b) {
            this.a = a;
            this.b = b;
        }
    }

    public static class Key2<LIG, COL> {
        LIG ligVal;
        COL colVal;

        public Key2() {
        }

        public Key2(LIG ligVal, COL colVal) {
            this.ligVal = ligVal;
            this.colVal = colVal;
        }

        public boolean equals(Object o) {
            Key2 k = (Key2)o;
            return this.ligVal.equals(k.ligVal) && this.colVal.equals(k.colVal);
        }

        public int hashCode() {
            return this.ligVal.hashCode() + this.colVal.hashCode();
        }
    }
}

