/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.common.html;

import org.jsoup.Jsoup;
import org.jsoup.helper.StringUtil;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.NodeTraversor;
import org.jsoup.select.NodeVisitor;

public class HtmlToPlainText {
    public static String toPlainText(String htmlString) {
        Document doc = Jsoup.parse((String)htmlString);
        HtmlToPlainText formatter = new HtmlToPlainText();
        String plainText = formatter.getPlainText((Element)doc);
        return plainText;
    }

    public String getPlainText(Element element) {
        FormattingVisitor formatter = new FormattingVisitor();
        NodeTraversor traversor = new NodeTraversor((NodeVisitor)formatter);
        traversor.traverse((Node)element);
        return formatter.toString();
    }

    public static void main(String ... args) {
        String htmlString = "toto est <a href=\"http://127.0.0.1/toto.html\">link</a> que moi";
        String plainText = HtmlToPlainText.toPlainText(htmlString);
        System.out.println(plainText);
    }

    private class FormattingVisitor
    implements NodeVisitor {
        private static final int maxWidth = 80;
        private int width = 0;
        private StringBuilder accum = new StringBuilder();

        private FormattingVisitor() {
        }

        public void head(Node node, int depth) {
            String name = node.nodeName();
            if (node instanceof TextNode) {
                this.append(((TextNode)node).text());
            } else if (name.equals("li")) {
                this.append("\n * ");
            } else if (name.equals("dt")) {
                this.append("  ");
            } else if (StringUtil.in((String)name, (String[])new String[]{"p", "h1", "h2", "h3", "h4", "h5", "tr"})) {
                this.append("\n");
            }
        }

        public void tail(Node node, int depth) {
            String name = node.nodeName();
            if (StringUtil.in((String)name, (String[])new String[]{"br", "dd", "dt", "p", "h1", "h2", "h3", "h4", "h5"})) {
                this.append("\n");
            } else if (name.equals("a")) {
                this.append(String.format(" (%s)", node.absUrl("href")));
            }
        }

        private void append(String text) {
            if (text.startsWith("\n")) {
                this.width = 0;
            }
            if (text.equals(" ") && (this.accum.length() == 0 || StringUtil.in((String)this.accum.substring(this.accum.length() - 1), (String[])new String[]{" ", "\n"}))) {
                return;
            }
            if (text.length() + this.width > 80) {
                String[] words = text.split("\\s+");
                int i = 0;
                while (i < words.length) {
                    boolean last;
                    String word = words[i];
                    boolean bl = last = i == words.length - 1;
                    if (!last) {
                        word = String.valueOf(word) + " ";
                    }
                    if (word.length() + this.width > 80) {
                        this.accum.append("\n").append(word);
                        this.width = word.length();
                    } else {
                        this.accum.append(word);
                        this.width += word.length();
                    }
                    ++i;
                }
            } else {
                this.accum.append(text);
                this.width += text.length();
            }
        }

        public String toString() {
            return this.accum.toString();
        }
    }
}

