/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.model.engine.db;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.model.engine.dbms.DBMS;
import fr.amapj.model.engine.dbms.DBMSConf;
import fr.amapj.model.engine.dbms.hsqlexternal.HsqlExternalDbms;
import fr.amapj.model.engine.dbms.hsqlexternal.HsqlExternalDbmsConf;
import fr.amapj.model.engine.dbms.hsqlinternal.HsqlInternalDbms;
import fr.amapj.model.engine.dbms.hsqlinternal.HsqlInternalDbmsConf;
import fr.amapj.model.engine.tools.SpecificDbUtils;
import fr.amapj.model.engine.transaction.DataBaseInfo;
import fr.amapj.service.services.appinstance.AppInstanceDTO;
import fr.amapj.service.services.appinstance.AppState;
import fr.amapj.service.services.demoservice.DemoService;
import fr.amapj.service.services.demoservice.ReplaceDatabaseService;
import fr.amapj.service.services.session.SessionManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DbManager {
    private static final Logger logger = LogManager.getLogger();
    private DBMS dbms;
    private List<DataBaseInfo> dataBaseInfos;
    private ThreadLocal<DataBaseInfo> demonDbName = new ThreadLocal();
    private static DbManager mainInstance;
    private DBMSConf dbmsConf;
    private AppInstanceDTO masterConf;

    public static DbManager get() {
        return mainInstance;
    }

    public static void initialize(DBMSConf dbmsConf, AppInstanceDTO masterConf) {
        mainInstance = new DbManager(dbmsConf, masterConf);
    }

    private DbManager(DBMSConf dbmsConf, AppInstanceDTO masterConf) {
        this.dbmsConf = dbmsConf;
        this.masterConf = masterConf;
        this.dataBaseInfos = Collections.synchronizedList(new ArrayList());
    }

    public void startDbms() {
        this.dbms = this.createDBMS(this.dbmsConf);
        this.dbms.startDBMS();
    }

    private DBMS createDBMS(DBMSConf dbmsConf) {
        DBMS res;
        if (dbmsConf instanceof HsqlInternalDbmsConf) {
            res = new HsqlInternalDbms((HsqlInternalDbmsConf)dbmsConf);
        } else if (dbmsConf instanceof HsqlExternalDbmsConf) {
            res = new HsqlExternalDbms((HsqlExternalDbmsConf)dbmsConf);
        } else {
            throw new AmapjRuntimeException("Erreur");
        }
        return res;
    }

    public void startMasterBase() {
        this.addDataBase(this.masterConf, AppState.ON);
    }

    public void addDataBase(AppInstanceDTO dto, AppState state) {
        this.registerDataBase(dto.nomInstance, dto.dbUserName, dto.dbPassword);
        this.setDbState(dto.nomInstance, state);
    }

    public void stopDbms() {
        this.dbms.stopDBMS(this.dataBaseInfos);
    }

    public void createDataBase(AppInstanceDTO dto) {
        if (this.findDataBaseFromName(dto.nomInstance) != null) {
            throw new AmapjRuntimeException("La base existe d\u00e9j\u00e0");
        }
        DataBaseInfo dataBaseInfo = this.registerDataBase(dto.nomInstance, dto.dbUserName, dto.dbPassword);
        this.dbms.createOneBase(dataBaseInfo);
        this.setDbState(dto.nomInstance, AppState.ON);
        SpecificDbUtils.executeInSpecificDb(dto.nomInstance, () -> new DemoService().generateDemoData(dto));
    }

    public void replaceDataBase(DataBaseInfo dataBaseInfo, byte[] fileProperties, byte[] fileScript) {
        dataBaseInfo.closeEntityManagerFactory();
        this.dbms.replaceOneBase(dataBaseInfo, fileProperties, fileScript);
        dataBaseInfo.renewEntityManagerFactory();
        SpecificDbUtils.executeInSpecificDb(dataBaseInfo.dbName, () -> new ReplaceDatabaseService().resetAllPassword());
    }

    public DataBaseInfo getCurrentDb() {
        DataBaseInfo dbName = this.demonDbName.get();
        if (dbName == null) {
            dbName = SessionManager.getDb();
        }
        return dbName;
    }

    private DataBaseInfo registerDataBase(String dbName, String user, String password) {
        if (this.findDataBaseFromName(dbName) != null) {
            throw new AmapjRuntimeException("Il est interdit de cr\u00e9er deux fois la base de donn\u00e9es : " + dbName);
        }
        String[] us = this.dbms.computeUrlUserPassword(dbName, user, password);
        int puNumber = this.dataBaseInfos.size();
        DataBaseInfo dataBaseInfo = new DataBaseInfo(dbName, us[0], us[1], us[2], puNumber);
        this.dataBaseInfos.add(dataBaseInfo);
        return dataBaseInfo;
    }

    public DataBaseInfo findDataBaseFromName(String dbName) {
        if (dbName == null) {
            return null;
        }
        for (DataBaseInfo dataBaseInfo : this.dataBaseInfos) {
            if (!dataBaseInfo.getDbName().equals(dbName)) continue;
            return dataBaseInfo;
        }
        return null;
    }

    public void setDbForDeamonThread(DataBaseInfo dataBaseInfo) {
        this.demonDbName.set(dataBaseInfo);
    }

    public List<DataBaseInfo> getAllDbs() {
        return this.dataBaseInfos;
    }

    public DataBaseInfo getMasterDb() {
        return this.dataBaseInfos.get(0);
    }

    public void setDbState(String dbName, AppState appState) {
        DataBaseInfo dataBaseInfo = this.findDataBaseFromName(dbName);
        if (dataBaseInfo == null) {
            throw new AmapjRuntimeException("Base non trouv\u00e9e");
        }
        switch (dataBaseInfo.getState()) {
            case OFF: {
                this.changeStateFromOff(dataBaseInfo, appState);
                break;
            }
            case DATABASE_ONLY: {
                this.changeStateFromDatabaseOnly(dataBaseInfo, appState);
                break;
            }
            case ON: {
                this.changeStateFromOn(dataBaseInfo, appState);
                break;
            }
            default: {
                throw new AmapjRuntimeException("Erreur de programmation");
            }
        }
        dataBaseInfo.setState(appState);
    }

    private void changeStateFromOn(DataBaseInfo dataBaseInfo, AppState appState) {
        switch (appState) {
            case DATABASE_ONLY: 
            case ON: {
                break;
            }
            case OFF: {
                this.dbms.stopOneBase(dataBaseInfo);
                dataBaseInfo.closeEntityManagerFactory();
                break;
            }
            default: {
                throw new AmapjRuntimeException("Erreur de programmation");
            }
        }
    }

    private void changeStateFromDatabaseOnly(DataBaseInfo dataBaseInfo, AppState appState) {
        switch (appState) {
            case DATABASE_ONLY: 
            case ON: {
                break;
            }
            case OFF: {
                this.dbms.stopOneBase(dataBaseInfo);
                dataBaseInfo.closeEntityManagerFactory();
                break;
            }
            default: {
                throw new AmapjRuntimeException("Erreur de programmation");
            }
        }
    }

    private void changeStateFromOff(DataBaseInfo dataBaseInfo, AppState appState) {
        switch (appState) {
            case DATABASE_ONLY: 
            case ON: {
                this.dbms.startOneBase(dataBaseInfo);
                dataBaseInfo.renewEntityManagerFactory();
                break;
            }
            case OFF: {
                break;
            }
            default: {
                throw new AmapjRuntimeException("Erreur de programmation");
            }
        }
    }

    public int executeUpdateSqlCommand(String sqlCommand, AppInstanceDTO dto) throws SQLException {
        DataBaseInfo dataBaseInfo = this.findDataBaseFromName(dto.nomInstance);
        return this.dbms.executeUpdateSqlCommand(dataBaseInfo, sqlCommand);
    }

    public List<List<String>> executeQuerySqlCommand(String sqlCommand, AppInstanceDTO dto) throws SQLException {
        DataBaseInfo dataBaseInfo = this.findDataBaseFromName(dto.nomInstance);
        return this.dbms.executeQuerySqlCommand(dataBaseInfo, sqlCommand);
    }
}

