/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.model.engine.db;

import fr.amapj.model.engine.transaction.TransactionHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.persistence.logging.AbstractSessionLog;
import org.eclipse.persistence.logging.SessionLog;
import org.eclipse.persistence.logging.SessionLogEntry;

public class EclipseLinkLogger
extends AbstractSessionLog
implements SessionLog {
    private static final Logger log = LogManager.getLogger();
    private static final Logger logSQL = LogManager.getLogger((String)"SQL");

    public void log(SessionLogEntry entry) {
        if (entry.getNameSpace() != null && entry.getNameSpace().equals("metadata")) {
            return;
        }
        if (entry.getNameSpace() != null && entry.getNameSpace().equals("sql")) {
            if (logSQL.isDebugEnabled()) {
                logSQL.debug("id=" + TransactionHelper.getTransactionId() + " " + entry.getMessage());
            }
            return;
        }
        int level = entry.getLevel();
        String message = entry.getMessage();
        if (entry.getParameters() != null) {
            message = String.valueOf(message) + " [";
            int index = 0;
            Object[] objectArray = entry.getParameters();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                message = String.valueOf(message) + (index++ > 0 ? "," : "") + object;
                ++n2;
            }
            message = String.valueOf(message) + "]";
        }
        switch (level) {
            case 7: {
                log.error(message);
                break;
            }
            case 6: {
                log.warn(message);
                break;
            }
            case 5: {
                log.info(message);
                break;
            }
            case 4: {
                log.info(message);
                break;
            }
            default: {
                log.debug(message);
            }
        }
    }
}

