/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.model.engine.dbms.hsqlexternal;

import fr.amapj.model.engine.dbms.DBMS;
import fr.amapj.model.engine.dbms.DBMSTools;
import fr.amapj.model.engine.dbms.hsqlexternal.HsqlExternalDbmsConf;
import fr.amapj.model.engine.transaction.DataBaseInfo;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HsqlExternalDbms
implements DBMS {
    private static final Logger logger = LogManager.getLogger();
    private HsqlExternalDbmsConf conf;

    public HsqlExternalDbms(HsqlExternalDbmsConf conf) {
        this.conf = conf;
    }

    @Override
    public void startDBMS() {
    }

    @Override
    public void startOneBase(DataBaseInfo dataBaseInfo) {
    }

    @Override
    public void stopOneBase(DataBaseInfo dataBaseInfo) {
    }

    @Override
    public void stopDBMS(List<DataBaseInfo> dataBaseInfos) {
    }

    @Override
    public void createOneBase(DataBaseInfo dataBaseInfo) {
    }

    @Override
    public void replaceOneBase(DataBaseInfo dataBaseInfo, byte[] fileProperties, byte[] fileScript) {
    }

    @Override
    public int executeUpdateSqlCommand(DataBaseInfo dataBaseInfo, String sqlCommand) throws SQLException {
        Connection conn = this.getConnection(dataBaseInfo);
        Statement st = conn.createStatement();
        int res = st.executeUpdate(sqlCommand);
        conn.commit();
        conn.close();
        return res;
    }

    @Override
    public List<List<String>> executeQuerySqlCommand(DataBaseInfo dataBaseInfo, String sqlCommand) throws SQLException {
        Connection conn = this.getConnection(dataBaseInfo);
        Statement st = conn.createStatement();
        ResultSet resultset = st.executeQuery(sqlCommand);
        List<List<String>> result = DBMSTools.readResultSet(resultset);
        conn.commit();
        conn.close();
        return result;
    }

    private Connection getConnection(DataBaseInfo dataBaseInfo) throws SQLException {
        return DriverManager.getConnection(dataBaseInfo.url, dataBaseInfo.user, dataBaseInfo.password);
    }

    @Override
    public String[] computeUrlUserPassword(String dbName, String user, String password) {
        String[] res = new String[]{this.conf.createUrl(dbName), user, password};
        return res;
    }
}

