/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.model.engine.dbms.hsqlinternal;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.StackUtils;
import fr.amapj.model.engine.dbms.DBMS;
import fr.amapj.model.engine.dbms.DBMSTools;
import fr.amapj.model.engine.dbms.hsqlinternal.HsqlInternalDbmsConf;
import fr.amapj.model.engine.ddl.MakeSqlSchemaForEmptyDb;
import fr.amapj.model.engine.transaction.DataBaseInfo;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hsqldb.persist.HsqlProperties;
import org.hsqldb.server.Server;
import org.hsqldb.server.ServerConfiguration;

public class HsqlInternalDbms
implements DBMS {
    private static final Logger logger = LogManager.getLogger();
    private Server server;
    private HsqlInternalDbmsConf conf;

    public HsqlInternalDbms(HsqlInternalDbmsConf conf) {
        this.conf = conf;
    }

    @Override
    public void startDBMS() {
        try {
            Class.forName("org.hsqldb.jdbcDriver");
        }
        catch (ClassNotFoundException e1) {
            throw new AmapjRuntimeException("Erreur au chargement du driver hsqldb", e1);
        }
        HsqlProperties argProps = new HsqlProperties();
        argProps.setProperty("server.no_system_exit", "true");
        argProps.setProperty("server.port", this.conf.getPort());
        argProps.setProperty("server.remote_open", true);
        argProps.setProperty("server.maxdatabases", 200);
        ServerConfiguration.translateAddressProperty((HsqlProperties)argProps);
        this.server = new Server();
        try {
            this.server.setProperties(argProps);
        }
        catch (Exception e) {
            logger.warn("Impossible de d\u00e9marrer correctement le DBMS : " + StackUtils.asString(e));
            throw new RuntimeException("Impossible de d\u00e9marrer le DBMS");
        }
        this.server.start();
        this.server.checkRunning(true);
    }

    @Override
    public void startOneBase(DataBaseInfo dataBaseInfo) {
        String dbName = dataBaseInfo.getDbName();
        logger.info("Demarrage de la base " + dbName);
        String url1 = "jdbc:hsqldb:hsql://localhost:" + this.conf.getPort() + "/" + dbName + ";file:" + this.conf.getContentDirectory() + "/" + dbName;
        try {
            Connection conn = DriverManager.getConnection(url1, dataBaseInfo.user, dataBaseInfo.password);
            conn.close();
        }
        catch (SQLException e) {
            throw new AmapjRuntimeException("Impossible de cr\u00e9er correctement la base de donn\u00e9es url = " + url1, e);
        }
    }

    @Override
    public void stopOneBase(DataBaseInfo dataBaseInfo) {
        String dbName = dataBaseInfo.getDbName();
        logger.info("Arret de la base " + dbName);
        try {
            Connection conn = this.getConnection(dataBaseInfo);
            Statement st = conn.createStatement();
            st.execute("SHUTDOWN");
            conn.close();
        }
        catch (SQLException e) {
            logger.warn("Impossible d'arreter correctement la base de donn\u00e9es " + dataBaseInfo.url + "  " + StackUtils.asString(e));
        }
    }

    @Override
    public void stopDBMS(List<DataBaseInfo> dataBaseInfos) {
        for (DataBaseInfo dataBaseInfo : dataBaseInfos) {
            this.stopOneBase(dataBaseInfo);
        }
        this.server.shutdown();
        int i = 0;
        while (i < 15) {
            if (this.server.getState() == 16) {
                return;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
            logger.info("Attente de l'arret complet de la base " + i + "/15");
            ++i;
        }
    }

    @Override
    public int executeUpdateSqlCommand(DataBaseInfo dataBaseInfo, String sqlCommand) throws SQLException {
        Connection conn = this.getConnection(dataBaseInfo);
        Statement st = conn.createStatement();
        int res = st.executeUpdate(sqlCommand);
        conn.commit();
        conn.close();
        return res;
    }

    @Override
    public List<List<String>> executeQuerySqlCommand(DataBaseInfo dataBaseInfo, String sqlCommand) throws SQLException {
        Connection conn = this.getConnection(dataBaseInfo);
        Statement st = conn.createStatement();
        ResultSet resultset = st.executeQuery(sqlCommand);
        List<List<String>> result = DBMSTools.readResultSet(resultset);
        conn.commit();
        conn.close();
        return result;
    }

    @Override
    public void createOneBase(DataBaseInfo dataBaseInfo) {
        this.startOneBase(dataBaseInfo);
        if (this.numberOfTables(dataBaseInfo) != 0) {
            throw new AmapjRuntimeException("La base n'est pas vide");
        }
        String platform = "org.eclipse.persistence.platform.database.HSQLPlatform";
        String driver = "org.hsqldb.jdbcDriver";
        new MakeSqlSchemaForEmptyDb().createSqlSchema(dataBaseInfo.url, platform, driver, dataBaseInfo.user, dataBaseInfo.password);
        this.updateSequenceCounter(dataBaseInfo);
    }

    private void updateSequenceCounter(DataBaseInfo dataBaseInfo) {
        try {
            Connection conn = this.getConnection(dataBaseInfo);
            Statement st = conn.createStatement();
            st.execute("update SEQUENCE set SEQ_COUNT = 10000");
            conn.commit();
            conn.close();
        }
        catch (SQLException e) {
            throw new AmapjRuntimeException("Impossible d'acc\u00e8der la base de donn\u00e9es url = " + dataBaseInfo.url, e);
        }
    }

    private int numberOfTables(DataBaseInfo dataBaseInfo) {
        try {
            Connection conn = this.getConnection(dataBaseInfo);
            Statement st = conn.createStatement();
            st.execute("SELECT * FROM   INFORMATION_SCHEMA.TABLES where TABLE_SCHEMA='PUBLIC'");
            int nb = 0;
            ResultSet set = st.getResultSet();
            while (set.next()) {
                ++nb;
            }
            conn.close();
            return nb;
        }
        catch (SQLException e) {
            throw new AmapjRuntimeException("Impossible d'acc\u00e8der la base de donn\u00e9es url = " + dataBaseInfo.url, e);
        }
    }

    @Override
    public void replaceOneBase(DataBaseInfo dataBaseInfo, byte[] fileProperties, byte[] fileScript) {
        this.stopOneBase(dataBaseInfo);
        String dirDest = this.conf.getContentDirectory();
        try {
            FileUtils.writeByteArrayToFile((File)new File(String.valueOf(dirDest) + "/" + dataBaseInfo.dbName + ".properties"), (byte[])fileProperties);
            FileUtils.writeByteArrayToFile((File)new File(String.valueOf(dirDest) + "/" + dataBaseInfo.dbName + ".script"), (byte[])fileScript);
        }
        catch (IOException e) {
            throw new AmapjRuntimeException(e);
        }
        this.startOneBase(dataBaseInfo);
    }

    @Override
    public String[] computeUrlUserPassword(String dbName, String user, String password) {
        String[] res = new String[]{this.conf.createUrl(dbName), "SA", ""};
        return res;
    }

    private Connection getConnection(DataBaseInfo dataBaseInfo) throws SQLException {
        return DriverManager.getConnection(dataBaseInfo.url, dataBaseInfo.user, dataBaseInfo.password);
    }
}

