/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.model.engine.metadata;

import fr.amapj.common.AmapjRuntimeException;
import java.util.ArrayList;
import java.util.List;

public abstract class MetaDataEnum {
    private HelpInfo helpInfo = new HelpInfo();

    public abstract void fill();

    public void add(String texte) {
        this.add(null, texte, null);
    }

    public void addLink(String texte, String textLink, String link) {
        this.add(MetaDataEnum.createLink(texte, textLink, link));
    }

    public void addLink(String textLink, String link) {
        this.add(MetaDataEnum.createLink(textLink, link));
    }

    public void addBrLink(String textLink, String link) {
        this.add("<br/>" + MetaDataEnum.createLink(textLink, link));
    }

    public static String createLink(String texte, String textLink, String link) {
        return String.valueOf(texte) + "<a target=\"_blank\" href=\"https://amapj.fr/" + link + "\">" + textLink + "</a><br/>";
    }

    public static String createLink(String textLink, String link) {
        String texte = "Vous trouverez ici une documentation compl\u00e8te sur : ";
        return MetaDataEnum.createLink(texte, textLink, link);
    }

    public void add(Enum en, String lib) {
        this.add(en, lib, null);
    }

    public void add(Enum en, String lib, String aide) {
        this.helpInfo.add(en, lib, aide);
    }

    public HelpInfo getHelpInfo() {
        return this.helpInfo;
    }

    public static HelpInfo getHelpInfo(Class en) {
        try {
            Class<?>[] cls;
            Class<?>[] classArray = cls = en.getDeclaredClasses();
            int n = cls.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> cl = classArray[n2];
                if (MetaDataEnum.class.isAssignableFrom(cl)) {
                    MetaDataEnum enumHelp = (MetaDataEnum)cl.newInstance();
                    enumHelp.fill();
                    return enumHelp.getHelpInfo();
                }
                ++n2;
            }
        }
        catch (IllegalAccessException | InstantiationException | SecurityException e) {
            throw new AmapjRuntimeException(e);
        }
        return null;
    }

    public static class HelpInfo {
        List<HelpInfoEntry> libs = new ArrayList<HelpInfoEntry>();

        public void add(Enum en, String lib, String aide) {
            HelpInfoEntry e = new HelpInfoEntry();
            e.en = en;
            e.lib = lib;
            e.aide = aide;
            this.libs.add(e);
        }

        public String getLib(Enum en) {
            String lib = null;
            for (HelpInfoEntry entry : this.libs) {
                if (entry.en != en) continue;
                lib = entry.lib;
            }
            if (lib == null) {
                lib = en.toString();
            }
            return lib;
        }

        public String getAide(Enum en) {
            for (HelpInfoEntry entry : this.libs) {
                if (entry.en != en) continue;
                return entry.aide;
            }
            return "";
        }

        public String getFullText(Enum[] enumsToExcludes) {
            String fullText = "";
            for (HelpInfoEntry entry : this.libs) {
                if (entry.en == null) {
                    fullText = String.valueOf(fullText) + entry.lib + "<br/>";
                    continue;
                }
                if (!this.isPresent(entry.en, enumsToExcludes)) continue;
                fullText = entry.aide != null ? String.valueOf(fullText) + "<br/><b>" + entry.lib + "</b><br/>" + entry.aide + "<br/>" : String.valueOf(fullText) + "<br/><b>" + entry.lib + "</b><br/>";
            }
            return fullText;
        }

        private boolean isPresent(Enum en, Enum[] enumsToExcludes) {
            if (enumsToExcludes == null) {
                return true;
            }
            Enum[] enumArray = enumsToExcludes;
            int n = enumsToExcludes.length;
            int n2 = 0;
            while (n2 < n) {
                Enum en1 = enumArray[n2];
                if (en1 == en) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }

    private static class HelpInfoEntry {
        private Enum en;
        private String lib;
        private String aide;

        private HelpInfoEntry() {
        }
    }
}

