/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.model.engine.tools;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.MethodCallUtil;
import fr.amapj.model.engine.db.DbManager;
import fr.amapj.model.engine.tools.SpecificDbImpl;
import fr.amapj.model.engine.transaction.DataBaseInfo;
import fr.amapj.service.services.appinstance.AppState;
import java.util.ArrayList;
import java.util.List;

public class SpecificDbUtils {
    public static <RESULT> RESULT executeInSpecificDb(String dbName, SpecificDbImpl<RESULT> deamon) {
        MethodCallUtil<RESULT, DataBaseInfo> ret = SpecificDbUtils.executeInSpecificDbNoException(dbName, deamon);
        if (ret.throwable != null) {
            throw new AmapjRuntimeException("Une erreur est survenue dans la base <" + dbName + ">", ret.throwable);
        }
        return ret.result;
    }

    public static <RESULT> RESULT executeInMaster(SpecificDbImpl<RESULT> deamon) {
        return SpecificDbUtils.executeInSpecificDb(DbManager.get().getMasterDb().dbName, deamon);
    }

    public static <RESULT> MethodCallUtil<RESULT, DataBaseInfo> executeInSpecificDbNoException(String dbName, SpecificDbImpl<RESULT> deamon) {
        MethodCallUtil ret = new MethodCallUtil();
        DataBaseInfo dataBaseInfo = DbManager.get().findDataBaseFromName(dbName);
        ret.context = dataBaseInfo;
        if (dataBaseInfo == null || dataBaseInfo.getState() != AppState.ON) {
            ret.throwable = new AmapjRuntimeException("La base <" + dbName + "> est inconnue ou non active");
            return ret;
        }
        Object res = null;
        Throwable throwable = null;
        DbManager.get().setDbForDeamonThread(dataBaseInfo);
        try {
            res = deamon.perform();
        }
        catch (Throwable t) {
            throwable = t;
        }
        DbManager.get().setDbForDeamonThread(null);
        ret.result = res;
        ret.throwable = throwable;
        return ret;
    }

    public static <RESULT> List<MethodCallUtil<RESULT, DataBaseInfo>> executeInAllDb(SpecificDbImpl<RESULT> deamon, boolean continueOnFail) {
        ArrayList<MethodCallUtil<RESULT, DataBaseInfo>> res = new ArrayList<MethodCallUtil<RESULT, DataBaseInfo>>();
        ArrayList<DataBaseInfo> dataBaseInfos = new ArrayList<DataBaseInfo>(DbManager.get().getAllDbs());
        for (DataBaseInfo dataBaseInfo : dataBaseInfos) {
            if (dataBaseInfo.getState() != AppState.ON) continue;
            MethodCallUtil<RESULT, DataBaseInfo> result = SpecificDbUtils.executeInSpecificDbNoException(dataBaseInfo.getDbName(), deamon);
            if (!continueOnFail && result.throwable != null) {
                throw new AmapjRuntimeException("Une erreur est survenue dans la base -" + dataBaseInfo.getDbName() + "-", result.throwable);
            }
            res.add(result);
        }
        return res;
    }
}

