/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.model.engine.transaction;

import fr.amapj.model.engine.db.DbManager;
import fr.amapj.model.engine.rdblink.RdbLink;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class NewTransaction {
    private static final Logger logger = LogManager.getLogger();

    public static <T> T writeWithResult(Function<RdbLink, T> fn) {
        EntityManager em = DbManager.get().getCurrentDb().createEntityManager();
        return NewTransaction.write(fn, em);
    }

    public static void write(Consumer<RdbLink> consumer) {
        Function<RdbLink, Void> fn = e -> {
            consumer.accept((RdbLink)e);
            return null;
        };
        NewTransaction.writeWithResult(fn);
    }

    private static <T> T write(Function<RdbLink, T> fn, EntityManager em) {
        EntityTransaction transac = em.getTransaction();
        transac.begin();
        T result = null;
        try {
            logger.info("D\u00e9but d'une NOUVELLE transaction en ecriture");
            result = fn.apply(new RdbLink(em));
        }
        catch (Throwable t) {
            logger.info("Rollback d'une NOUVELLE transaction en ecriture");
            transac.rollback();
            em.close();
            throw t;
        }
        logger.info("D\u00e9but commit d'une NOUVELLE transaction en ecriture");
        transac.commit();
        em.close();
        logger.info("Fin commit d'une NOUVELLE transaction en ecriture");
        return result;
    }

    public static <T> T writeInMasterWithResult(Function<RdbLink, T> fn) {
        EntityManager em = DbManager.get().getMasterDb().createEntityManager();
        return NewTransaction.write(fn, em);
    }

    public static void writeInMaster(Consumer<RdbLink> consumer) {
        Function<RdbLink, Void> fn = e -> {
            consumer.accept((RdbLink)e);
            return null;
        };
        NewTransaction.writeInMasterWithResult(fn);
    }
}

