/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.model.models.fichierbase;

import fr.amapj.model.engine.Identifiable;
import fr.amapj.model.models.editionspe.EditionSpecifique;
import fr.amapj.model.models.fichierbase.EtatProducteur;
import fr.amapj.model.models.fichierbase.ProducteurNotificationRetardataire;
import fr.amapj.model.models.fichierbase.ProducteurStockGestion;
import fr.amapj.model.models.param.ChoixOuiNon;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.UniqueConstraint;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"nom"})})
public class Producteur
implements Identifiable {
    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    public Long id;
    @NotNull
    @Size(min=1, max=100)
    @Column(length=100)
    public String nom;
    @Size(min=1, max=2048)
    @Column(length=2048)
    public String description;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    public ChoixOuiNon feuilleDistributionGrille;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    public ChoixOuiNon feuilleDistributionListe;
    @ManyToOne
    public EditionSpecifique etiquette;
    @Size(min=0, max=255)
    @Column(length=255)
    public String libContrat;
    @NotNull
    public int delaiModifContrat;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    public EtatProducteur etat = EtatProducteur.ACTIF;
    @NotNull
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date dateCreation;
    @Temporal(value=TemporalType.TIMESTAMP)
    public Date dateModification;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    public ProducteurStockGestion gestionStock;
    @NotNull
    @Enumerated(value=EnumType.STRING)
    public ProducteurNotificationRetardataire notificationRetardataire;

    @Override
    public Long getId() {
        return this.id;
    }

    @Override
    public void setId(Long id) {
        this.id = id;
    }
}

