/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.model.models.produitextended.qtedispostock;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.DateUtils;
import fr.amapj.model.models.contrat.modele.StockIdentiqueDate;
import fr.amapj.model.models.produitextended.qtedispostock.QteDispoStockProduit;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class QteDispoStock {
    public List<QteDispoStockProduit> qteDispoStockProduits;

    public void setDefault() {
        if (this.qteDispoStockProduits == null) {
            this.qteDispoStockProduits = new ArrayList<QteDispoStockProduit>();
        }
    }

    public int findQteDispo(StockIdentiqueDate stockIdentiqueDate, Date date, Long idProduit) {
        switch (stockIdentiqueDate) {
            case OUI: {
                return this.findQteDispoStockIdentiqueDate(idProduit);
            }
            case NON: {
                return this.findQteDispoStockDifferentDate(date, idProduit);
            }
        }
        throw new AmapjRuntimeException();
    }

    private int findQteDispoStockIdentiqueDate(Long produitId) {
        QteDispoStockProduit infoProduit = this.findInfoProduit(null, produitId);
        if (infoProduit == null) {
            return 0;
        }
        return infoProduit.qte;
    }

    public void updateQteMaxiStockIdentiqueDate(Long produitId, int qteSaisie) {
        QteDispoStockProduit infoProduit = this.findInfoProduit(null, produitId);
        if (infoProduit == null) {
            infoProduit = new QteDispoStockProduit();
            infoProduit.idProduit = produitId;
            infoProduit.date = null;
            this.qteDispoStockProduits.add(infoProduit);
        }
        infoProduit.qte = qteSaisie;
    }

    private int findQteDispoStockDifferentDate(Date date, Long produitId) {
        QteDispoStockProduit infoProduit = this.findInfoProduit(date, produitId);
        if (infoProduit == null) {
            return 0;
        }
        return infoProduit.qte;
    }

    public void updateQteMaxiStockDifferentDate(Date date, Long produitId, int qteSaisie) {
        QteDispoStockProduit infoProduit = this.findInfoProduit(date, produitId);
        if (qteSaisie == 0) {
            if (infoProduit == null) {
                return;
            }
            this.qteDispoStockProduits.remove(infoProduit);
            return;
        }
        if (infoProduit == null) {
            infoProduit = new QteDispoStockProduit();
            infoProduit.idProduit = produitId;
            infoProduit.date = date;
            this.qteDispoStockProduits.add(infoProduit);
        }
        infoProduit.qte = qteSaisie;
    }

    private QteDispoStockProduit findInfoProduit(Date date, Long produitId) {
        for (QteDispoStockProduit stockInfoProduit : this.qteDispoStockProduits) {
            if (!stockInfoProduit.idProduit.equals(produitId) || !DateUtils.equals(stockInfoProduit.date, date)) continue;
            return stockInfoProduit;
        }
        return null;
    }
}

