/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.engine.excelreader;

import fr.amapj.model.engine.tools.TestTools;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.service.services.utilisateur.UtilisateurService;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.ss.usermodel.Row;

public class ExcelReader {
    public List<String[]> readFile(String fileName, int nbCol) throws IOException {
        ArrayList<String[]> res = new ArrayList<String[]>();
        FileInputStream file = new FileInputStream(new File(fileName));
        HSSFWorkbook workbook = new HSSFWorkbook((InputStream)file);
        HSSFSheet sheet = workbook.getSheetAt(0);
        Iterator rowIterator = sheet.iterator();
        DataFormatter df = new DataFormatter(Locale.FRANCE);
        while (rowIterator.hasNext()) {
            Row row = (Row)rowIterator.next();
            String[] strCell = new String[nbCol];
            int i = 0;
            while (i < strCell.length) {
                strCell[i] = this.getValue(row, i, df);
                ++i;
            }
            res.add(strCell);
        }
        file.close();
        return res;
    }

    private String getValue(Row row, int i, DataFormatter df) {
        Cell cell = row.getCell(i);
        if (cell == null) {
            return null;
        }
        return df.formatCellValue(cell);
    }

    public static void main(String[] args) throws IOException {
        TestTools.init();
        List<String[]> res = new ExcelReader().readFile("adh.xls", 7);
        List<Utilisateur> dtos = new UtilisateurService().getUtilisateurs(null);
        for (Utilisateur utilisateurDTO : dtos) {
            String[] line = ExcelReader.findLine(utilisateurDTO, res);
            System.out.println("-- " + utilisateurDTO.nom + " - " + utilisateurDTO.prenom);
            if (line != null) {
                String adr = "";
                String ville = "";
                String code = "";
                Pattern ligneEnsPattern = Pattern.compile("(.*)(26...)(.*)");
                Matcher m = ligneEnsPattern.matcher(line[3]);
                boolean b = m.matches();
                if (b) {
                    adr = m.group(1).trim();
                    code = m.group(2).trim();
                    ville = m.group(3).trim();
                }
                String numTel1 = ExcelReader.numTel(line[4]);
                String numTel2 = ExcelReader.numTel(line[5]);
                System.out.println("update Utilisateur set libadr1='" + ExcelReader.rm(adr) + "', codepostal='" + ExcelReader.rm(code) + "', ville='" + ExcelReader.rm(ville) + "', numTel1='" + numTel1 + "', numTel2='" + numTel2 + "' where id=" + utilisateurDTO.getId() + ";");
                continue;
            }
            System.out.println("-- NOT FOUND");
        }
    }

    private static String rm(String s) {
        return s.replace('\'', '\"');
    }

    private static String numTel(String tel) {
        if (tel.length() == 0) {
            return tel;
        }
        tel = tel.replaceAll(" ", "");
        if ((tel = tel.replaceAll("\\.", "")).startsWith("0")) {
            return tel;
        }
        return "0" + tel;
    }

    private static String[] findLine(Utilisateur utilisateurDTO, List<String[]> res) {
        int i = 9;
        while (i < 75) {
            String[] line = res.get(i);
            if (ExcelReader.isMatching(utilisateurDTO, line)) {
                return line;
            }
            ++i;
        }
        return null;
    }

    private static boolean isMatching(Utilisateur utilisateurDTO, String[] line) {
        return ExcelReader.eq(utilisateurDTO.nom, line[1]) && ExcelReader.eq(utilisateurDTO.prenom, line[2]);
    }

    private static boolean eq(String a, String b) {
        return a.trim().equalsIgnoreCase(b.trim());
    }
}

