/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.engine.generator.excel;

import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.tools.TestTools;
import fr.amapj.service.engine.generator.CoreGenerator;
import fr.amapj.service.engine.generator.CoreGeneratorService;
import fr.amapj.service.engine.generator.excel.ExcelFormat;
import fr.amapj.service.engine.generator.excel.ExcelGeneratorTool;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.ss.usermodel.Workbook;

public abstract class AbstractExcelGenerator
implements CoreGenerator {
    private String nameToDisplaySuffix;

    public abstract void fillExcelFile(RdbLink var1, ExcelGeneratorTool var2);

    @Override
    public abstract String getFileName(RdbLink var1);

    @Override
    public abstract String getNameToDisplay(RdbLink var1);

    public abstract ExcelFormat getFormat();

    public void setNameToDisplaySuffix(String nameToDisplaySuffix) {
        this.nameToDisplaySuffix = nameToDisplaySuffix;
    }

    @Override
    public String getNameToDisplaySuffix() {
        return this.nameToDisplaySuffix;
    }

    @Override
    public String getExtension() {
        return this.getFormat().toString().toLowerCase();
    }

    @Override
    public InputStream getContent() {
        return new ByteArrayInputStream(this.getByteArrayContent());
    }

    @Override
    public byte[] getByteArrayContent() {
        Workbook workbook = new CoreGeneratorService().getFichierExcel(this);
        ByteArrayOutputStream imagebuffer = new ByteArrayOutputStream();
        try {
            workbook.write((OutputStream)imagebuffer);
        }
        catch (IOException iOException) {
            throw new RuntimeException("Erreur inattendue");
        }
        return imagebuffer.toByteArray();
    }

    public void test() throws IOException {
        TestTools.init();
        String filename = "test." + this.getFormat().name().toLowerCase();
        Workbook workbook = new CoreGeneratorService().getFichierExcel(this);
        FileOutputStream fileOut = new FileOutputStream(filename);
        workbook.write((OutputStream)fileOut);
        fileOut.close();
        System.out.println("Your excel file has been generated!");
    }

    public UnitTestInfo unitTest() throws IOException {
        UnitTestInfo res = new UnitTestInfo();
        res.fileExtension = this.getFormat().name().toLowerCase();
        Workbook workbook = new CoreGeneratorService().getFichierExcel(this);
        res.baos = new ByteArrayOutputStream();
        workbook.write((OutputStream)res.baos);
        return res;
    }

    public class UnitTestInfo {
        public ByteArrayOutputStream baos;
        public String fileExtension;
    }
}

