/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.engine.generator.excel;

import fr.amapj.common.StringUtils;
import java.awt.Font;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.ss.usermodel.Row;

public class ExcelCellAutoSize {
    private List<ExcelSize> cells;
    private int additionalSpace;
    private ExcelSize current;

    public ExcelCellAutoSize(int additionalSpace) {
        this.additionalSpace = additionalSpace;
        this.cells = new ArrayList<ExcelSize>();
    }

    public void addCell(int cellWidth, String fontName, int fontSize) {
        this.addCell(cellWidth, fontName, fontSize, false);
    }

    public void addCell(int cellWidth, String fontName, int fontSize, boolean isBold) {
        this.current = new ExcelSize();
        this.current.cellWidth = cellWidth;
        this.current.fontName = fontName;
        this.current.fontSize = fontSize;
        this.current.isBold = isBold;
        this.current.lines = new ArrayList<String>();
        this.cells.add(this.current);
    }

    public void addLine(String line) {
        this.current.lines.addAll(StringUtils.asList(line));
    }

    public void autosize(Row currentRow) {
        double height = this.getRealHeight(10);
        for (ExcelSize cell : this.cells) {
            double currentHeight = (double)this.getLineCount(cell) * this.getRealHeight(cell.fontSize);
            height = Math.max(height, currentHeight);
        }
        currentRow.setHeight((short)(20.0 * (height + (double)this.additionalSpace)));
    }

    private double getRealHeight(int height) {
        if (height == 8) {
            return 10.2;
        }
        if (height == 9) {
            return 11.4;
        }
        if (height == 10) {
            return 13.2;
        }
        return (double)height * 1.25;
    }

    private int getLineCount(ExcelSize cell) {
        int lineCnt = 0;
        for (String line : cell.lines) {
            lineCnt += this.getLineCount(line, cell.cellWidth, cell.fontName, cell.fontSize, cell.isBold);
        }
        return lineCnt;
    }

    private int getLineCount(String cellValue, int cellWidth, String fontName, int fontSize, boolean isBold) {
        if (cellValue.length() == 0) {
            return 1;
        }
        Font currFont = new Font(fontName, 0, fontSize);
        AttributedString attrStr = new AttributedString(cellValue);
        attrStr.addAttribute(TextAttribute.FONT, currFont);
        if (isBold) {
            attrStr.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD);
        }
        FontRenderContext frc = new FontRenderContext(null, true, true);
        LineBreakMeasurer measurer = new LineBreakMeasurer(attrStr.getIterator(), frc);
        int nextPos = 0;
        int lineCnt = 0;
        while (measurer.getPosition() < cellValue.length()) {
            nextPos = measurer.nextOffset(cellWidth);
            ++lineCnt;
            measurer.setPosition(nextPos);
        }
        return lineCnt;
    }

    public static class ExcelSize {
        List<String> lines;
        int cellWidth;
        String fontName;
        int fontSize;
        boolean isBold;
    }
}

