/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.engine.generator.excel;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.FormatUtils;
import fr.amapj.model.models.editionspe.AbstractEditionSpeJson;
import fr.amapj.service.engine.generator.excel.ExcelFormat;
import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.hssf.usermodel.HSSFPalette;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.ss.util.WorkbookUtil;
import org.apache.poi.xssf.model.StylesTable;
import org.apache.poi.xssf.model.ThemesTable;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.apache.poi.xssf.usermodel.extensions.XSSFCellBorder;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorder;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTBorderPr;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTXf;
import org.openxmlformats.schemas.spreadsheetml.x2006.main.STBorderStyle;

public class ExcelGeneratorTool {
    Workbook wb;
    Sheet sheet;
    Row currentRow;
    Font fontNonGras;
    Font fontGras;
    Font fontGrasBlue;
    Font fontGrasHaut;
    Font fontGrasPetit;
    public CellStyle grasGaucheNonWrappe;
    public CellStyle grasGaucheNonWrappeColor;
    public CellStyle grasGaucheNonWrappeBordure;
    public CellStyle grasGaucheNonWrappeBordureGray;
    public CellStyle grasGaucheWrappe;
    public CellStyle grasGaucheWrappeColor;
    public CellStyle grasGaucheWrappeBordure;
    public CellStyle grasGaucheWrappeBordureGray;
    public CellStyle grasCentre;
    public CellStyle grasCentreBordure;
    public CellStyle grasCentreBordureColor;
    public CellStyle grasCentreBordureColorPetit;
    public CellStyle grasCentreBordureGray;
    public CellStyle nonGrasCentreBordure;
    public CellStyle nonGrasCentreBordureDiagonal;
    public CellStyle nonGrasCentreBordureDiagonalColor;
    public CellStyle nonGrasCentreBordureColor;
    public CellStyle nonGrasCentreBordureGray;
    public CellStyle nonGrasGaucheBordure;
    public CellStyle nongrasGaucheWrappe;
    public CellStyle nonGrasGaucheNonWrappe;
    public CellStyle nonGrasGaucheBordureGray;
    public CellStyle prixCentreBordure;
    public CellStyle prixCentreBordureColor;
    public CellStyle prixCentreBordureGray;
    public CellStyle prixCentreBordureNoZero;
    public CellStyle prixCentreBordureColorNoZero;
    public CellStyle prixCentreBordureGrayNoZero;
    public CellStyle titre;
    boolean firstLine = true;
    int nbColMax;
    private SimpleDateFormat df;
    private SimpleDateFormat df2;

    public ExcelGeneratorTool(ExcelFormat format) {
        this.wb = format == ExcelFormat.XLS ? new HSSFWorkbook() : new XSSFWorkbook();
        this.initializeFont();
        this.initializeStyle();
        this.df = FormatUtils.getStdDate();
        this.df2 = FormatUtils.getTimeStd();
    }

    private void initializeFont() {
        this.fontNonGras = this.wb.createFont();
        this.fontNonGras.setFontHeightInPoints((short)10);
        this.fontNonGras.setFontName("Arial");
        this.fontNonGras.setColor(IndexedColors.BLACK.getIndex());
        this.fontNonGras.setBoldweight((short)400);
        this.fontNonGras.setItalic(false);
        this.fontGras = this.wb.createFont();
        this.fontGras.setFontHeightInPoints((short)10);
        this.fontGras.setFontName("Arial");
        this.fontGras.setColor(IndexedColors.BLACK.getIndex());
        this.fontGras.setBoldweight((short)700);
        this.fontGras.setItalic(false);
        this.fontGrasBlue = this.wb.createFont();
        this.fontGrasBlue.setFontHeightInPoints((short)10);
        this.fontGrasBlue.setFontName("Arial");
        this.fontGrasBlue.setColor(IndexedColors.BLUE.getIndex());
        this.fontGrasBlue.setBoldweight((short)700);
        this.fontGrasBlue.setItalic(false);
        this.fontGrasHaut = this.wb.createFont();
        this.fontGrasHaut.setFontHeightInPoints((short)12);
        this.fontGrasHaut.setFontName("Arial");
        this.fontGrasHaut.setColor(IndexedColors.BLACK.getIndex());
        this.fontGrasHaut.setBoldweight((short)700);
        this.fontGrasHaut.setItalic(false);
        this.fontGrasPetit = this.wb.createFont();
        this.fontGrasPetit.setFontHeightInPoints((short)7);
        this.fontGrasPetit.setFontName("Arial");
        this.fontGrasPetit.setColor(IndexedColors.BLACK.getIndex());
        this.fontGrasPetit.setBoldweight((short)700);
        this.fontGrasPetit.setItalic(false);
    }

    private void initializeStyle() {
        this.grasGaucheNonWrappe = this.wb.createCellStyle();
        this.grasGaucheNonWrappe.setAlignment((short)1);
        this.grasGaucheNonWrappe.setVerticalAlignment((short)1);
        this.grasGaucheNonWrappe.setFont(this.fontGras);
        this.grasGaucheNonWrappe.setWrapText(false);
        this.beWhite(this.grasGaucheNonWrappe);
        this.grasGaucheNonWrappeColor = this.wb.createCellStyle();
        this.grasGaucheNonWrappeColor.cloneStyleFrom(this.grasGaucheNonWrappe);
        this.beOrange(this.grasGaucheNonWrappeColor);
        this.grasGaucheNonWrappeBordure = this.wb.createCellStyle();
        this.grasGaucheNonWrappeBordure.setAlignment((short)1);
        this.grasGaucheNonWrappeBordure.setVerticalAlignment((short)1);
        this.grasGaucheNonWrappeBordure.setFont(this.fontGras);
        this.grasGaucheNonWrappeBordure.setWrapText(false);
        this.addBorderedStyle(this.grasGaucheNonWrappeBordure);
        this.beWhite(this.grasGaucheNonWrappeBordure);
        this.grasGaucheNonWrappeBordureGray = this.duplicate(this.grasGaucheNonWrappeBordure);
        this.beGray(this.grasGaucheNonWrappeBordureGray);
        this.grasGaucheWrappe = this.duplicate(this.grasGaucheNonWrappe);
        this.grasGaucheWrappe.setWrapText(true);
        this.grasGaucheWrappeColor = this.duplicate(this.grasGaucheNonWrappeColor);
        this.grasGaucheWrappeColor.setWrapText(true);
        this.grasGaucheWrappeBordure = this.duplicate(this.grasGaucheNonWrappeBordure);
        this.grasGaucheWrappeBordure.setWrapText(true);
        this.grasGaucheWrappeBordureGray = this.duplicate(this.grasGaucheNonWrappeBordureGray);
        this.grasGaucheWrappeBordureGray.setWrapText(true);
        this.grasCentre = this.wb.createCellStyle();
        this.grasCentre.setAlignment((short)2);
        this.grasCentre.setVerticalAlignment((short)1);
        this.grasCentre.setFont(this.fontGras);
        this.grasCentre.setWrapText(true);
        this.beWhite(this.grasCentre);
        this.grasCentreBordure = this.duplicate(this.grasCentre);
        this.addBorderedStyle(this.grasCentreBordure);
        this.grasCentreBordureColor = this.duplicate(this.grasCentreBordure);
        this.beOrange(this.grasCentreBordureColor);
        this.grasCentreBordureColorPetit = this.duplicate(this.grasCentreBordureColor);
        this.grasCentreBordureColorPetit.setFont(this.fontGrasPetit);
        this.grasCentreBordureGray = this.duplicate(this.grasCentreBordure);
        this.beGray(this.grasCentreBordureGray);
        this.nonGrasCentreBordure = this.wb.createCellStyle();
        this.nonGrasCentreBordure.setAlignment((short)2);
        this.nonGrasCentreBordure.setVerticalAlignment((short)1);
        this.nonGrasCentreBordure.setFont(this.fontNonGras);
        this.addBorderedStyle(this.nonGrasCentreBordure);
        this.nonGrasCentreBordure.setWrapText(true);
        this.beWhite(this.nonGrasCentreBordure);
        this.nonGrasCentreBordureDiagonal = this.duplicate(this.nonGrasCentreBordure);
        this.addDiagonalBorder(this.nonGrasCentreBordureDiagonal);
        this.nonGrasCentreBordureDiagonalColor = this.duplicate(this.nonGrasCentreBordureDiagonal);
        this.beOrange(this.nonGrasCentreBordureDiagonalColor);
        this.nonGrasCentreBordureColor = this.duplicate(this.nonGrasCentreBordure);
        this.beOrange(this.nonGrasCentreBordureColor);
        this.nonGrasCentreBordureGray = this.duplicate(this.nonGrasCentreBordure);
        this.beGray(this.nonGrasCentreBordureGray);
        this.nonGrasGaucheBordure = this.wb.createCellStyle();
        this.nonGrasGaucheBordure.setAlignment((short)1);
        this.nonGrasGaucheBordure.setVerticalAlignment((short)1);
        this.nonGrasGaucheBordure.setFont(this.fontNonGras);
        this.addBorderedStyle(this.nonGrasGaucheBordure);
        this.nonGrasGaucheBordure.setWrapText(true);
        this.beWhite(this.nonGrasGaucheBordure);
        this.nonGrasGaucheBordureGray = this.duplicate(this.nonGrasGaucheBordure);
        this.beGray(this.nonGrasGaucheBordureGray);
        this.prixCentreBordure = this.wb.createCellStyle();
        this.prixCentreBordure.setAlignment((short)2);
        this.prixCentreBordure.setFont(this.fontGrasBlue);
        this.addBorderedStyle(this.prixCentreBordure);
        this.prixCentreBordure.setWrapText(true);
        DataFormat df = this.wb.createDataFormat();
        this.prixCentreBordure.setDataFormat(df.getFormat("#,##0.00\u20ac"));
        this.beWhite(this.prixCentreBordure);
        this.prixCentreBordureColor = this.duplicate(this.prixCentreBordure);
        this.beOrange(this.prixCentreBordureColor);
        this.prixCentreBordureGray = this.duplicate(this.prixCentreBordure);
        this.beGray(this.prixCentreBordureGray);
        short codeFormat = df.getFormat("#,##0.00\u20ac;-#,##0.00\u20ac;;@");
        this.prixCentreBordureNoZero = this.duplicate(this.prixCentreBordure);
        this.prixCentreBordureNoZero.setDataFormat(codeFormat);
        this.prixCentreBordureColorNoZero = this.duplicate(this.prixCentreBordure);
        this.prixCentreBordureColorNoZero.setDataFormat(codeFormat);
        this.prixCentreBordureGrayNoZero = this.duplicate(this.prixCentreBordure);
        this.prixCentreBordureGrayNoZero.setDataFormat(codeFormat);
        this.titre = this.wb.createCellStyle();
        this.titre.setAlignment((short)2);
        this.titre.setFont(this.fontGrasHaut);
        this.titre.setWrapText(false);
        this.beWhite(this.titre);
        this.nongrasGaucheWrappe = this.wb.createCellStyle();
        this.nongrasGaucheWrappe.setAlignment((short)1);
        this.nongrasGaucheWrappe.setVerticalAlignment((short)1);
        this.nongrasGaucheWrappe.setFont(this.fontNonGras);
        this.nongrasGaucheWrappe.setWrapText(true);
        this.beWhite(this.nongrasGaucheWrappe);
        this.nonGrasGaucheNonWrappe = this.duplicate(this.nongrasGaucheWrappe);
        this.nonGrasGaucheNonWrappe.setWrapText(false);
    }

    private CellStyle duplicate(CellStyle style) {
        CellStyle ret = this.wb.createCellStyle();
        ret.cloneStyleFrom(style);
        return ret;
    }

    private void beWhite(CellStyle style) {
        style.setFillPattern((short)1);
        style.setFillForegroundColor(IndexedColors.WHITE.getIndex());
    }

    private void beOrange(CellStyle style) {
        style.setFillPattern((short)1);
        style.setFillForegroundColor(IndexedColors.LIGHT_YELLOW.getIndex());
    }

    private void beGray(CellStyle style) {
        style.setFillPattern((short)1);
        if (this.wb instanceof HSSFWorkbook) {
            HSSFPalette palette = ((HSSFWorkbook)this.wb).getCustomPalette();
            palette.setColorAtIndex((short)46, (byte)-16, (byte)-16, (byte)-16);
            style.setFillForegroundColor(IndexedColors.LAVENDER.getIndex());
        } else {
            ((XSSFCellStyle)style).setFillForegroundColor(new XSSFColor(new Color(240, 240, 240)));
        }
    }

    private void addBorderedStyle(CellStyle style) {
        style.setBorderRight((short)1);
        style.setRightBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderBottom((short)1);
        style.setBottomBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderLeft((short)1);
        style.setLeftBorderColor(IndexedColors.BLACK.getIndex());
        style.setBorderTop((short)1);
        style.setTopBorderColor(IndexedColors.BLACK.getIndex());
    }

    private void addDiagonalBorder(CellStyle style) {
        short lineStyle = 1;
        try {
            if (this.wb instanceof HSSFWorkbook) {
                Field f = HSSFCellStyle.class.getDeclaredField("_format");
                f.setAccessible(true);
                ExtendedFormatRecord efr = (ExtendedFormatRecord)f.get(style);
                efr.setIndentNotParentBorder(true);
                efr.setDiag((short)3);
                efr.setAdtlDiag((short)64);
                efr.setAdtlDiagLineStyle(lineStyle);
            } else {
                CTBorderPr pr;
                Method m = XSSFCellStyle.class.getDeclaredMethod("getCTBorder", new Class[0]);
                m.setAccessible(true);
                Field f1 = XSSFCellStyle.class.getDeclaredField("_stylesSource");
                f1.setAccessible(true);
                Field f2 = XSSFCellStyle.class.getDeclaredField("_theme");
                f2.setAccessible(true);
                CTBorder ct = (CTBorder)m.invoke((Object)style, new Object[0]);
                CTXf _cellXf = ((XSSFCellStyle)style).getCoreXf();
                StylesTable _stylesSource = (StylesTable)f1.get(style);
                ThemesTable _theme = (ThemesTable)f2.get(style);
                CTBorderPr cTBorderPr = pr = ct.isSetDiagonal() ? ct.getDiagonal() : ct.addNewDiagonal();
                if (lineStyle == 0) {
                    ct.unsetDiagonal();
                } else {
                    ct.setDiagonalDown(true);
                    ct.setDiagonalUp(true);
                    pr.setStyle(STBorderStyle.Enum.forInt((int)(lineStyle + 1)));
                }
                int idx = _stylesSource.putBorder(new XSSFCellBorder(ct, _theme));
                _cellXf.setBorderId((long)idx);
                _cellXf.setApplyBorder(true);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new AmapjRuntimeException(e);
        }
    }

    public void addSheet(String sheetName, int nbCol, int colWidth) {
        sheetName = WorkbookUtil.createSafeSheetName((String)sheetName);
        this.sheet = this.wb.createSheet(sheetName);
        this.currentRow = null;
        this.firstLine = true;
        this.nbColMax = nbCol;
        int i = 0;
        while (i < nbCol) {
            this.setColumnWidth(i, colWidth);
            this.sheet.setDefaultColumnStyle(i, this.grasGaucheNonWrappe);
            ++i;
        }
        this.setMargin(10, 10, 10, 10);
        this.sheet.getPrintSetup().setLandscape(false);
        this.sheet.getPrintSetup().setPaperSize((short)9);
    }

    public void setModePaysage() {
        this.sheet.getPrintSetup().setLandscape(true);
    }

    public void setMargin(int left, int right, int top, int bottom) {
        double c = 0.03937;
        this.sheet.setMargin((short)0, c * (double)left);
        this.sheet.setMargin((short)1, c * (double)right);
        this.sheet.setMargin((short)2, c * (double)top);
        this.sheet.setMargin((short)3, c * (double)bottom);
    }

    public void setMargin(AbstractEditionSpeJson json) {
        this.setMargin(json.getMargeGauche(), json.getMargeDroite(), json.getMargeHaut(), json.getMargeBas());
    }

    public void setPageFormat(AbstractEditionSpeJson json) {
        switch (json.getPageFormat()) {
            case A3_PAYSAGE: {
                this.sheet.getPrintSetup().setLandscape(true);
                this.sheet.getPrintSetup().setPaperSize((short)8);
                break;
            }
            case A4_PAYSAGE: {
                this.sheet.getPrintSetup().setLandscape(true);
                this.sheet.getPrintSetup().setPaperSize((short)9);
                break;
            }
            case A3_PORTRAIT: {
                this.sheet.getPrintSetup().setLandscape(false);
                this.sheet.getPrintSetup().setPaperSize((short)8);
                break;
            }
            case A4_PORTRAIT: {
                this.sheet.getPrintSetup().setLandscape(false);
                this.sheet.getPrintSetup().setPaperSize((short)9);
                break;
            }
            default: {
                throw new AmapjRuntimeException();
            }
        }
    }

    public void setMarginAndPageFormat(AbstractEditionSpeJson json) {
        this.setMargin(json);
        this.setPageFormat(json);
    }

    public void adjustSheetForOnePage() {
        int PAGE_WIDTH = 26500;
        int nbTotal = 0;
        int i = 0;
        while (i < this.nbColMax) {
            nbTotal += this.sheet.getColumnWidth(i);
            ++i;
        }
        if (nbTotal <= PAGE_WIDTH) {
            return;
        }
        i = 0;
        while (i < this.nbColMax) {
            int newWidth = this.sheet.getColumnWidth(i) * PAGE_WIDTH / nbTotal;
            this.sheet.setColumnWidth(i, newWidth);
            ++i;
        }
    }

    public void setSheetFirst() {
        Sheet s;
        int nb = this.wb.getNumberOfSheets();
        ArrayList<String> sheetName = new ArrayList<String>();
        sheetName.add(this.sheet.getSheetName());
        int i = 0;
        while (i < nb - 1) {
            s = this.wb.getSheetAt(i);
            sheetName.add(s.getSheetName());
            ++i;
        }
        i = 0;
        while (i < nb) {
            this.wb.setSheetOrder((String)sheetName.get(i), i);
            s = this.wb.getSheetAt(i);
            if (i == 0) {
                s.setSelected(true);
            } else {
                s.setSelected(false);
            }
            ++i;
        }
    }

    public void setRowHeigth(int nbLine) {
        this.currentRow.setHeight((short)(240 * nbLine));
    }

    public void setRowHeigthInMm(int mm) {
        this.currentRow.setHeight((short)(56.7 * (double)mm));
    }

    public void setRowHeigthUndefined() {
        this.currentRow.setHeight((short)0);
        this.currentRow.setRowStyle(this.grasGaucheWrappeBordure);
    }

    public Row addRow() {
        int index = this.sheet.getLastRowNum();
        if (this.firstLine) {
            index = -1;
            this.firstLine = false;
        }
        Row row = this.sheet.createRow(index + 1);
        int i = 0;
        while (i < this.nbColMax) {
            Cell cell = row.createCell(i);
            cell.setCellStyle(this.grasGaucheNonWrappe);
            ++i;
        }
        this.currentRow = row;
        return row;
    }

    public void addRow(String text, CellStyle style) {
        Row row = this.addRow();
        Cell cell = row.getCell(0);
        cell.setCellStyle(style);
        cell.setCellValue(text);
    }

    public void mergeCellsRight(int numCol, int nbCol) {
        int lastRow;
        this.checkNumCol(numCol);
        this.checkNumCol(numCol + nbCol - 1);
        int firstRow = lastRow = this.currentRow.getRowNum();
        this.mergeCells(firstRow, lastRow, numCol, numCol + nbCol - 1);
    }

    public void mergeCellsUp(int numCol, int nbRow) {
        this.checkNumCol(numCol);
        this.mergeCellsUp(numCol, numCol, nbRow);
    }

    public void mergeCellsUp(int firstCol, int lastCol, int nbRow) {
        this.checkNumCol(firstCol);
        this.checkNumCol(lastCol);
        int lastRow = this.currentRow.getRowNum();
        int firstRow = lastRow - nbRow + 1;
        this.mergeCells(firstRow, lastRow, firstCol, lastCol);
    }

    public void mergeCells(int firstRow, int lastRow, int firstCol, int lastCol) {
        CellStyle style = this.sheet.getRow(firstRow).getCell(firstCol).getCellStyle();
        int numRow = firstRow;
        while (numRow <= lastRow) {
            Row row = this.sheet.getRow(numRow);
            int numCol = firstCol;
            while (numCol <= lastCol) {
                row.getCell(numCol).setCellStyle(style);
                ++numCol;
            }
            ++numRow;
        }
        this.sheet.addMergedRegion(new CellRangeAddress(firstRow, lastRow, firstCol, lastCol));
    }

    public void createEmptyCell(Row row, int firstCol, int lastCol) {
        int i = firstCol;
        while (i <= lastCol) {
            row.createCell(i);
            ++i;
        }
    }

    public CellStyle switchColor(CellStyle style, int i) {
        if (i % 2 == 0) {
            return style;
        }
        if (style == this.grasCentreBordure) {
            return this.grasCentreBordureColor;
        }
        if (style == this.prixCentreBordure) {
            return this.prixCentreBordureColor;
        }
        if (style == this.prixCentreBordureNoZero) {
            return this.prixCentreBordureColorNoZero;
        }
        if (style == this.nonGrasCentreBordure) {
            return this.nonGrasCentreBordureColor;
        }
        if (style == this.nonGrasCentreBordureDiagonal) {
            return this.nonGrasCentreBordureDiagonalColor;
        }
        throw new RuntimeException();
    }

    public CellStyle switchGray(CellStyle style, int i) {
        return this.switchGray(style, i % 2 != 0);
    }

    public CellStyle switchGray(CellStyle style, boolean applyGray) {
        if (!applyGray) {
            return style;
        }
        if (style == this.grasGaucheNonWrappeBordure) {
            return this.grasGaucheNonWrappeBordureGray;
        }
        if (style == this.nonGrasGaucheBordure) {
            return this.nonGrasGaucheBordureGray;
        }
        if (style == this.grasCentreBordure) {
            return this.grasCentreBordureGray;
        }
        if (style == this.nonGrasCentreBordure) {
            return this.nonGrasCentreBordureGray;
        }
        if (style == this.grasGaucheWrappeBordure) {
            return this.grasGaucheWrappeBordureGray;
        }
        throw new RuntimeException("erreur de programme");
    }

    private boolean isColored(int i, int nbProd) {
        int numDate = i / nbProd;
        return numDate % 2 != 0;
    }

    private void colorize(Row row, int nbDates, int nbProd) {
        int i = 0;
        while (i < nbDates / 2) {
            int index = 3 + nbProd + i * 2 * nbProd;
            int j = 0;
            while (j < nbProd) {
                Cell cell = row.getCell(j + index);
                if (cell != null) {
                    CellStyle st = cell.getCellStyle();
                    this.beOrange(st);
                    cell.setCellStyle(st);
                }
                ++j;
            }
            ++i;
        }
    }

    private void set(Row row, int index, String str) {
        row.createCell(index - 1).setCellValue(str);
    }

    private void setFormula(Row row, int index, String str) {
        row.createCell(index - 1).setCellFormula(str);
    }

    public Workbook getWb() {
        HSSFFormulaEvaluator.evaluateAllFormulaCells((Workbook)this.wb);
        return this.wb;
    }

    public void setColumnWidth(int numCol, int width) {
        this.sheet.setColumnWidth(numCol, width * 256);
    }

    public void setColumnWidthInMm(int numCol, int widthInMm) {
        this.sheet.setColumnWidth(numCol, (int)((double)widthInMm * 130.8));
    }

    public int getColumnWidthInPoints(int numCol) {
        return (int)((double)this.sheet.getColumnWidth(numCol) / 48.0 - 5.0);
    }

    public int getColumnWidthInPointsForMergedCell(int numCol, int nbCol) {
        int res = 0;
        int i = 0;
        while (i < nbCol) {
            res += this.sheet.getColumnWidth(numCol + i);
            ++i;
        }
        return (int)((double)res / 48.0 - 5.0);
    }

    public void setCell(int numCol, String text, CellStyle style) {
        Cell cell = this.currentRow.getCell(numCol);
        cell.setCellValue(text);
        cell.setCellStyle(style);
    }

    public void setNCell(int numCol, int nbCell, String text, CellStyle style) {
        int i = numCol;
        while (i < numCol + nbCell) {
            this.setCell(i, text, style);
            ++i;
        }
    }

    public void setCellDate(int numCol, Date date, CellStyle style) {
        Cell cell = this.currentRow.getCell(numCol);
        String text = "";
        if (date != null) {
            text = this.df.format(date);
        }
        cell.setCellValue(text);
        cell.setCellStyle(style);
    }

    public void setCellDateTime(int numCol, Date date, CellStyle style) {
        Cell cell = this.currentRow.getCell(numCol);
        String text = "";
        if (date != null) {
            text = this.df2.format(date);
        }
        cell.setCellValue(text);
        cell.setCellStyle(style);
    }

    public void setCellPrix(int numCol, int montant, CellStyle style) {
        Cell cell = this.currentRow.getCell(numCol);
        if (montant != 0) {
            cell.setCellType(0);
            cell.setCellValue((double)montant / 100.0);
        }
        cell.setCellStyle(style);
    }

    public void setCellQte(int numCol, int qte, CellStyle style) {
        this.checkNumCol(numCol);
        Cell cell = this.currentRow.getCell(numCol);
        if (qte != 0) {
            cell.setCellType(0);
            cell.setCellValue((double)qte);
        }
        cell.setCellStyle(style);
    }

    private void checkNumCol(int numCol) {
        if (numCol < 0) {
            throw new RuntimeException("Vous essayez d'acc\u00e8der \u00e0 la colonne " + numCol + " : les nombres n\u00e9gatifs sont interdits ");
        }
        if (numCol >= this.nbColMax) {
            throw new RuntimeException("La feuille poss\u00e8de " + this.nbColMax + " colonnes et vous essayez d'acc\u00e8der \u00e0 la colonne " + numCol);
        }
    }

    public void setCellSumInRow(int numCol, int firstCellOfTheSum, int nbCellToSum, CellStyle style) {
        String formula = "SUM(" + this.getCellLabel(firstCellOfTheSum) + ":" + this.getCellLabel(firstCellOfTheSum + nbCellToSum - 1) + ")";
        this.setCellFormula(numCol, formula, style);
    }

    public void setCellSumInRow(int numCol, int firstCellOfTheSum, int stepBetweenCellToSum, int nbCellToSum, int[] additionalCells, CellStyle style) {
        String formula = this.asSumString(additionalCells);
        if (formula.length() != 0) {
            formula = String.valueOf(formula) + "+";
        }
        int i = 0;
        while (i < nbCellToSum) {
            formula = String.valueOf(formula) + this.getCellLabel(firstCellOfTheSum + stepBetweenCellToSum * i);
            if (i != nbCellToSum - 1) {
                formula = String.valueOf(formula) + "+";
            }
            ++i;
        }
        this.setCellFormula(numCol, formula, style);
    }

    public void setCellSumInColDown(int numCol, int deltaVertical, int nbCellToSum, CellStyle style) {
        int firstNumRow = this.currentRow.getRowNum() + deltaVertical;
        int lastNumRow = firstNumRow + nbCellToSum - 1;
        String formula = "SUM(" + this.getCellLabel(firstNumRow, numCol) + ":" + this.getCellLabel(lastNumRow, numCol) + ")";
        this.setCellFormula(numCol, formula, style);
    }

    public void setCellSumInColUp(int numCol, int deltaVertical, int nbCellToSum, CellStyle style) {
        if (nbCellToSum <= 0) {
            this.setCellFormula(numCol, "0", style);
            return;
        }
        int firstNumRow = this.currentRow.getRowNum() - deltaVertical - nbCellToSum + 1;
        int lastNumRow = firstNumRow + nbCellToSum - 1;
        String formula = "SUM(" + this.getCellLabel(firstNumRow, numCol) + ":" + this.getCellLabel(lastNumRow, numCol) + ")";
        this.setCellFormula(numCol, formula, style);
    }

    public void setCellSumProdInRow(int numCol, int firstCellOfTheSum, int nbCellToSum, int rowIndex, CellStyle style) {
        String formula = "SUMPRODUCT(" + this.getCellLabel(rowIndex, firstCellOfTheSum) + ":" + this.getCellLabel(rowIndex, firstCellOfTheSum + nbCellToSum) + "," + this.getCellLabel(firstCellOfTheSum) + ":" + this.getCellLabel(firstCellOfTheSum + nbCellToSum) + ")";
        this.setCellFormula(numCol, formula, style);
    }

    public void setCellFormula(int numCol, String formula, CellStyle style) {
        Cell cell = this.currentRow.getCell(numCol);
        cell.setCellFormula(formula);
        cell.setCellStyle(style);
    }

    public void setCellBasicFormulaInRow(int numCol, int[] cellsToAdd, int[] cellsToSubstract, CellStyle style) {
        String sum = this.asSumString(cellsToAdd);
        String sub = this.asSumString(cellsToSubstract);
        String formula = sum;
        if (sub.length() != 0) {
            formula = String.valueOf(formula) + "-(" + sub + ")";
        }
        this.setCellFormula(numCol, formula, style);
    }

    private String asSumString(int[] cells) {
        if (cells == null || cells.length == 0) {
            return "";
        }
        String formula = "";
        int i = 0;
        while (i < cells.length) {
            int cell = cells[i];
            formula = String.valueOf(formula) + this.getCellLabel(cell);
            if (i != cells.length - 1) {
                formula = String.valueOf(formula) + "+";
            }
            ++i;
        }
        return formula;
    }

    public String getCellLabel(int ligIndex, int colIndex) {
        return String.valueOf(CellReference.convertNumToColString((int)colIndex)) + (ligIndex + 1);
    }

    public String getCellLabel(Row row, int colIndex) {
        return String.valueOf(CellReference.convertNumToColString((int)colIndex)) + (row.getRowNum() + 1);
    }

    public String getCellLabel(int colIndex) {
        return this.getCellLabel(this.currentRow, colIndex);
    }

    public void setColHidden(int columnIndex, boolean hidden) {
        this.sheet.setColumnHidden(columnIndex, hidden);
    }

    public void setRepeatingRow(int l1, int l2) {
        this.sheet.setRepeatingRows(CellRangeAddress.valueOf((String)(String.valueOf(l1) + ":" + l2)));
    }

    public void createFreezePane(int colSplit, int rowSplit) {
        this.sheet.createFreezePane(colSplit, rowSplit);
    }

    public void addComment(int numCol, String commentText, int nbLine) {
        Cell cell = this.currentRow.getCell(numCol);
        int rowIdx = this.currentRow.getRowNum();
        CreationHelper factory = this.wb.getCreationHelper();
        ClientAnchor anchor = factory.createClientAnchor();
        anchor.setCol1(cell.getColumnIndex() + 1);
        anchor.setCol2(cell.getColumnIndex() + 5);
        anchor.setRow1(rowIdx + 1);
        anchor.setRow2(rowIdx + 1 + nbLine);
        Drawing drawing = this.sheet.createDrawingPatriarch();
        Comment comment = drawing.createCellComment(anchor);
        comment.setString(factory.createRichTextString(commentText));
        cell.setCellComment(comment);
    }
}

