/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.engine.generator.odt;

import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.tools.TestTools;
import fr.amapj.service.engine.generator.CoreGenerator;
import fr.amapj.service.engine.generator.CoreGeneratorService;
import fr.amapj.service.engine.generator.odt.OdtGeneratorTool;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.odftoolkit.simple.TextDocument;

public abstract class AbstractOdtGenerator
implements CoreGenerator {
    private String nameToDisplaySuffix;

    public abstract void fillWordFile(RdbLink var1, OdtGeneratorTool var2);

    @Override
    public abstract String getFileName(RdbLink var1);

    @Override
    public abstract String getNameToDisplay(RdbLink var1);

    public void setNameToDisplaySuffix(String nameToDisplaySuffix) {
        this.nameToDisplaySuffix = nameToDisplaySuffix;
    }

    @Override
    public String getNameToDisplaySuffix() {
        return this.nameToDisplaySuffix;
    }

    @Override
    public String getExtension() {
        return ".odt";
    }

    @Override
    public InputStream getContent() {
        return new ByteArrayInputStream(this.getByteArrayContent());
    }

    @Override
    public byte[] getByteArrayContent() {
        TextDocument workbook = new CoreGeneratorService().getFichierOdt(this);
        ByteArrayOutputStream imagebuffer = new ByteArrayOutputStream();
        try {
            workbook.save((OutputStream)imagebuffer);
        }
        catch (Exception exception) {
            throw new RuntimeException("Erreur inattendue");
        }
        return imagebuffer.toByteArray();
    }

    public void test() throws Exception {
        TestTools.init();
        String filename = "test.odt";
        TextDocument doc = new CoreGeneratorService().getFichierOdt(this);
        doc.save(filename);
        System.out.println("Your odt file has been generated!");
    }
}

