/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.engine.generator.odt;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.element.style.StyleListLevelPropertiesElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.dom.element.text.TextListElement;
import org.odftoolkit.odfdom.dom.element.text.TextListItemElement;
import org.odftoolkit.odfdom.dom.element.text.TextListLevelStyleBulletElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeStyles;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextListStyle;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.text.list.List;
import org.odftoolkit.simple.text.list.ListDecorator;
import org.odftoolkit.simple.text.list.ListItem;
import org.w3c.dom.Node;

public class AmapjBulletDecorator
implements ListDecorator {
    private static String[] DEFAULT_TEXT_SPACE_BEFORE_ATTRIBUTES;
    private static String DEFAULT_TEXT_MIN_LABEL_WIDTH;
    private static String DEFAULT_FONT_NAME;
    private static String DEFAULT_BULLET_CHAR;
    private static String DEFAULT_NAME;
    private OdfTextListStyle listStyle;
    private OdfStyle paragraphStyle;
    private OdfOfficeAutomaticStyles styles;

    static {
        String[] stringArray = new String[10];
        stringArray[1] = "0.401cm";
        stringArray[2] = "0.799cm";
        stringArray[3] = "1.2cm";
        stringArray[4] = "1.6cm";
        stringArray[5] = "2.001cm";
        stringArray[6] = "2.399cm";
        stringArray[7] = "2.8cm";
        stringArray[8] = "3.2cm";
        stringArray[9] = "3.601cm";
        DEFAULT_TEXT_SPACE_BEFORE_ATTRIBUTES = stringArray;
        DEFAULT_TEXT_MIN_LABEL_WIDTH = "0.4cm";
        DEFAULT_FONT_NAME = "Arial";
        DEFAULT_BULLET_CHAR = "\u2022";
        DEFAULT_NAME = "Ma-liste";
    }

    public AmapjBulletDecorator(Document doc) {
        try {
            OdfContentDom contentDocument = doc.getContentDom();
            this.styles = contentDocument.getAutomaticStyles();
            OdfOfficeStyles documentStyles = doc.getDocumentStyles();
            this.listStyle = this.styles.getListStyle(DEFAULT_NAME);
            if (this.listStyle == null) {
                this.listStyle = this.styles.newListStyle();
                this.getOrCreateStyleByName(documentStyles, this.styles, "Bullet_20_Symbols", OdfStyleFamily.Text);
                int i = 0;
                while (i < 10) {
                    TextListLevelStyleBulletElement listLevelElement = this.listStyle.newTextListLevelStyleBulletElement(DEFAULT_BULLET_CHAR, i + 1);
                    listLevelElement.setTextStyleNameAttribute("Bullet_20_Symbols");
                    StyleListLevelPropertiesElement styleListLevelPropertiesElement = listLevelElement.newStyleListLevelPropertiesElement();
                    if (DEFAULT_TEXT_SPACE_BEFORE_ATTRIBUTES[i] != null) {
                        styleListLevelPropertiesElement.setTextSpaceBeforeAttribute(DEFAULT_TEXT_SPACE_BEFORE_ATTRIBUTES[i]);
                    }
                    styleListLevelPropertiesElement.setTextMinLabelWidthAttribute(DEFAULT_TEXT_MIN_LABEL_WIDTH);
                    StyleTextPropertiesElement styleTextPropertiesElement = listLevelElement.newStyleTextPropertiesElement("true");
                    styleTextPropertiesElement.setStyleFontNameAttribute(DEFAULT_FONT_NAME);
                    ++i;
                }
            }
            this.paragraphStyle = this.styles.newStyle(OdfStyleFamily.Paragraph);
            this.getOrCreateStyleByName(documentStyles, this.styles, "Default_20_Text", OdfStyleFamily.Paragraph);
            this.paragraphStyle.setStyleParentStyleNameAttribute("Default_20_Text");
            this.paragraphStyle.setStyleListStyleNameAttribute(this.listStyle.getStyleNameAttribute());
        }
        catch (Exception e) {
            Logger.getLogger(AmapjBulletDecorator.class.getName()).log(Level.SEVERE, null, e);
        }
    }

    public void decorateList(List list) {
        TextListElement listElement = list.getOdfElement();
        listElement.setTextStyleNameAttribute(this.listStyle.getStyleNameAttribute());
    }

    public void decorateListItem(ListItem item) {
        TextListItemElement listItemElement = item.getOdfElement();
        Node child = listItemElement.getFirstChild();
        while (child != null) {
            if (child instanceof TextPElement) {
                TextPElement pElement = (TextPElement)child;
                pElement.setTextStyleNameAttribute(this.paragraphStyle.getStyleNameAttribute());
            }
            child = child.getNextSibling();
        }
    }

    public ListDecorator.ListType getListType() {
        return ListDecorator.ListType.BULLET;
    }

    private OdfStyle getOrCreateStyleByName(OdfOfficeStyles documentStyles, OdfOfficeAutomaticStyles styles, String styleName, OdfStyleFamily styleFamily) {
        OdfStyle odfStyle = documentStyles.getStyle(styleName, styleFamily);
        if (odfStyle == null) {
            styles.getStyle(styleName, styleFamily);
        }
        if (odfStyle == null) {
            odfStyle = styles.newStyle(styleFamily);
            odfStyle.setStyleNameAttribute(styleName);
            odfStyle.setStyleDisplayNameAttribute(styleName);
        }
        return odfStyle;
    }
}

