/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.engine.generator.pdf;

import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.tools.TestTools;
import fr.amapj.service.engine.generator.CoreGenerator;
import fr.amapj.service.engine.generator.CoreGeneratorService;
import fr.amapj.service.engine.generator.pdf.Html2PdfConverter;
import fr.amapj.service.engine.generator.pdf.PdfGeneratorTool;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractPdfGenerator
implements CoreGenerator {
    private static final Logger logger = LogManager.getLogger();
    private String nameToDisplaySuffix;

    public abstract void fillPdfFile(RdbLink var1, PdfGeneratorTool var2);

    @Override
    public abstract String getFileName(RdbLink var1);

    @Override
    public abstract String getNameToDisplay(RdbLink var1);

    public void setNameToDisplaySuffix(String nameToDisplaySuffix) {
        this.nameToDisplaySuffix = nameToDisplaySuffix;
    }

    @Override
    public String getNameToDisplaySuffix() {
        return this.nameToDisplaySuffix;
    }

    @Override
    public String getExtension() {
        return "pdf";
    }

    public String getHtmlContentForTest() {
        PdfGeneratorTool pdfGeneratorTool = new CoreGeneratorService().getFichierPdf(this);
        String html = pdfGeneratorTool.getFinalDoc();
        return html;
    }

    @Override
    public InputStream getContent() {
        return new ByteArrayInputStream(this.getByteArrayContent());
    }

    @Override
    public byte[] getByteArrayContent() {
        PdfGeneratorTool pdfGeneratorTool = new CoreGeneratorService().getFichierPdf(this);
        String html = pdfGeneratorTool.getFinalDoc();
        return new Html2PdfConverter().convertHtmlToPdf(html);
    }

    public void test() throws Exception {
        TestTools.init();
        String filename = "test.pdf";
        FileOutputStream fos = new FileOutputStream(filename);
        IOUtils.copy((InputStream)this.getContent(), (OutputStream)fos);
        fos.close();
        System.out.println("Your pdf file has been generated!");
    }
}

