/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.engine.generator.pdf;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.RuntimeUtils;
import fr.amapj.messagingcenter.miniproxy.TNProxyClient;
import fr.amapj.messagingcenter.miniproxy.core.ServiceNotAvailableException;
import fr.amapj.messagingcenter.miniproxy.model.html2pdf.request.ConvertHtml2PdfRequest;
import fr.amapj.messagingcenter.miniproxy.model.html2pdf.response.ConvertHtml2PdfResponse;
import fr.amapj.model.engine.db.DbManager;
import fr.amapj.view.engine.ui.AppConfiguration;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Html2PdfConverter {
    private static final Logger logger = LogManager.getLogger();

    public byte[] convertHtmlToPdf(String html) {
        if (AppConfiguration.getConf().isPdfConversionWithMessagingCenter()) {
            return this.convertHtmlToPdfWithMessagingCenter(html);
        }
        return this.convertHtmlToPdfWithLocalInstall(html);
    }

    private byte[] convertHtmlToPdfWithLocalInstall(String html) {
        logger.info("Conversion d'un html de taille " + html.length());
        try {
            File in = File.createTempFile("inpdf", ".html");
            File out = File.createTempFile("outpdf", ".pdf");
            FileOutputStream fos = new FileOutputStream(in);
            fos.write(html.getBytes("UTF-8"));
            fos.flush();
            fos.close();
            String wkhtmltopdfCommand = AppConfiguration.getConf().getWkhtmltopdfCommand();
            if (wkhtmltopdfCommand == null) {
                throw new RuntimeException("Impossible de generer le fichier PDF car  wkhtmltopdf n'est pas install\u00e9 ou son chemin d'acc\u00e8s n'est pas configur\u00e9");
            }
            String[] fullCommand = new String[]{wkhtmltopdfCommand, "--disable-smart-shrinking", "-T", "0", "-B", "0", "-L", "0", "-R", "0", in.getCanonicalPath(), out.getCanonicalPath()};
            RuntimeUtils.executeCommandLine(fullCommand, 50000L);
            byte[] pdfContent = FileUtils.readFileToByteArray((File)out);
            in.delete();
            out.delete();
            logger.info("Success");
            return pdfContent;
        }
        catch (IOException | InterruptedException | TimeoutException e) {
            logger.error("Erreur lors de la conversion du fichier", (Throwable)e);
            throw new AmapjRuntimeException(e);
        }
    }

    private byte[] convertHtmlToPdfWithMessagingCenter(String html) {
        ConvertHtml2PdfResponse response;
        ConvertHtml2PdfRequest request = new ConvertHtml2PdfRequest();
        request.dbName = DbManager.get().getCurrentDb().getDbName();
        request.html = html;
        try {
            response = this.getProxy().convertHtml2Pdf(request);
        }
        catch (ServiceNotAvailableException serviceNotAvailableException) {
            throw new AmapjRuntimeException("Service non disponible.");
        }
        if (response.pdfContent == null) {
            throw new AmapjRuntimeException("Impossible de convertir le fichier : " + response.error);
        }
        return response.pdfContent;
    }

    private TNProxyClient getProxy() {
        AppConfiguration conf = AppConfiguration.getConf();
        return new TNProxyClient(conf.getMessagingCenterKey(), conf.getMessagingCenterUrl());
    }
}

