/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.engine.generator.pdf;

import fr.amapj.model.models.editionspe.Imprimable;
import fr.amapj.model.models.editionspe.PageFormat;
import fr.amapj.service.engine.generator.MiseEnPageUtils;

public class PdfHtmlUtils {
    public static String extractBody(String content) {
        int startBody1 = content.indexOf("<body");
        int endBody1 = content.indexOf(">", startBody1);
        int startBody2 = content.indexOf("</body>");
        return content.substring(endBody1 + 1, startBody2);
    }

    public static String updateHeaderAndBodyLineForCKEditor(String text, Imprimable imprimable) {
        String body = PdfHtmlUtils.extractBody(text);
        return String.valueOf(PdfHtmlUtils.generateHeaderAndBodyLineForCKEditor(imprimable)) + body + "</body></html>";
    }

    public static String generateHeaderAndBodyLineForCKEditor(Imprimable imprimable) {
        int marginLeft = MiseEnPageUtils.toPoints(imprimable.getMargeGauche());
        int marginRight = MiseEnPageUtils.toPoints(imprimable.getMargeDroite());
        int fullWidthInMm = imprimable.getPageFormat() == PageFormat.A4_PORTRAIT ? 210 : 297;
        int widthInMm = fullWidthInMm - imprimable.getMargeGauche() - imprimable.getMargeDroite();
        int width = MiseEnPageUtils.toPoints(widthInMm);
        StringBuffer buf = new StringBuffer();
        buf.append("<!DOCTYPE html>");
        buf.append("<html>");
        buf.append("<head>");
        buf.append("<meta charset=\"utf-8\">");
        buf.append("<title></title>");
        buf.append("</head>");
        buf.append("<body style=\"width:" + width + "pt;margin-right:" + marginRight + "pt;margin-left:" + marginLeft + "pt;font-family:sans-serif;font-size:10pt;\">");
        return buf.toString();
    }

    public static void main(String[] args) {
        System.out.println("debut");
        String content = "<!DOCTYPE html><html><head><meta charset=\"utf-8\"/><title></title></head><body style=\"width:538pt; margin:28pt;font-family:liberation sans;font-size:10pt;\"><p>CECI EST UN TEXTE CECI EST UN TEXTE CECI EST UN TEXTE CECI EST UN TEXTE CECI EST UN TEXTE CECI EST UN TEXTE CECI EST UN TEXTE CECI EST UN TEXTE CECI EST UN TEXTE CECI EST UN TEXTE CECI EST UN TEXTE CECI EST UN TEXTE CECI EST UN TEXTE CECI EST UN TEXTE CECI EST UN TEXTE CECI EST UN TEXTE CECI EST UN TEXTE CECI EST UN TEXTE CECI EST UN TEXTE CECI EST UN TEXTE CECI EST UN TEXTE CECI EST UN TEXTE CECI EST UN TEXTE CECI EST UN TEXTE CECI EST UN TEXTE CECI EST UN TEXTE</p><p></p></body></html>";
        String res = PdfHtmlUtils.extractBody(content);
        System.out.println(res);
    }
}

