/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.engine.generator.zip;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.DeleteOnCloseFileInputStream;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.service.engine.generator.CoreGenerator;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipGeneratorTool {
    private ZipOutputStream out;
    private File temp;
    private List<String> fileNames = new ArrayList<String>();

    public ZipGeneratorTool() {
        try {
            this.temp = File.createTempFile("zipper", "zip");
            this.temp.deleteOnExit();
            this.out = new ZipOutputStream(new FileOutputStream(this.temp));
        }
        catch (IOException e) {
            throw new AmapjRuntimeException(e);
        }
    }

    public void addFile(String fileName, String extension, byte[] fileContent) {
        String realFileName = this.computeRealFileName(fileName);
        try {
            ZipEntry e = new ZipEntry(String.valueOf(realFileName) + "." + extension);
            this.out.putNextEntry(e);
            this.out.write(fileContent, 0, fileContent.length);
            this.out.closeEntry();
        }
        catch (IOException e) {
            throw new AmapjRuntimeException(e);
        }
    }

    private String computeRealFileName(String fileName) {
        String f1 = this.escapeFileName(fileName);
        if (this.fileNames.contains(f1)) {
            int index = 1;
            String f2 = String.valueOf(f1) + " (" + index + ")";
            while (this.fileNames.contains(f2)) {
                f2 = String.valueOf(f1) + " (" + ++index + ")";
            }
            this.fileNames.add(f2);
            return f2;
        }
        this.fileNames.add(f1);
        return f1;
    }

    private String escapeFileName(String fileName) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < fileName.length()) {
            sb.append(this.escape(fileName.charAt(i)));
            ++i;
        }
        return sb.toString();
    }

    private char escape(char c) {
        if (c >= '0' && c <= '9') {
            return c;
        }
        if (c >= 'a' && c <= 'z') {
            return c;
        }
        if (c >= 'A' && c <= 'Z') {
            return c;
        }
        if (c == '.' || c == '\'' || c == '(' || c == ')' || c == '!' || c == '%' || c == '_' || c == ' ' || c == '\u00e0' || c == '\u00e9' || c == '\u00e8' || c == '\u00ea' || c == '\u00ef' || c == '\u00ee' || c == '\u00c0' || c == '\u00c9' || c == '\u00c8' || c == '\u00ca' || c == '\u00cf') {
            return c;
        }
        return '_';
    }

    public void addFile(RdbLink em, CoreGenerator coreGenerator) {
        this.addFile(coreGenerator.getFileName(em), coreGenerator.getExtension(), coreGenerator.getByteArrayContent());
    }

    public InputStream getInputStream() {
        try {
            this.out.close();
            return new DeleteOnCloseFileInputStream(this.temp, true);
        }
        catch (IOException e) {
            throw new AmapjRuntimeException(e);
        }
    }
}

