/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.engine.objectstorage;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.NewTransaction;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.objectstorage.ObjectStorage;
import fr.amapj.model.models.objectstorage.ObjectStorageState;
import fr.amapj.service.engine.objectstorage.basestorage.BaseStorageService;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.io.IOUtils;

public class ObjectStorageService {
    private BaseStorageService baseStorageService;

    public ObjectStorageService(BaseStorageService baseStorageService) {
        this.baseStorageService = baseStorageService;
    }

    public byte[] get(ObjectStorage initial) {
        if (initial == null) {
            return null;
        }
        try {
            byte[] bs = this.baseStorageService.loadContent(initial);
            InputStream stream = new ByteArrayInputStream(bs);
            stream = new GZIPInputStream(stream);
            byte[] res = IOUtils.toByteArray((InputStream)stream);
            stream.close();
            return res;
        }
        catch (Exception e) {
            throw new AmapjRuntimeException(e);
        }
    }

    public ObjectStorage set(RdbLink em, ObjectStorage initial, byte[] content) {
        ByteArrayOutputStream baos;
        if (initial != null) {
            initial.state = ObjectStorageState.DELETED;
        }
        if (content == null) {
            return null;
        }
        ObjectStorage finalObject = new ObjectStorage();
        em.persist(finalObject);
        try {
            baos = new ByteArrayOutputStream();
            GZIPOutputStream os = new GZIPOutputStream(baos);
            os.write(content);
            os.close();
        }
        catch (IOException e) {
            throw new AmapjRuntimeException(e);
        }
        this.baseStorageService.saveContent(finalObject, baos.toByteArray());
        return finalObject;
    }

    public void forDeamonDeleteObjectDefinitively(Long idObjectStorage) {
        NewTransaction.write(em -> {
            this.baseStorageService.deleteContent(idObjectStorage);
            ObjectStorage os = em.find(ObjectStorage.class, idObjectStorage);
            em.remove(os);
        });
    }

    @DbRead
    public int countAllObjectStorage() {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            em.createQuery("select count(a) from ObjectStorage a");
            int n = em.result().singleInt();
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return n;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    public void close() {
        this.baseStorageService.close();
    }

    public String getStatistics() {
        return this.baseStorageService.getStatistic();
    }
}

