/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.engine.objectstorage;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.service.engine.objectstorage.ObjectStorageService;
import fr.amapj.service.engine.objectstorage.basestorage.local.LocalBaseObjectStorageService;
import fr.amapj.service.engine.objectstorage.basestorage.remote.RemoteBaseObjectStorageService;
import fr.amapj.view.engine.ui.AppConfiguration;

public class ObjectStorageServiceProvider {
    private static ObjectStorageService mainInstance;

    public static ObjectStorageService find() {
        if (mainInstance == null) {
            throw new AmapjRuntimeException("Vous devez d'abord initialiser le ObjectStorageServiceProvider");
        }
        return mainInstance;
    }

    public static void initialize() {
        mainInstance = ObjectStorageServiceProvider.buildMainInstance();
    }

    private static ObjectStorageService buildMainInstance() {
        AppConfiguration conf = AppConfiguration.getConf();
        if (conf.getS3StorageEndPoint() != null) {
            return new ObjectStorageService(new RemoteBaseObjectStorageService(conf));
        }
        return new ObjectStorageService(new LocalBaseObjectStorageService());
    }

    public static void close() {
        if (mainInstance != null) {
            mainInstance.close();
        }
    }

    public static String getStatistics() {
        return mainInstance.getStatistics();
    }
}

