/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.engine.objectstorage.basestorage.remote;

import fr.amapj.view.engine.ui.AppConfiguration;
import java.io.File;
import java.util.Map;
import org.ehcache.Cache;
import org.ehcache.PersistentCacheManager;
import org.ehcache.config.Builder;
import org.ehcache.config.builders.CacheConfigurationBuilder;
import org.ehcache.config.builders.CacheManagerBuilder;
import org.ehcache.config.builders.ResourcePoolsBuilder;
import org.ehcache.config.units.MemoryUnit;
import org.ehcache.core.internal.statistics.DefaultStatisticsService;
import org.ehcache.core.spi.service.StatisticsService;
import org.ehcache.core.statistics.CacheStatistics;
import org.ehcache.core.statistics.TierStatistics;
import org.ehcache.spi.service.Service;

public class CacheService {
    private PersistentCacheManager persistentCacheManager;
    private StatisticsService statisticsService = new DefaultStatisticsService();
    private Cache<String, byte[]> localCache;

    public CacheService(AppConfiguration app) {
        this.persistentCacheManager = (PersistentCacheManager)CacheManagerBuilder.newCacheManagerBuilder().using((Service)this.statisticsService).with(CacheManagerBuilder.persistence((File)new File(app.getLocalCacheDir()))).withCache("s3", (Builder)CacheConfigurationBuilder.newCacheConfigurationBuilder(String.class, byte[].class, (Builder)ResourcePoolsBuilder.newResourcePoolsBuilder().disk(Long.parseLong(app.getLocalCacheSize()), MemoryUnit.MB, true))).build(true);
        this.localCache = this.persistentCacheManager.getCache("s3", String.class, byte[].class);
    }

    public void save(String key, byte[] content) {
        this.localCache.put((Object)key, (Object)content);
    }

    public byte[] get(String key) {
        byte[] res = (byte[])this.localCache.get((Object)key);
        if (res == null) {
            return null;
        }
        return res;
    }

    public void remove(String key) {
        this.localCache.remove((Object)key);
    }

    public void close() {
        this.persistentCacheManager.close();
    }

    public String getStatistic() {
        CacheStatistics s = this.statisticsService.getCacheStatistics("s3");
        String res = "Cache hits \t= " + s.getCacheHits() + " (" + (int)s.getCacheHitPercentage() + " %)<br/>" + "Cache miss \t= " + s.getCacheMisses() + " (" + (int)s.getCacheMissPercentage() + " %)<br/>" + "Cache gets \t= " + s.getCacheGets() + "<br/>" + "Cache puts \t= " + s.getCachePuts() + "<br/>" + "Cache removals = " + s.getCacheRemovals() + "<br/>" + "Cache evictions= " + s.getCacheEvictions() + "<br/>" + "Cache expirations= " + s.getCacheExpirations() + "<br/>";
        for (Map.Entry tiers : s.getTierStatistics().entrySet()) {
            String tierName = (String)tiers.getKey();
            TierStatistics ts = (TierStatistics)tiers.getValue();
            res = String.valueOf(res) + "<br/>" + "Tier name \t\t\t= " + tierName + "<br/>" + "Nb Elements\t \t= " + ts.getMappings() + "<br/>" + "AllocatedByteSize \t= " + ts.getAllocatedByteSize() + "<br/>" + "OccupiedByteSize\t= " + ts.getOccupiedByteSize() + "<br/>";
        }
        return res;
    }
}

