/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.engine.objectstorage.basestorage.remote;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.model.engine.db.DbManager;
import fr.amapj.model.models.objectstorage.ObjectStorage;
import fr.amapj.service.engine.objectstorage.basestorage.BaseStorageService;
import fr.amapj.service.engine.objectstorage.basestorage.remote.CacheService;
import fr.amapj.service.engine.objectstorage.basestorage.remote.S3UseStatistic;
import fr.amapj.view.engine.ui.AppConfiguration;
import io.minio.GetObjectArgs;
import io.minio.MinioClient;
import io.minio.PutObjectArgs;
import io.minio.RemoveObjectArgs;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RemoteBaseObjectStorageService
implements BaseStorageService {
    private String s3StorageBucket = null;
    private String s3StorageKeyPrefix = null;
    private MinioClient minioClient;
    private CacheService cacheService;
    private S3UseStatistic s3Stats;
    private static final Logger logger = LogManager.getLogger();

    public RemoteBaseObjectStorageService(AppConfiguration app) {
        this.s3StorageBucket = app.getS3StorageBucket();
        this.s3StorageKeyPrefix = app.getS3StorageKeyPrefix();
        this.minioClient = MinioClient.builder().endpoint(app.getS3StorageEndPoint()).credentials(app.getS3StorageLogin(), app.getS3StoragePassword()).build();
        this.cacheService = new CacheService(app);
        this.s3Stats = new S3UseStatistic();
    }

    @Override
    public void saveContent(ObjectStorage initial, byte[] content) {
        String key = this.createKey(initial.id);
        logger.info("Sauvegarde S3Storage - key =" + key);
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(content);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("If-None-Match", "*");
            this.minioClient.putObject((PutObjectArgs)((PutObjectArgs.Builder)((PutObjectArgs.Builder)((PutObjectArgs.Builder)PutObjectArgs.builder().bucket(this.s3StorageBucket)).extraHeaders(headers)).object(key)).stream((InputStream)bais, (long)bais.available(), -1L).build());
            bais.close();
        }
        catch (Exception e) {
            throw new AmapjRuntimeException(e);
        }
        this.s3Stats.incrPut(content.length);
        logger.info("Sauvegarde Cache - key =" + key);
        this.cacheService.save(key, content);
    }

    @Override
    public byte[] loadContent(ObjectStorage initial) throws Exception {
        String key = this.createKey(initial.id);
        logger.info("Lecture Cache - key =" + key);
        byte[] fromCache = this.cacheService.get(key);
        if (fromCache != null) {
            return fromCache;
        }
        logger.info("Lecture S3Storage - key =" + key);
        InputStream stream = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.s3StorageBucket)).object(key)).build());
        byte[] bs = IOUtils.toByteArray((InputStream)stream);
        this.s3Stats.incrGet(bs.length);
        logger.info("Sauvegarde Cache - key =" + key);
        this.cacheService.save(key, bs);
        return bs;
    }

    @Override
    public void deleteContent(Long idObjectStorage) {
        String key = this.createKey(idObjectStorage);
        logger.info("Suppression S3Storage - key =" + key);
        try {
            this.minioClient.removeObject((RemoveObjectArgs)((RemoveObjectArgs.Builder)((RemoveObjectArgs.Builder)RemoveObjectArgs.builder().bucket(this.s3StorageBucket)).object(key)).build());
        }
        catch (Exception e) {
            throw new AmapjRuntimeException(e);
        }
        this.s3Stats.incrDelete();
        logger.info("Suppression Cache - key =" + key);
        this.cacheService.remove(key);
    }

    @Override
    public void close() {
        this.cacheService.close();
    }

    private String createKey(Long id) {
        return String.valueOf(this.s3StorageKeyPrefix) + "/" + DbManager.get().getCurrentDb().getDbName() + "/os/" + id % 100L + "/" + id;
    }

    @Override
    public String getStatistic() {
        return String.valueOf(this.s3Stats.getStatistics()) + this.cacheService.getStatistic();
    }

    public byte[] onlyForPatchLoadWebPageAsHtml(Long id) {
        try {
            String key = String.valueOf(this.s3StorageKeyPrefix) + "/" + DbManager.get().getCurrentDb().getDbName() + "/webpages/" + id;
            InputStream stream = this.minioClient.getObject((GetObjectArgs)((GetObjectArgs.Builder)((GetObjectArgs.Builder)GetObjectArgs.builder().bucket(this.s3StorageBucket)).object(key)).build());
            stream = new GZIPInputStream(stream);
            byte[] res = IOUtils.toByteArray((InputStream)stream);
            stream.close();
            return res;
        }
        catch (Exception e) {
            throw new AmapjRuntimeException(e);
        }
    }
}

