/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.engine.objectstorage.deamon;

import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.objectstorage.ObjectStorage;
import fr.amapj.model.models.objectstorage.ObjectStorageState;
import fr.amapj.service.engine.deamons.DeamonsUtils;
import fr.amapj.service.engine.objectstorage.ObjectStorageServiceProvider;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class ObjectStorageDeleteService
implements Job {
    private static final Logger logger = LogManager.getLogger();

    public void execute(JobExecutionContext context) throws JobExecutionException {
        DeamonsUtils.executeAsDeamon(this.getClass(), e -> this.deleteOldObjectStorage());
    }

    @DbRead
    public void deleteOldObjectStorage() {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            logger.info("Debut de l'effacement des objects storages");
            em.createQuery("select a from ObjectStorage a where a.state=:state");
            em.setParameter("state", (Object)ObjectStorageState.DELETED);
            List<ObjectStorage> oss = em.result().list(ObjectStorage.class);
            logger.info("Il y a " + oss.size() + " \u00e9lements \u00e0 effacer.");
            for (ObjectStorage os : oss) {
                logger.info("Effacement de " + os.id);
                ObjectStorageServiceProvider.find().forDeamonDeleteObjectDefinitively(os.id);
            }
            logger.info("Fin de l'effacement des object storage");
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }
}

