/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.engine.pdftools;

import com.lowagie.text.Document;
import com.lowagie.text.Rectangle;
import com.lowagie.text.pdf.BaseFont;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfCopy;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfStamper;
import com.lowagie.text.pdf.parser.PdfTextExtractor;
import fr.amapj.common.AmapjRuntimeException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class PdfTools {
    public Location findLocation(char c, PdfReader reader) throws IOException {
        int nb = reader.getNumberOfPages();
        int i = 1;
        while (i <= nb) {
            Location t = this.findLocationPage(c, reader, i);
            if (t != null) {
                return t;
            }
            ++i;
        }
        return null;
    }

    public Location findLocationPage(char c, PdfReader reader, int page) throws IOException {
        PdfTextExtractor extractor = new PdfTextExtractor(reader, true);
        String html = extractor.getTextFromPage(page, true);
        int index = html.indexOf(c);
        if (index == -1) {
            return null;
        }
        html = html.substring(0, index);
        index = html.lastIndexOf("bottom");
        html = html.substring(index + 8, html.length());
        index = html.indexOf("%; left: ");
        String bottom = html.substring(0, index);
        int index2 = html.indexOf("%; width:");
        String left = html.substring(index + 9, index2);
        Rectangle mediaBox = reader.getPageSize(page);
        mediaBox.normalize();
        float leftf = Float.parseFloat(left.replace(',', '.'));
        float bottomf = Float.parseFloat(bottom.replace(',', '.'));
        Location location = new Location();
        location.x = (int)(leftf * mediaBox.getWidth() / 100.0f);
        location.y = (int)((bottomf += (float)(page - 1) * 233.33f) * mediaBox.getHeight() / 100.0f);
        location.pageNumber = page;
        return location;
    }

    public void addTextToPdf(PdfReader reader, OutputStream os, Location l, String ... texts) throws IOException {
        int x = l.x;
        int y = l.y;
        int height = texts.length * 12;
        if (y < height) {
            y = height;
        }
        PdfStamper stamper = new PdfStamper(reader, os);
        PdfContentByte cb = stamper.getOverContent(l.pageNumber);
        cb.beginText();
        BaseFont bf = BaseFont.createFont((String)"Courier", (String)"Cp1252", (boolean)true);
        cb.setFontAndSize(bf, 10.0f);
        int i = 0;
        while (i < texts.length) {
            cb.setTextMatrix((float)x, (float)(y - 12 * i));
            cb.showText(texts[i]);
            ++i;
        }
        cb.endText();
        stamper.close();
    }

    public void concateTwoPdf(PdfReader pdfSrc, int nbPage, PdfReader pdfToAdd, OutputStream os) throws IOException {
        PdfImportedPage page;
        pdfSrc.consolidateNamedDestinations();
        pdfSrc.getNumberOfPages();
        Document document = new Document(pdfSrc.getPageSizeWithRotation(1));
        PdfCopy writer = new PdfCopy(document, os);
        document.open();
        int i = 1;
        while (i <= nbPage) {
            page = writer.getImportedPage(pdfSrc, i);
            writer.addPage(page);
            ++i;
        }
        if (pdfToAdd != null) {
            pdfToAdd.consolidateNamedDestinations();
            int nbToAdd = pdfToAdd.getNumberOfPages();
            int i2 = 1;
            while (i2 <= nbToAdd) {
                page = writer.getImportedPage(pdfToAdd, i2);
                writer.addPage(page);
                ++i2;
            }
        }
        document.close();
    }

    public int getNbPages(byte[] pdfContent) {
        try {
            PdfReader reader = new PdfReader(pdfContent);
            int nb = reader.getNumberOfPages();
            reader.close();
            return nb;
        }
        catch (IOException e) {
            throw new AmapjRuntimeException(e);
        }
    }

    public static void main(String[] args) throws Exception {
        System.out.println("start");
        int i = 0;
        while (i < 1000) {
            PdfTools.test2();
            ++i;
        }
        System.out.println("stop");
    }

    private static void test1() throws IOException {
        PdfReader reader = new PdfReader("C:/tmp/original.pdf");
        Location l = new PdfTools().findLocation('\u0142', reader);
        System.out.println("Location =" + l);
        new PdfTools().addTextToPdf(reader, new FileOutputStream("C:/tmp/original-stamped.pdf"), l, "Sign\u00e9 electroniquement", "le 06/06/2024 10:00:10", "par Toto DUPONT");
        reader.close();
    }

    private static void test2() throws IOException {
        PdfReader src = new PdfReader("C:/tmp/src.pdf");
        PdfReader add = new PdfReader("C:/tmp/add.pdf");
        FileOutputStream fos = new FileOutputStream("C:/tmp/out.pdf");
        new PdfTools().concateTwoPdf(src, 1, add, fos);
        src.close();
        add.close();
        fos.close();
    }

    public static class Location {
        public int pageNumber;
        public int x;
        public int y;

        public String toString() {
            return "Location [pageNumber=" + this.pageNumber + ", x=" + this.x + ", y=" + this.y + "]";
        }
    }
}

