/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.advanced.checkcoherence;

import fr.amapj.model.engine.db.DbManager;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.tools.SpecificDbUtils;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.fichierbase.RoleAdmin;
import fr.amapj.model.models.fichierbase.RoleTresorier;
import fr.amapj.service.services.appinstance.AppInstanceDTO;
import fr.amapj.service.services.gestioncontrat.datebarree.DateBarreCheckService;
import java.util.List;
import java.util.stream.Collectors;
import javax.persistence.TypedQuery;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CheckCoherenceService {
    private static final Logger logger = LogManager.getLogger();

    public String performCheck(List<AppInstanceDTO> apps) {
        StringBuffer str = new StringBuffer();
        for (AppInstanceDTO app : apps) {
            SpecificDbUtils.executeInSpecificDb(app.nomInstance, () -> this.patch(str));
        }
        return str.toString();
    }

    private Void patch(StringBuffer buf) {
        String dbName = DbManager.get().getCurrentDb().getDbName();
        this.msg(buf, "Traitement de la base " + dbName);
        this.doCheckQteSurDateBarrees(buf);
        return null;
    }

    @DbRead
    public void doCheckQteSurDateBarrees(StringBuffer buf) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            List<Long> idModeleContrats = this.getAllModeleContrats(buf);
            for (Long idModeleContrat : idModeleContrats) {
                this.checkQteSurDateBarrees(buf, idModeleContrat);
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private List<Long> getAllModeleContrats(StringBuffer buf) {
        RdbLink em = RdbLink.get();
        TypedQuery<Long> q = em.createQuery("select c.id from ModeleContrat c", Long.class);
        List ls = q.getResultList();
        return ls;
    }

    private void checkQteSurDateBarrees(StringBuffer buf, Long idModeleContrat) {
        RdbLink em = RdbLink.get();
        ModeleContrat mc = em.find(ModeleContrat.class, idModeleContrat);
        String msg = new DateBarreCheckService().checkCoherenceDateBarreesModeleContrat(idModeleContrat);
        if (msg != null) {
            msg = "===================================================================\nMails=" + this.getMailsAdmin(em) + "," + this.getMailsTresorier(em) + "\n\n" + "Il y a une incoh\u00e9rence pour le modele de contrat :" + mc.nom + "\n" + "Producteur=" + mc.producteur.nom + "\n" + "Etat=" + (Object)((Object)mc.etat) + "\n" + "D\u00e9tails : \n" + msg;
            this.msg(buf, msg);
        }
    }

    private String getMailsAdmin(RdbLink em) {
        TypedQuery<RoleAdmin> q = em.createQuery("select r from RoleAdmin r", RoleAdmin.class);
        return q.getResultList().stream().map(e -> e.utilisateur.email).distinct().collect(Collectors.joining(","));
    }

    private String getMailsTresorier(RdbLink em) {
        TypedQuery<RoleTresorier> q = em.createQuery("select r from RoleTresorier r", RoleTresorier.class);
        return q.getResultList().stream().map(e -> e.utilisateur.email).distinct().collect(Collectors.joining(","));
    }

    private void msg(StringBuffer str, String msg) {
        str.append(String.valueOf(msg.replaceAll("\n", "<br/>")) + "<br/>");
        logger.info(msg);
    }
}

