/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.advanced.tenantnotification;

import fr.amapj.messagingcenter.miniproxy.TNProxyClient;
import fr.amapj.messagingcenter.miniproxy.core.ServiceNotAvailableException;
import fr.amapj.messagingcenter.miniproxy.model.notification.DbHasNotification;
import fr.amapj.messagingcenter.miniproxy.model.notification.TenantNotificationDTO;
import fr.amapj.messagingcenter.miniproxy.model.notification.request.GetAllNotificationRequest;
import fr.amapj.messagingcenter.miniproxy.model.notification.request.HasNewNotificationRequest;
import fr.amapj.messagingcenter.miniproxy.model.notification.request.LoadNotificationRequest;
import fr.amapj.messagingcenter.miniproxy.model.notification.response.GetAllNotificationResponse;
import fr.amapj.messagingcenter.miniproxy.model.notification.response.HasNewNotificationResponse;
import fr.amapj.messagingcenter.miniproxy.model.notification.response.LoadNotificationResponse;
import fr.amapj.model.engine.db.DbManager;
import fr.amapj.model.models.acces.RoleList;
import fr.amapj.service.engine.deamons.DeamonsUtils;
import fr.amapj.service.services.advanced.tenantnotification.SmallTenantNotificationDTO;
import fr.amapj.service.services.session.SessionManager;
import fr.amapj.view.engine.ui.AppConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class TenantNotificationService
implements Job {
    private static final Logger logger = LogManager.getLogger();
    private static Map<String, DbHasNotification> notificationInfos = new HashMap<String, DbHasNotification>();

    public void execute(JobExecutionContext context) throws JobExecutionException {
        DeamonsUtils.executeAsDeamonInMaster(this.getClass(), e -> this.deamonUpdate());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deamonUpdate() {
        logger.info("D\u00e9marrage du service TenantNotificationService");
        HasNewNotificationRequest r = new HasNewNotificationRequest();
        r.dbNames = DbManager.get().getAllDbs().stream().map(e -> e.getDbName()).collect(Collectors.toList());
        try {
            HasNewNotificationResponse res = this.getProxy().hasNewNotification(r);
            Map<String, DbHasNotification> map = notificationInfos;
            synchronized (map) {
                notificationInfos.clear();
                for (DbHasNotification dbn : res.dbHasNotifications) {
                    notificationInfos.put(dbn.dbName, dbn);
                }
            }
        }
        catch (ServiceNotAvailableException e2) {
            throw new RuntimeException(e2);
        }
        logger.info("Fin du service TenantNotificationService");
    }

    public boolean isActif() {
        return AppConfiguration.getConf().getMessagingCenterUrl() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNewNotification() {
        if (!SessionManager.getUserRoles().contains((Object)RoleList.TRESORIER)) {
            return false;
        }
        String dbName = SessionManager.getDb().getDbName();
        Long idUser = SessionManager.getUserId();
        Map<String, DbHasNotification> map = notificationInfos;
        synchronized (map) {
            DbHasNotification dbn;
            block5: {
                dbn = notificationInfos.get(dbName);
                if (dbn != null) break block5;
                return false;
            }
            return !dbn.noNewMessageUsers.contains(idUser);
        }
    }

    public List<SmallTenantNotificationDTO> getAllNotifications() throws ServiceNotAvailableException {
        String dbName = SessionManager.getDb().getDbName();
        Long idUser = SessionManager.getUserId();
        this.saveMessageReadLocally(dbName, idUser);
        GetAllNotificationRequest request = new GetAllNotificationRequest();
        request.dbName = dbName;
        request.idUser = idUser;
        GetAllNotificationResponse response = this.getProxy().getAllNotifications(request);
        List notifications = response.notifications;
        ArrayList<SmallTenantNotificationDTO> res = new ArrayList<SmallTenantNotificationDTO>();
        for (TenantNotificationDTO t : notifications) {
            SmallTenantNotificationDTO small = new SmallTenantNotificationDTO();
            small.id = t.id;
            small.refDate = t.refDate;
            small.title = t.title;
            res.add(small);
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveMessageReadLocally(String dbName, Long idUser) {
        Map<String, DbHasNotification> map = notificationInfos;
        synchronized (map) {
            DbHasNotification dbn = notificationInfos.get(dbName);
            if (dbn != null && !dbn.noNewMessageUsers.contains(idUser)) {
                dbn.noNewMessageUsers.add(idUser);
            }
        }
    }

    public TenantNotificationDTO loadNotification(Long idNotification) throws ServiceNotAvailableException {
        LoadNotificationRequest request = new LoadNotificationRequest();
        request.idNotification = idNotification;
        LoadNotificationResponse response = this.getProxy().loadNotification(request);
        return response.notification;
    }

    private TNProxyClient getProxy() {
        AppConfiguration conf = AppConfiguration.getConf();
        return new TNProxyClient(conf.getMessagingCenterKey(), conf.getMessagingCenterUrl());
    }
}

