/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.archivage;

import fr.amapj.common.DateUtils;
import fr.amapj.common.FormatUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.DbWrite;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.contrat.modele.EtatModeleContrat;
import fr.amapj.model.models.contrat.modele.GestionPaiement;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.reel.Contrat;
import fr.amapj.model.models.contrat.reel.EtatPaiement;
import fr.amapj.model.models.contrat.reel.Paiement;
import fr.amapj.model.models.remise.RemiseProducteur;
import fr.amapj.service.services.archivage.tools.ArchivableState;
import fr.amapj.service.services.archivage.tools.SuppressionState;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.gestioncontrat.ModeleContratSummaryDTO;
import fr.amapj.service.services.mescontrats.MesContratsService;
import fr.amapj.service.services.parametres.ParametresArchivageDTO;
import fr.amapj.service.services.remiseproducteur.RemiseProducteurService;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import javax.persistence.TypedQuery;

public class ArchivageContratService {
    public String computeArchivageLib(ParametresArchivageDTO param) {
        String str = "Il est souhaitable d'archiver un contrat qui remplit les conditions suivantes : <ul><li>le contrat a \u00e9t\u00e9 enti\u00e8rement livr\u00e9</li><li>tous les paiements ont \u00e9t\u00e9 finalis\u00e9s</li><li>la date de derni\u00e8re livraison est plus vieille que " + param.archivageContrat + " jours</li>" + "</ul><br/>";
        return str;
    }

    @DbRead
    public ArchivableState computeArchivageState(Long idModeleContrat, ParametresArchivageDTO param) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            ArchivableState res = new ArchivableState();
            ModeleContrat mc = em.find(ModeleContrat.class, idModeleContrat);
            ModeleContratSummaryDTO dto = new GestionContratService().createModeleContratInfo(em, mc);
            if (mc.etat != EtatModeleContrat.ACTIF) {
                res.nonArchivables.add("Le contrat est \u00e0 l'\u00e9tat " + (Object)((Object)mc.etat) + ", il doit \u00eatre \u00e0 l'\u00e9tat ACTIF pour pouvoir \u00eatre archiv\u00e9.");
            }
            em.createQuery("select count(distinct(c.modeleContratDate)) from ContratCell c WHERE c.modeleContratDate.dateLiv>=:d AND c.modeleContratDate.modeleContrat.id=:mcid");
            em.setParameter("d", DateUtils.getDateWithNoTime());
            em.setParameter("mcid", idModeleContrat);
            int nbLiv = em.result().singleInt();
            if (nbLiv != 0) {
                res.nonArchivables.add("Il existe " + nbLiv + " livraisons \u00e0 r\u00e9aliser aujourd'hui ou dans le futur.");
            }
            if (mc.gestionPaiement == GestionPaiement.GESTION_STANDARD) {
                em.createQuery("select count(p) from Paiement p WHERE p.contrat.modeleContrat.id=:mcid AND p.etat!=:etat");
                em.setParameter("mcid", idModeleContrat);
                em.setParameter("etat", (Object)EtatPaiement.PRODUCTEUR);
                int nbCheque = em.result().singleInt();
                if (nbCheque != 0) {
                    res.reserveMajeures.add("Il existe " + nbCheque + " ch\u00e8ques qui n'ont pas \u00e9t\u00e9 remis au producteur.");
                }
            }
            Date ref = DateUtils.getDateWithNoTime();
            ref = DateUtils.addDays(ref, -param.archivageContrat);
            if (dto.dateFin != null && dto.dateFin.after(ref)) {
                res.reserveMineures.add("La date de la derni\u00e8re livraison est est assez r\u00e9cente : " + FormatUtils.getStdDate().format(dto.dateFin));
            }
            ArchivableState archivableState = res;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return archivableState;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    public List<ModeleContratSummaryDTO> getAllContratsArchivables(ParametresArchivageDTO param) {
        List<ModeleContratSummaryDTO> mcs = new GestionContratService().getModeleContratInfo(EtatModeleContrat.ACTIF);
        ArrayList<ModeleContratSummaryDTO> res = new ArrayList<ModeleContratSummaryDTO>();
        for (ModeleContratSummaryDTO mc : mcs) {
            ArchivableState state = this.computeArchivageState(mc.id, param);
            if (state.getStatus() != ArchivableState.AStatus.OUI_SANS_RESERVE) continue;
            res.add(mc);
        }
        res.sort(Comparator.comparing(e -> e.dateFin));
        return res;
    }

    public String computeSuppressionLib(ParametresArchivageDTO param) {
        String str = "Il est souhaitable de supprimer un contrat qui remplit les conditions suivantes : <ul><li>le contrat est \u00e0 l'\u00e9tat Archiv\u00e9</li><li>la date de derni\u00e8re livraison est plus vieille que " + param.suppressionContrat + " jours</li>" + "</ul><br/>";
        return str;
    }

    public SuppressionState computeSuppressionState(ModeleContratSummaryDTO mc, ParametresArchivageDTO param) {
        SuppressionState res = new SuppressionState();
        if (mc.etat != EtatModeleContrat.ARCHIVE) {
            res.nonSupprimables.add("Le contrat est \u00e0 l'\u00e9tat " + (Object)((Object)mc.etat) + ", il doit \u00eatre \u00e0 l'\u00e9tat ARCHIVE pour pouvoir \u00eatre supprim\u00e9.");
        }
        Date ref = DateUtils.getDateWithNoTime();
        if (mc.dateFin.after(ref = DateUtils.addDays(ref, -param.suppressionContrat))) {
            res.reserveMajeures.add("La date de la derni\u00e8re livraison est trop r\u00e9cente : " + FormatUtils.getStdDate().format(mc.dateFin));
        }
        return res;
    }

    public List<ModeleContratSummaryDTO> getAllContratSupprimables(ParametresArchivageDTO param) {
        List<ModeleContratSummaryDTO> mcs = new GestionContratService().getModeleContratInfo(EtatModeleContrat.ARCHIVE);
        ArrayList<ModeleContratSummaryDTO> res = new ArrayList<ModeleContratSummaryDTO>();
        for (ModeleContratSummaryDTO mc : mcs) {
            SuppressionState state = this.computeSuppressionState(mc, param);
            if (state.getStatus() != SuppressionState.SStatus.OUI_SANS_RESERVE) continue;
            res.add(mc);
        }
        res.sort(Comparator.comparing(e -> e.dateFin));
        return res;
    }

    @DbWrite
    public void deleteModeleContratAndContrats(Long modeleContratId) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            ModeleContrat mc = em.find(ModeleContrat.class, modeleContratId);
            List<RemiseProducteur> remises = this.getAllRemises(em, mc);
            for (RemiseProducteur remiseProducteur : remises) {
                new RemiseProducteurService().deleteRemise(remiseProducteur.getId());
            }
            List<Paiement> paiements = this.getAllPaiements(em, mc);
            for (Paiement paiement : paiements) {
                em.remove(paiement);
            }
            List<Contrat> cs = this.getAllContrats(em, mc);
            for (Contrat contrat : cs) {
                new MesContratsService().deleteContrat(contrat.getId());
            }
            new GestionContratService().deleteContrat(modeleContratId);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    private List<RemiseProducteur> getAllRemises(RdbLink em, ModeleContrat mc) {
        TypedQuery<RemiseProducteur> q = em.createQuery("select r from RemiseProducteur r  WHERE r.datePaiement.modeleContrat=:mc ORDER BY r.datePaiement.datePaiement desc", RemiseProducteur.class);
        q.setParameter("mc", (Object)mc);
        return q.getResultList();
    }

    private List<Paiement> getAllPaiements(RdbLink em, ModeleContrat mc) {
        TypedQuery<Paiement> q = em.createQuery("select p from Paiement p  WHERE p.contrat.modeleContrat=:mc", Paiement.class);
        q.setParameter("mc", (Object)mc);
        return q.getResultList();
    }

    private List<Contrat> getAllContrats(RdbLink em, ModeleContrat mc) {
        TypedQuery<Contrat> q = em.createQuery("select c from Contrat c WHERE c.modeleContrat=:mc", Contrat.class);
        q.setParameter("mc", (Object)mc);
        return q.getResultList();
    }
}

