/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.authentification;

import fr.amapj.common.DateUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class AuthentificationCounter {
    private List<Info> infos = new ArrayList<Info>();

    public synchronized void addUnknow() {
        Date d = DateUtils.getDateWithNoTime();
        Info info = this.findInfo(d);
        ++info.unknowLogin;
    }

    public synchronized void addBadPassword() {
        Date d = DateUtils.getDateWithNoTime();
        Info info = this.findInfo(d);
        ++info.badPassword;
    }

    private Info findInfo(Date d) {
        Info info2;
        for (Info info2 : this.infos) {
            if (!info2.date.equals(d)) continue;
            return info2;
        }
        info2 = new Info();
        info2.date = d;
        this.infos.add(info2);
        return info2;
    }

    public synchronized String getLastInfo() {
        Collections.sort(this.infos, (d1, d2) -> d2.date.compareTo(d1.date));
        if (this.infos.size() == 0) {
            return "No info";
        }
        Info info = this.infos.get(0);
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        return "Date :" + df.format(info.date) + " Erreur mot de passe:" + info.badPassword + " Erreur login:" + info.unknowLogin;
    }

    public synchronized String getAllInfos() {
        Collections.sort(this.infos, (d1, d2) -> d2.date.compareTo(d1.date));
        if (this.infos.size() == 0) {
            return "No info";
        }
        StringBuffer buf = new StringBuffer();
        SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");
        for (Info info : this.infos) {
            buf.append("Date :" + df.format(info.date) + " Erreur mot de passe:" + info.badPassword + " Erreur login:" + info.unknowLogin + "<br/>");
        }
        return buf.toString();
    }

    public static class Info {
        Date date;
        int unknowLogin;
        int badPassword;
    }
}

