/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.authentification;

import com.vaadin.ui.UI;
import fr.amapj.common.DateUtils;
import fr.amapj.common.RandomUtils;
import fr.amapj.model.engine.db.DbManager;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.tools.TestTools;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.DbWrite;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.acces.RoleList;
import fr.amapj.model.models.fichierbase.EtatUtilisateur;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.model.models.saas.TypLog;
import fr.amapj.service.engine.sudo.SudoManager;
import fr.amapj.service.services.access.AccessManagementService;
import fr.amapj.service.services.appinstance.LogAccessDTO;
import fr.amapj.service.services.authentification.AuthentificationCounter;
import fr.amapj.service.services.authentification.PasswordEncryptionService;
import fr.amapj.service.services.logview.LogViewService;
import fr.amapj.service.services.mailer.MailerMessage;
import fr.amapj.service.services.mailer.MailerService;
import fr.amapj.service.services.parametres.ParametresDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.service.services.session.SessionManager;
import fr.amapj.service.services.session.SessionParameters;
import fr.amapj.view.engine.ui.AmapJLogManager;
import java.util.Date;
import java.util.List;
import javax.persistence.TypedQuery;
import org.apache.commons.codec.binary.Base64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PasswordManager {
    private static final Logger logger = LogManager.getLogger();
    public static final AuthentificationCounter authentificationCounter = new AuthentificationCounter();
    public PasswordEncryptionService passwordEncryptionService = new PasswordEncryptionService();

    @DbRead
    public String checkUser(String email, String password, String sudo) {
        try {
            String string;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            if ((password == null || password.equals("")) && sudo == null) {
                string = "Vous n'avez pas saisi le mot de passe";
            } else {
                Utilisateur u = this.findUser(email, em);
                if (u == null) {
                    authentificationCounter.addUnknow();
                    string = "Adresse e-mail ou mot de passe incorrect";
                } else if (u.etatUtilisateur == EtatUtilisateur.INACTIF) {
                    string = "Votre compte a \u00e9t\u00e9 d\u00e9sactiv\u00e9 car vous n'\u00eates plus membre de l'AMAP.";
                } else {
                    String msg = this.checkCredential(u, password, sudo);
                    String ip = UI.getCurrent().getPage().getWebBrowser().getAddress();
                    String browser = SessionManager.getAgentName(UI.getCurrent());
                    String dbName = DbManager.get().getCurrentDb().getDbName();
                    if (msg != null) {
                        authentificationCounter.addBadPassword();
                        logger.info("Authentification en echec pour ip={} browser={} dbName={} msg={}", (Object)ip, (Object)browser, (Object)dbName, (Object)msg);
                        string = msg;
                    } else {
                        LogAccessDTO logAccessDTO = new LogViewService().saveAccess(u.nom, u.prenom, u.getId(), ip, browser, dbName, TypLog.USER, sudo != null);
                        SessionParameters p = new SessionParameters();
                        p.userId = u.getId();
                        p.userRole = new AccessManagementService().getUserRole(u, em);
                        p.userNom = u.nom;
                        p.userPrenom = u.prenom;
                        p.userEmail = email;
                        p.dateConnexion = logAccessDTO.dateIn;
                        p.logId = logAccessDTO.id;
                        p.isSudo = sudo != null;
                        p.logFileName = logAccessDTO.logFileName;
                        SessionManager.setSessionParameters(p);
                        string = null;
                    }
                }
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return string;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private String checkCredential(Utilisateur u, String password, String sudo) {
        if (sudo != null) {
            return this.checkCredentialBySudo(u, sudo);
        }
        return this.checkCredentialByPassword(u, password);
    }

    private String checkCredentialBySudo(Utilisateur u, String sudo) {
        String nomInstance = DbManager.get().getCurrentDb().getDbName();
        String session = UI.getCurrent().getSession().getCsrfToken();
        if (!SudoManager.authenticate(sudo, u.getId(), nomInstance, session)) {
            return "Incorrect";
        }
        return null;
    }

    private String checkCredentialByPassword(Utilisateur u, String password) {
        byte[] salt;
        byte[] encryptedPassword = this.toByteArray(u.password);
        if (!this.passwordEncryptionService.authenticate(password, encryptedPassword, salt = this.toByteArray(u.salt))) {
            return "Adresse e-mail ou mot de passe incorrect";
        }
        return null;
    }

    private Utilisateur findUser(String email, RdbLink em) {
        if (email == null || email.equals("")) {
            return null;
        }
        TypedQuery<Utilisateur> q = em.createQuery("select u from Utilisateur u where u.email=:email", Utilisateur.class);
        q.setParameter("email", (Object)email);
        List us = q.getResultList();
        if (us.size() == 0) {
            return null;
        }
        if (us.size() > 1) {
            logger.warn("Il y a plusieurs utilisateurs avec l'adresse " + email);
            return null;
        }
        return (Utilisateur)us.get(0);
    }

    @DbWrite
    public boolean setUserPassword(Long userId, String clearPassword) {
        try {
            boolean bl;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            Utilisateur r = em.find(Utilisateur.class, userId);
            if (r == null) {
                logger.warn("Impossible de retrouver l'utilisateur avec l'id " + userId);
                bl = false;
            } else {
                if (r.salt == null) {
                    r.salt = this.fromByteArray(this.passwordEncryptionService.generateSalt());
                }
                byte[] salt = this.toByteArray(r.salt);
                byte[] encryptedPass = this.passwordEncryptionService.getEncryptedPassword(clearPassword, salt);
                r.password = this.fromByteArray(encryptedPass);
                r.resetPasswordDate = null;
                r.resetPasswordSalt = null;
                bl = true;
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return bl;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    private byte[] toByteArray(String base64str) {
        return Base64.decodeBase64((byte[])base64str.getBytes());
    }

    private String fromByteArray(byte[] flux) {
        return new String(Base64.encodeBase64((byte[])flux));
    }

    @DbWrite
    public String sendMailForResetPassword(String email) {
        try {
            String string;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            Utilisateur u = this.findUser(email, em);
            if (u == null) {
                string = "Votre adresse e mail est inconnue";
            } else if (u.etatUtilisateur == EtatUtilisateur.INACTIF) {
                string = "Votre compte a \u00e9t\u00e9 d\u00e9sactiv\u00e9 car vous n'\u00eates plus membre de l'AMAP.";
            } else {
                List<RoleList> rs = new AccessManagementService().getUserRole(u, em);
                if (rs.contains((Object)RoleList.MASTER)) {
                    string = "Impossible";
                } else {
                    u.resetPasswordDate = DateUtils.getDate();
                    u.resetPasswordSalt = RandomUtils.generatePasswordMin(20);
                    ParametresDTO parametresDTO = new ParametresService().getParametres();
                    String link = String.valueOf(parametresDTO.getUrl()) + "?resetPassword=" + u.resetPasswordSalt;
                    StringBuffer buf = new StringBuffer();
                    buf.append("<h2>" + parametresDTO.nomAmap + "</h2>");
                    buf.append("<br/>");
                    buf.append("Vous avez demand\u00e9 la r\u00e9 initialisation de votre mot de passe");
                    buf.append("<br/>");
                    buf.append("Merci de cliquer sur le lien ci dessous pour saisir votre nouveau mot de passe");
                    buf.append("<br/>");
                    buf.append("<br/>");
                    buf.append("<a href=\"" + link + "\">Cliquez ici pour changer votre mot de passe</a>");
                    buf.append("<br/>");
                    buf.append("<br/>");
                    buf.append("Si vous n'avez pas demand\u00e9 \u00e0 changer de mot de passe, merci de ne pas tenir compte de ce mail");
                    buf.append("<br/>");
                    new MailerService().sendHtmlMail(new MailerMessage(email, "Changement de votre mot de passe", buf.toString()));
                    string = null;
                }
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return string;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbRead
    public Long findUserWithResetPassword(String resetPasswordSalt) {
        try {
            Long l;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            if (resetPasswordSalt == null || resetPasswordSalt.equals("")) {
                l = null;
            } else {
                TypedQuery<Utilisateur> q = em.createQuery("select u from Utilisateur u where u.resetPasswordSalt=:resetPasswordSalt", Utilisateur.class);
                q.setParameter("resetPasswordSalt", (Object)resetPasswordSalt);
                List us = q.getResultList();
                if (us.size() == 0) {
                    l = null;
                } else if (us.size() > 1) {
                    logger.warn("Il y a plusieurs utilisateurs avec le salt " + resetPasswordSalt);
                    l = null;
                } else {
                    Utilisateur u = (Utilisateur)us.get(0);
                    if (u.etatUtilisateur == EtatUtilisateur.INACTIF) {
                        l = null;
                    } else {
                        Date datLimit = DateUtils.addDays(DateUtils.getDate(), -1);
                        if (u.resetPasswordDate.before(datLimit)) {
                            logger.info("Demande trop ancienne");
                            l = null;
                        } else {
                            l = u.id;
                        }
                    }
                }
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return l;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    public void disconnect() {
        SessionParameters p = SessionManager.getSessionParameters();
        if (p == null) {
            return;
        }
        logger.info("D\u00e9connexion r\u00e9ussie pour {} {} {}", (Object)p.userNom, (Object)p.userPrenom, (Object)p.userId);
        SessionManager.setSessionParameters(null);
        new LogViewService().endAccess(p.logId, p.getNbError());
        AmapJLogManager.endLog(true, p.logFileName);
    }

    public static void main(String[] args) {
        TestTools.init();
        new PasswordManager().setUserPassword(new Long(1052L), "a");
    }
}

