/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.backupdb;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.DateUtils;
import fr.amapj.common.FormatUtils;
import fr.amapj.model.engine.db.DbManager;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.tools.SpecificDbUtils;
import fr.amapj.model.engine.tools.TestTools;
import fr.amapj.model.engine.transaction.DbWrite;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.param.paramecran.PEExtendedParametres;
import fr.amapj.service.engine.deamons.DeamonsContext;
import fr.amapj.service.engine.deamons.DeamonsUtils;
import fr.amapj.service.services.advanced.maintenance.MaintenanceService;
import fr.amapj.service.services.mailer.MailerAttachement;
import fr.amapj.service.services.mailer.MailerMessage;
import fr.amapj.service.services.mailer.MailerService;
import fr.amapj.service.services.parametres.ParametresDTO;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.view.engine.menu.MenuList;
import fr.amapj.view.engine.ui.AppConfiguration;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class BackupDatabaseService
implements Job {
    private static final Logger logger = LogManager.getLogger();

    public void execute(JobExecutionContext context) throws JobExecutionException {
        PEExtendedParametres pe = SpecificDbUtils.executeInMaster(() -> (PEExtendedParametres)new ParametresService().loadParamEcran(MenuList.EXTENDED_PARAMETRES));
        DeamonsUtils.executeAsDeamon(this.getClass(), e -> this.backupDatabase((DeamonsContext)e, pEExtendedParametres.masterDbEmailBackupContent));
    }

    @DbWrite
    public void backupDatabase(DeamonsContext deamonsContext, String emailBackupContent) {
        try {
            boolean ret;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            String dbName = DbManager.get().getCurrentDb().getDbName();
            String version = new MaintenanceService().getShortVersion();
            logger.info("Debut de la sauvegarde de la base pour " + dbName);
            String backupDir = AppConfiguration.getConf().getBackupDirectory();
            if (backupDir == null) {
                throw new AmapjRuntimeException("Le r\u00e9pertoire de stockage des sauvegardes n'est pas d\u00e9fini");
            }
            Date ref = DateUtils.getDate();
            SimpleDateFormat df1 = new SimpleDateFormat("yyyy_MM_dd");
            SimpleDateFormat df2 = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss");
            String shortRepName = df1.format(ref);
            String shortFileName = String.valueOf(dbName) + "_" + version + "_" + df2.format(ref) + ".tar.gz";
            String fullRepName = String.valueOf(backupDir) + "/" + shortRepName;
            String fullFileName = String.valueOf(fullRepName) + "/" + shortFileName;
            File rep = new File(fullRepName);
            if (!rep.exists() && !(ret = rep.mkdir())) {
                throw new AmapjRuntimeException("Impossible de cr\u00e9er le repertoire :" + fullRepName);
            }
            em.createNativeQuery("BACKUP DATABASE TO '" + fullFileName + "' BLOCKING").executeUpdate();
            File file = new File(fullFileName);
            if (!file.canRead()) {
                throw new AmapjRuntimeException("Erreur lors de la sauvegarde. Impossible de lire le fichier");
            }
            ParametresDTO param = new ParametresService().getParametres();
            String htmlContent = this.computeHtmlContent(param, emailBackupContent, version, ref, dbName);
            MailerMessage message = new MailerMessage(param.backupReceiver, "Backup de la base de " + param.nomAmap, htmlContent);
            message.addAttachement(new MailerAttachement(file));
            new MailerService().sendHtmlMail(message);
            logger.info("Fin de la sauvegarde de la base pour " + dbName);
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    private String computeHtmlContent(ParametresDTO param, String htmlContent, String version, Date ref, String dbName) {
        if (htmlContent == null) {
            htmlContent = "Sauvegarde de la base #DB# (Nom de l'AMAP : #NOM_AMAP#)";
        }
        htmlContent = htmlContent.replaceAll("\r\n", "<br/>");
        htmlContent = htmlContent.replaceAll("\n", "<br/>");
        htmlContent = htmlContent.replaceAll("\r", "<br/>");
        htmlContent = htmlContent.replaceAll("#NOM_AMAP#", param.nomAmap);
        htmlContent = htmlContent.replaceAll("#DATE_REF#", FormatUtils.getTimeStd().format(ref));
        htmlContent = htmlContent.replaceAll("#VERSION#", version);
        htmlContent = htmlContent.replaceAll("#DB#", dbName);
        return htmlContent;
    }

    public static void main(String[] args) {
        TestTools.init();
        new BackupDatabaseService().backupDatabase(new DeamonsContext(), "");
    }
}

