/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.contratsamapien;

import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.reel.Contrat;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.service.services.contratsamapien.AmapienContratDTO;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.gestioncontratsigne.GestionContratSigneService;
import fr.amapj.service.services.mescontrats.MesContratsService;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Query;

public class AmapienContratsService {
    @DbRead
    public List<AmapienContratDTO> getAllContratsDTO(Long userId) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            new MesContratsService();
            GestionContratSigneService gestionContratSigneService = new GestionContratSigneService();
            ArrayList<AmapienContratDTO> res = new ArrayList<AmapienContratDTO>();
            Utilisateur user = em.find(Utilisateur.class, userId);
            Query q = em.createQuery("select c from Contrat c WHERE c.utilisateur=:u");
            q.setParameter("u", (Object)user);
            List contrats = q.getResultList();
            for (Contrat contrat : contrats) {
                ModeleContrat mc = contrat.modeleContrat;
                GestionContratService.DateInfo di = new GestionContratService().getDateDebutFin(em, mc);
                AmapienContratDTO dto = new AmapienContratDTO();
                dto.nomContrat = contrat.modeleContrat.nom;
                dto.nomProducteur = contrat.modeleContrat.producteur.nom;
                dto.dateDebut = di.dateDebut;
                dto.dateFin = di.dateFin;
                dto.dateCreation = contrat.dateCreation;
                dto.dateModification = contrat.dateModification;
                dto.montant = gestionContratSigneService.getMontant(em, contrat);
                dto.idContrat = contrat.getId();
                dto.idModeleContrat = mc.getId();
                dto.idUtilisateur = userId;
                dto.idProducteur = contrat.modeleContrat.producteur.id;
                dto.prenomUtilisateur = contrat.utilisateur.prenom;
                dto.nomUtilisateur = contrat.utilisateur.nom;
                res.add(dto);
            }
            ArrayList<AmapienContratDTO> arrayList = res;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return arrayList;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }
}

