/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.demoservice;

import fr.amapj.common.DateUtils;
import fr.amapj.common.FormatUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbWrite;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.contrat.modele.EtatModeleContrat;
import fr.amapj.model.models.contrat.modele.GestionDocEngagement;
import fr.amapj.model.models.contrat.modele.GestionPaiement;
import fr.amapj.model.models.contrat.modele.JokerMode;
import fr.amapj.model.models.contrat.modele.NatureContrat;
import fr.amapj.model.models.contrat.modele.RetardataireAutorise;
import fr.amapj.model.models.contrat.modele.SaisiePaiementCalculDate;
import fr.amapj.model.models.contrat.modele.SaisiePaiementModifiable;
import fr.amapj.model.models.contrat.modele.SaisiePaiementProposition;
import fr.amapj.model.models.contrat.modele.StockGestion;
import fr.amapj.model.models.contrat.modele.StrategiePaiement;
import fr.amapj.model.models.contrat.modele.TypJoker;
import fr.amapj.model.models.fichierbase.EtatNotification;
import fr.amapj.model.models.fichierbase.Producteur;
import fr.amapj.model.models.fichierbase.ProducteurNotificationRetardataire;
import fr.amapj.model.models.fichierbase.ProducteurReferent;
import fr.amapj.model.models.fichierbase.ProducteurStockGestion;
import fr.amapj.model.models.fichierbase.ProducteurUtilisateur;
import fr.amapj.model.models.fichierbase.Produit;
import fr.amapj.model.models.fichierbase.RoleAdmin;
import fr.amapj.model.models.fichierbase.RoleMaster;
import fr.amapj.model.models.fichierbase.RoleTresorier;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.model.models.param.ChoixOuiNon;
import fr.amapj.model.models.param.EtatModule;
import fr.amapj.model.models.param.Parametres;
import fr.amapj.model.models.param.paramecran.PEExtendedParametres;
import fr.amapj.model.models.saas.AppInstance;
import fr.amapj.model.models.saas.StateOnStart;
import fr.amapj.model.models.saas.TypDbExemple;
import fr.amapj.service.services.appinstance.AppInstanceDTO;
import fr.amapj.service.services.authentification.PasswordManager;
import fr.amapj.service.services.gestioncontrat.GestionContratService;
import fr.amapj.service.services.gestioncontrat.LigneContratDTO;
import fr.amapj.service.services.gestioncontrat.ModeleContratDTO;
import fr.amapj.service.services.gestioncontrat.ModeleContratSummaryDTO;
import fr.amapj.service.services.gestioncotisation.GestionCotisationService;
import fr.amapj.service.services.gestioncotisation.PeriodeCotisationDTO;
import fr.amapj.service.services.mesadhesions.AdhesionDTO;
import fr.amapj.service.services.mesadhesions.MesAdhesionDTO;
import fr.amapj.service.services.mesadhesions.MesAdhesionsService;
import fr.amapj.service.services.parametres.ParametresService;
import fr.amapj.view.engine.menu.MenuList;
import fr.amapj.view.engine.popup.formpopup.OnSaveException;
import fr.amapj.view.views.gestioncontrat.editorpart.FrequenceLivraison;
import fr.amapj.view.views.gestioncontrat.editorpart.utils.GestionContratDateUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;

public class DemoService {
    @DbWrite
    public Void generateDemoData(AppInstanceDTO dto) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            this.createParamGeneraux(em, dto);
            if (dto.typDbExemple == TypDbExemple.BASE_EXEMPLE) {
                this.createUtilisateurs(em, dto.password);
                this.createRoleUtilisateur(em);
                this.createProducteur(em);
                this.createProduit(em);
                Long idPeriodeCotisation = this.createPeriodeCotisation(em, dto.dateDebut, dto.dateFin);
                this.createCotisation(idPeriodeCotisation);
                this.createContrat(em, dto.dateDebut, dto.dateFin, dto.dateFinInscription, idPeriodeCotisation);
            } else if (dto.typDbExemple == TypDbExemple.BASE_MANUAL_TEST) {
                this.createUtilisateurs(em, dto.password);
                this.createRoleUtilisateur(em);
                this.createProducteur(em);
                this.createProduit(em);
                Long idPeriodeCotisation = this.createPeriodeCotisation(em, dto.dateDebut, dto.dateFin);
                this.createContratManualTest(em, dto.dateDebut, dto.dateFin, dto.dateFinInscription, idPeriodeCotisation);
                this.createCotisation(idPeriodeCotisation);
            } else if (dto.typDbExemple == TypDbExemple.BASE_MINIMALE) {
                this.createOneAdminUtilisateur(em, dto);
            } else if (dto.typDbExemple == TypDbExemple.BASE_MASTER) {
                if (dto.user1Nom != null) {
                    this.createOneMasterUtilisateur(em, dto);
                }
                this.createOneAppInstance(em, dto);
                this.createPEStatusPageAsDemo(dto);
            }
            Void void_ = null;
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return void_;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    private void createParamGeneraux(RdbLink em, AppInstanceDTO dto) {
        Parametres p = new Parametres();
        p.setId(1L);
        p.nomAmap = dto.nomAmap;
        p.villeAmap = dto.villeAmap;
        p.smtpType = dto.smtpType;
        p.sendingMailUsername = dto.adrMailSrc;
        p.sendingMailPassword = "";
        p.sendingMailFooter = "Merci de ne pas r\u00e9pondre \u00e0 ce message.<br/>Pour toute demande, merci de contacter votre Amap avec son mail habituel.<br/>";
        p.sendingMailNbMax = dto.nbMailMax;
        p.url = dto.url;
        p.mailCopyTo = "";
        p.backupReceiver = "";
        p.etatPlanningDistribution = EtatModule.INACTIF;
        p.envoiMailRappelPermanence = ChoixOuiNon.NON;
        p.envoiMailPeriodique = ChoixOuiNon.NON;
        p.etatGestionCotisation = EtatModule.ACTIF;
        p.etatGestionStock = EtatModule.INACTIF;
        p.archivageContrat = 180;
        p.suppressionContrat = 730;
        p.archivageUtilisateur = 90;
        p.archivageProducteur = 365;
        p.suppressionPeriodePermanence = 730;
        p.suppressionPeriodeCotisation = 1095;
        em.persist(p);
    }

    private void createUtilisateurs(RdbLink em, String password) {
        this.insertUtilisateur(em, 1051, "TREMBLAY", "Antonin", "antonin.tremblay@example.fr", password);
        this.insertUtilisateur(em, 1052, "DUPUIS", "Romain", "romain.dupuis@example.fr", password);
        this.insertUtilisateur(em, 1507, "DUBOIS", "R\u00e9mi", "remi.dubois@example.fr", password);
        this.insertUtilisateur(em, 1508, "GAGNON", "Magali", "magali.gagnon@example.fr", password);
        this.insertUtilisateur(em, 1509, "ROY", "Gaelle", "gaelle.roy@example.fr", password);
        this.insertUtilisateur(em, 1510, "C\u00d4T\u00c9", "Nathalie", "nathalie.cote@example.fr", password);
        this.insertUtilisateur(em, 1511, "BOUCHARD", "Benjamin", "benjamin.bouchard@example.fr", password);
        this.insertUtilisateur(em, 1512, "GAUTHIER", "Alex", "alex.gauthier@example.fr", password);
        this.insertUtilisateur(em, 1513, "MORIN", "Karine", "karine.morin@example.fr", password);
        this.insertUtilisateur(em, 1514, "LAVOIE", "Arthur", "arthur.lavoie@example.fr", password);
        this.insertUtilisateur(em, 1515, "FORTIN", "Sophie", "sophie.fortin@example.fr", password);
        this.insertUtilisateur(em, 1517, "OUELLET", "Mathis", "mathis.ouellet@example.fr", password);
        this.insertUtilisateur(em, 1518, "PELLETIER", "Matthieu", "matthieu.pelletier@example.fr", password);
        this.insertUtilisateur(em, 1519, "B\u00c9LANGER", "David", "david.belanger@example.fr", password);
        this.insertUtilisateur(em, 1520, "L\u00c9VESQUE", "Joelle", "joelle.levesque@example.fr", password);
        this.insertUtilisateur(em, 1522, "BERGERON", "Nadege", "nadege.bergeron@example.fr", password);
        this.insertUtilisateur(em, 1601, "LEBLANC", "Jeanne", "jeanne.leblanc@example.fr", password);
        this.insertUtilisateur(em, 1602, "PAQUETTE", "Emeline", "emeline.paquette@example.fr", password);
        this.insertUtilisateur(em, 1603, "GIRARD", "Florent", "florent.girard@example.fr", password);
        this.insertUtilisateur(em, 1604, "SIMARD", "Pascal", "pascal.simard@example.fr", password);
        this.insertUtilisateur(em, 1651, "BOUCHER", "Charles", "charles.boucher@example.fr", password);
        this.insertUtilisateur(em, 1652, "CARON", "Jean-Luc", "jean-luc.caron@example.fr", password);
        this.insertUtilisateur(em, 1653, "BEAULIEU", "Myl\u00e8ne", "mylene.beaulieu@example.fr", password);
        this.insertUtilisateur(em, 1654, "CLOUTIER", "Nadine", "nadine.cloutier@example.fr", password);
        this.insertUtilisateur(em, 1655, "DUB\u00c9", "Marine", "marine.dube@example.fr", password);
        this.insertUtilisateur(em, 1656, "POIRIER", "Fr\u00e9d\u00e9ric", "frederic.poirier@example.fr", password);
        this.insertUtilisateur(em, 1657, "FOURNIER", "Yves", "yves.fournier@example.fr", password);
        this.insertUtilisateur(em, 1659, "LAPOINTE", "Bruno", "bruno.lapointe@example.fr", password);
    }

    private void createRoleUtilisateur(RdbLink em) {
        RoleTresorier rt = new RoleTresorier();
        rt.utilisateur = em.find(Utilisateur.class, new Long(1051L));
        em.persist(rt);
        RoleAdmin ra = new RoleAdmin();
        ra.utilisateur = em.find(Utilisateur.class, new Long(1052L));
        em.persist(ra);
    }

    private void insertUtilisateur(RdbLink em, int id, String nom, String prenom, String email, String password) {
        Utilisateur u = new Utilisateur();
        u.setId(new Long(id));
        u.nom = nom;
        u.prenom = prenom;
        u.email = email;
        u.dateCreation = DateUtils.suppressTime(DateUtils.getDate());
        em.persist(u);
        new PasswordManager().setUserPassword(u.getId(), password);
    }

    private void createOneAdminUtilisateur(RdbLink em, AppInstanceDTO dto) {
        this.insertUtilisateur(em, 1052, dto.user1Nom, dto.user1Prenom, dto.user1Email, dto.password);
        RoleAdmin ra = new RoleAdmin();
        ra.utilisateur = em.find(Utilisateur.class, new Long(1052L));
        em.persist(ra);
    }

    private void createOneMasterUtilisateur(RdbLink em, AppInstanceDTO dto) {
        this.insertUtilisateur(em, 1052, dto.user1Nom, dto.user1Prenom, dto.user1Email, dto.password);
        RoleMaster ra = new RoleMaster();
        ra.utilisateur = em.find(Utilisateur.class, new Long(1052L));
        em.persist(ra);
    }

    private void createOneAppInstance(RdbLink em, AppInstanceDTO dto) {
        AppInstance app = new AppInstance();
        app.dateCreation = DateUtils.getDate();
        app.nomInstance = "amap1";
        app.dbUserName = dto.dbUserName;
        app.dbPassword = dto.dbPassword;
        app.stateOnStart = StateOnStart.ON_START_BE_ON;
        em.persist(app);
    }

    private void createPEStatusPageAsDemo(AppInstanceDTO dto) {
        FormatUtils.getLiteralMonthDate();
        String str = "<ul><li>Type de la base de donn\u00e9es : base de DEMO</li><li>Login \u00e0 utiliser : romain.dupuis@example.fr</li><li>Mot de passe \u00e0 utiliser : a</li></ul>";
        PEExtendedParametres pe = (PEExtendedParametres)new ParametresService().loadParamEcran(MenuList.EXTENDED_PARAMETRES);
        pe.masterDbLibAmap1 = str;
        new ParametresService().update(pe);
    }

    private void createProducteur(RdbLink em) {
        this.createProducteur(em, 3002, "FERME DES CHEVRES", 1601, 1522);
        this.createProducteur(em, 3011, "EARL LAIT VACHE", 1653, 1513);
        this.createProducteur(em, 3019, "FERME des BREBIS", 1515, 1509);
        this.createProducteur(em, 3029, "EARL du PAIN De SUC", 1508, 1514);
        this.createProducteur(em, 3036, "GAEC du BEAU LEGUME", 1656, 1657);
    }

    private void createProducteur(RdbLink em, int idProducteur, String nomProducteur, int idUtilisateur, int idReferent) {
        Producteur p = new Producteur();
        p.setId(new Long(idProducteur));
        p.nom = nomProducteur;
        p.delaiModifContrat = 3;
        p.feuilleDistributionGrille = ChoixOuiNon.OUI;
        p.feuilleDistributionListe = ChoixOuiNon.NON;
        p.dateCreation = DateUtils.suppressTime(DateUtils.getDate());
        p.gestionStock = ProducteurStockGestion.NON;
        p.notificationRetardataire = ProducteurNotificationRetardataire.NO;
        em.persist(p);
        ProducteurUtilisateur pu = new ProducteurUtilisateur();
        pu.notification = EtatNotification.SANS_NOTIFICATION_MAIL;
        pu.producteur = p;
        pu.utilisateur = em.find(Utilisateur.class, new Long(idUtilisateur));
        em.persist(pu);
        ProducteurReferent pr = new ProducteurReferent();
        pr.producteur = p;
        pr.referent = em.find(Utilisateur.class, new Long(idReferent));
        pr.notification = EtatNotification.SANS_NOTIFICATION_MAIL;
        em.persist(pr);
    }

    private void createProduit(RdbLink em) {
        this.insertProduit(em, 3003, "Tomme de ch\u00e8vre - blanc", "la pi\u00e8ce", 3002);
        this.insertProduit(em, 3004, "Tomme de ch\u00e8vre - cr\u00e9meux", "la pi\u00e8ce", 3002);
        this.insertProduit(em, 3005, "Tomme de ch\u00e8vre - sec", "la pi\u00e8ce", 3002);
        this.insertProduit(em, 3006, "Faisselle", "le pot de 500 g", 3002);
        this.insertProduit(em, 3007, "Yaourt", "le pot de 140 g", 3002);
        this.insertProduit(em, 3008, "Dessert lact\u00e9 parfum\u00e9", "le pot de 140 g", 3002);
        this.insertProduit(em, 3009, "Savon au lait de ch\u00e8vre", "la pi\u00e8ce", 3002);
        this.insertProduit(em, 3010, "Tomme press\u00e9e", "la pi\u00e8ce de 200/230 g", 3002);
        this.insertProduit(em, 3012, "Lait", "le litre", 3011);
        this.insertProduit(em, 3013, "Yaourt nature", "le pot de 500 g", 3011);
        this.insertProduit(em, 3014, "Yaourt nature", "le pot de 1 kg", 3011);
        this.insertProduit(em, 3015, "Yaourt aux fruits", "le pot de 500 g", 3011);
        this.insertProduit(em, 3016, "Faisselle", "le pot de 1 kg", 3011);
        this.insertProduit(em, 3017, "Cr\u00e8me fraiche", "le pot de 25 cl", 3011);
        this.insertProduit(em, 3018, "Confiture de lait", "le pot de 500 g", 3011);
        this.insertProduit(em, 3020, "Lait", "le litre", 3019);
        this.insertProduit(em, 3023, "Yaourt nature", "le pot de 300 g", 3019);
        this.insertProduit(em, 3024, "Yaourt vanille", "le pot de 300 g", 3019);
        this.insertProduit(em, 3025, "Tommette", "la pi\u00e8ce de 100 g", 3019);
        this.insertProduit(em, 3026, "Tomme press\u00e9e", "la pi\u00e8ce enti\u00e8re (environ 700 g)", 3019);
        this.insertProduit(em, 3027, "Tomme press\u00e9e", "la 1/2 pi\u00e8ce (environ 350 g)", 3019);
        this.insertProduit(em, 3028, "Tomme press\u00e9e", "le 1/4 de pi\u00e8ce (environ 175 g)", 3019);
        this.insertProduit(em, 4340, "F\u00e9ta", "la pi\u00e8ce enti\u00e8re (environ 400 g)", 3019);
        this.insertProduit(em, 4341, "F\u00e9ta", "la 1/2 pi\u00e8ce (environ 200 g)", 3019);
        this.insertProduit(em, 3030, "Pain de bl\u00e9", "la pi\u00e8ce de 900 g", 3029);
        this.insertProduit(em, 3031, "Pain de bl\u00e9 moul\u00e9", "la pi\u00e8ce de 900 g", 3029);
        this.insertProduit(em, 3032, "Pain de campagne", "la pi\u00e8ce de 900 g", 3029);
        this.insertProduit(em, 3033, "Pain de campagne moul\u00e9", "la pi\u00e8ce de 900 g ", 3029);
        this.insertProduit(em, 3034, "Pain de seigle", "la pi\u00e8ce de 900 g", 3029);
        this.insertProduit(em, 3035, "Pain de seigle moul\u00e9", "la pi\u00e8ce de 900 g ", 3029);
        this.insertProduit(em, 3037, "Petit panier de l\u00e9gumes", "la pi\u00e8ce", 3036);
        this.insertProduit(em, 3038, "Grand panier de l\u00e9gumes", "la pi\u00e8ce", 3036);
    }

    private void insertProduit(RdbLink em, int idProduit, String nom, String cond, int idProducteur) {
        Produit p = new Produit();
        p.setId(new Long(idProduit));
        p.nom = nom;
        p.conditionnement = cond;
        p.producteur = em.find(Producteur.class, new Long(idProducteur));
        em.persist(p);
    }

    private Long createPeriodeCotisation(RdbLink em, Date dateDebut, Date dateFin) {
        String nom;
        Date finPeriode;
        Date debutPeriode;
        Calendar c;
        int y2;
        int y1 = DateUtils.getYear(dateDebut);
        if (y1 == (y2 = DateUtils.getYear(dateFin))) {
            c = Calendar.getInstance();
            c.set(1, y1);
            c.set(2, 0);
            c.set(5, 1);
            debutPeriode = c.getTime();
            c.set(2, 11);
            c.set(5, 31);
            finPeriode = c.getTime();
            nom = "Saison " + y1;
        } else {
            c = Calendar.getInstance();
            c.set(1, y1);
            c.set(2, 6);
            c.set(5, 1);
            debutPeriode = c.getTime();
            c.set(1, y2);
            c.set(2, 5);
            c.set(5, 30);
            finPeriode = c.getTime();
            nom = "Saison " + y1 + "/" + y2;
        }
        PeriodeCotisationDTO dto = new PeriodeCotisationDTO();
        dto.dateDebut = debutPeriode;
        dto.dateFin = finPeriode;
        dto.nom = nom;
        dto.libCheque = "lib cheque AMAP";
        dto.textPaiement = "";
        dto.montantMini = 800;
        dto.montantConseille = 1500;
        try {
            return new GestionCotisationService().createOrUpdate(dto);
        }
        catch (OnSaveException e) {
            throw new RuntimeException(e);
        }
    }

    private void createContrat(RdbLink em, Date dateDebut, Date dateFin, Date dateFinInscription, Long idPeriodeCotisation) {
        this.createContrat(em, "LEGUMES", "l\u00e9gumes bio et vari\u00e9s", 3036L, dateFinInscription, dateDebut, dateFin, idPeriodeCotisation, NatureContrat.ABONNEMENT);
        this.createContrat(em, "PRODUITS LAITIERS de VACHE", "lait, yaourts, faisselle, cr\u00e8me fra\u00eeche", 3011L, dateFinInscription, dateDebut, dateFin, idPeriodeCotisation, NatureContrat.LIBRE);
        this.createContrat(em, "PAIN", "pains complet, campagne ou seigle", 3029L, dateFinInscription, dateDebut, dateFin, idPeriodeCotisation, NatureContrat.LIBRE);
        this.setAllContratActifs();
    }

    private void setAllContratActifs() {
        GestionContratService service = new GestionContratService();
        List<ModeleContratSummaryDTO> modeles = service.getModeleContratInfo(EtatModeleContrat.CREATION);
        for (ModeleContratSummaryDTO dto : modeles) {
            service.updateEtat(EtatModeleContrat.ACTIF, dto.id);
        }
    }

    private void createContrat(RdbLink em, String nom, String description, Long idProducteur, Date dateFinInscription, Date dateDebut, Date dateFin, Long idPeriodeCotisation, NatureContrat nature) {
        ModeleContratDTO modeleContrat = new ModeleContratDTO();
        modeleContrat.nom = nom;
        modeleContrat.description = description;
        modeleContrat.producteur = idProducteur;
        modeleContrat.dateFinInscription = dateFinInscription;
        modeleContrat.frequence = FrequenceLivraison.UNE_FOIS_PAR_SEMAINE;
        modeleContrat.strategiePaiement = StrategiePaiement.UN_CHEQUE_PAR_MOIS_LISSE_MODIFIABLE_1ERE_LIVRAISON;
        modeleContrat.gestionPaiement = GestionPaiement.GESTION_STANDARD;
        modeleContrat.saisiePaiementCalculDate = SaisiePaiementCalculDate.UN_PAIEMENT_PAR_MOIS_PREMIERE_LIVRAISON;
        modeleContrat.saisiePaiementModifiable = SaisiePaiementModifiable.MODIFIABLE;
        modeleContrat.saisiePaiementProposition = SaisiePaiementProposition.REPARTI_ARRONDI;
        modeleContrat.montantChequeMiniCalculProposition = 1500;
        modeleContrat.nature = nature;
        modeleContrat.typJoker = TypJoker.SANS_JOKER;
        modeleContrat.jokerMode = JokerMode.INSCRIPTION;
        modeleContrat.retardataireAutorise = RetardataireAutorise.NON;
        modeleContrat.stockGestion = StockGestion.NON;
        modeleContrat.gestionDocEngagement = GestionDocEngagement.AUCUNE_GESTION;
        modeleContrat.dateDebut = dateDebut;
        modeleContrat.dateFin = dateFin;
        new GestionContratDateUtils().computeDateLivraison(modeleContrat);
        modeleContrat.produits = this.getProduits(idProducteur.intValue(), em);
        modeleContrat.libCheque = em.find(Producteur.class, (Object)idProducteur).nom.toLowerCase();
        modeleContrat.dateRemiseCheque = dateFinInscription;
        new GestionContratDateUtils().computeDatePaiement(modeleContrat);
        modeleContrat.idPeriodeCotisation = idPeriodeCotisation;
        new GestionContratService().saveNewModeleContrat(modeleContrat);
    }

    private List<LigneContratDTO> getProduits(int idProducteur, RdbLink em) {
        ArrayList<LigneContratDTO> res = new ArrayList<LigneContratDTO>();
        switch (idProducteur) {
            case 3011: {
                this.add(res, em, 120, 3012);
                this.add(res, em, 200, 3013);
                this.add(res, em, 390, 3014);
                this.add(res, em, 250, 3015);
                this.add(res, em, 340, 3016);
                this.add(res, em, 205, 3017);
                break;
            }
            case 3029: {
                this.add(res, em, 400, 3030);
                this.add(res, em, 400, 3031);
                this.add(res, em, 400, 3032);
                this.add(res, em, 400, 3033);
                this.add(res, em, 400, 3034);
                this.add(res, em, 400, 3035);
                break;
            }
            case 3002: {
                this.add(res, em, 130, 3003);
                this.add(res, em, 130, 3004);
                this.add(res, em, 130, 3005);
                this.add(res, em, 240, 3006);
                this.add(res, em, 70, 3007);
                this.add(res, em, 80, 3008);
                this.add(res, em, 350, 3009);
                this.add(res, em, 440, 3010);
                break;
            }
            case 3019: {
                this.add(res, em, 350, 3020);
                this.add(res, em, 250, 3023);
                this.add(res, em, 270, 3024);
                this.add(res, em, 160, 3025);
                this.add(res, em, 1500, 3026);
                this.add(res, em, 750, 3027);
                this.add(res, em, 375, 3028);
                this.add(res, em, 1000, 4340);
                this.add(res, em, 500, 4341);
                break;
            }
            case 3036: {
                this.add(res, em, 1200, 3037);
                this.add(res, em, 2000, 3038);
                break;
            }
        }
        return res;
    }

    private void add(List<LigneContratDTO> res, RdbLink em, int prix, int idProduit) {
        LigneContratDTO dto = new LigneContratDTO();
        dto.prix = prix;
        dto.produitId = new Long(idProduit);
        res.add(dto);
    }

    private void createCotisation(Long idPeriodeCotisation) {
        this.insertCotisation(1051, idPeriodeCotisation);
        this.insertCotisation(1052, idPeriodeCotisation);
        this.insertCotisation(1509, idPeriodeCotisation);
        this.insertCotisation(1513, idPeriodeCotisation);
        this.insertCotisation(1514, idPeriodeCotisation);
        this.insertCotisation(1522, idPeriodeCotisation);
        this.insertCotisation(1659, idPeriodeCotisation);
    }

    private void insertCotisation(int idUtilisateur, Long idPeriodeCotisation) {
        Long userId = idUtilisateur;
        MesAdhesionDTO mesAdhesionDTO = new MesAdhesionsService().computeAdhesionInfo(userId);
        if (mesAdhesionDTO.nouvelles.size() == 0) {
            return;
        }
        AdhesionDTO adhesionDTO = mesAdhesionDTO.nouvelles.get(0);
        new MesAdhesionsService().createOrUpdateAdhesion(adhesionDTO, 1500);
    }

    private void createContratManualTest(RdbLink em, Date dateDebut, Date dateFin, Date dateFinInscription, Long idPeriodeCotisation) {
        this.createContratManualTestAbo(em, "11 - ABO SANS RETARDATAIRE", "vache - lait, yaourts, faisselle, cr\u00e8me fra\u00eeche", 3011L, dateFinInscription, dateDebut, dateFin, idPeriodeCotisation, RetardataireAutorise.NON);
        this.createContratManualTestAbo(em, "12 - ABO AVEC RETARDATAIRE", "pains complet, campagne ou seigle", 3029L, dateFinInscription, dateDebut, dateFin, idPeriodeCotisation, RetardataireAutorise.OUI);
        this.createContratManualTestLibre(em, "21 - LIBRE SANS RETARDATAIRE", "vache - lait, yaourts, faisselle, cr\u00e8me fra\u00eeche", 3011L, dateFinInscription, dateDebut, dateFin, idPeriodeCotisation, RetardataireAutorise.NON);
        this.createContratManualTestLibre(em, "22 - LIBRE AVEC RETARDATAIRE", "pains complet, campagne ou seigle", 3029L, dateFinInscription, dateDebut, dateFin, idPeriodeCotisation, RetardataireAutorise.OUI);
        this.createContratManualTestPrepayee(em, "31 - PREPAYEE", "chevres - fromages, yaourts, faisselles, savons", 3002L, dateFinInscription, dateDebut, dateFin, idPeriodeCotisation);
        this.setAllContratActifs();
    }

    private void createContratManualTestAbo(RdbLink em, String nom, String description, Long idProducteur, Date dateFinInscription, Date dateDebut, Date dateFin, Long idPeriodeCotisation, RetardataireAutorise retardataireAutorise) {
        ModeleContratDTO modeleContrat = new ModeleContratDTO();
        modeleContrat.nom = nom;
        modeleContrat.description = description;
        modeleContrat.producteur = idProducteur;
        modeleContrat.dateFinInscription = dateFinInscription;
        modeleContrat.frequence = FrequenceLivraison.UNE_FOIS_PAR_SEMAINE;
        modeleContrat.gestionPaiement = GestionPaiement.GESTION_STANDARD;
        modeleContrat.nature = NatureContrat.ABONNEMENT;
        modeleContrat.jokerMode = JokerMode.LIBRE;
        modeleContrat.jokerDelai = 4;
        modeleContrat.jokerNbMin = 2;
        modeleContrat.jokerNbMax = 3;
        modeleContrat.retardataireAutorise = retardataireAutorise;
        modeleContrat.dateDebut = dateDebut;
        modeleContrat.dateFin = dateFin;
        new GestionContratDateUtils().computeDateLivraison(modeleContrat);
        modeleContrat.produits = this.getProduits(idProducteur.intValue(), em);
        modeleContrat.libCheque = em.find(Producteur.class, (Object)idProducteur).nom.toLowerCase();
        modeleContrat.dateRemiseCheque = dateFinInscription;
        new GestionContratDateUtils().computeDatePaiement(modeleContrat);
        modeleContrat.idPeriodeCotisation = idPeriodeCotisation;
        new GestionContratService().saveNewModeleContrat(modeleContrat);
    }

    private void createContratManualTestLibre(RdbLink em, String nom, String description, Long idProducteur, Date dateFinInscription, Date dateDebut, Date dateFin, Long idPeriodeCotisation, RetardataireAutorise retardataireAutorise) {
        ModeleContratDTO modeleContrat = new ModeleContratDTO();
        modeleContrat.nom = nom;
        modeleContrat.description = description;
        modeleContrat.producteur = idProducteur;
        modeleContrat.dateFinInscription = dateFinInscription;
        modeleContrat.frequence = FrequenceLivraison.UNE_FOIS_PAR_SEMAINE;
        modeleContrat.gestionPaiement = GestionPaiement.GESTION_STANDARD;
        modeleContrat.nature = NatureContrat.LIBRE;
        modeleContrat.jokerMode = JokerMode.INSCRIPTION;
        modeleContrat.retardataireAutorise = retardataireAutorise;
        modeleContrat.dateDebut = dateDebut;
        modeleContrat.dateFin = dateFin;
        new GestionContratDateUtils().computeDateLivraison(modeleContrat);
        modeleContrat.produits = this.getProduits(idProducteur.intValue(), em);
        modeleContrat.libCheque = em.find(Producteur.class, (Object)idProducteur).nom.toLowerCase();
        modeleContrat.dateRemiseCheque = dateFinInscription;
        new GestionContratDateUtils().computeDatePaiement(modeleContrat);
        modeleContrat.idPeriodeCotisation = idPeriodeCotisation;
        new GestionContratService().saveNewModeleContrat(modeleContrat);
    }

    private void createContratManualTestPrepayee(RdbLink em, String nom, String description, Long idProducteur, Date dateFinInscription, Date dateDebut, Date dateFin, Long idPeriodeCotisation) {
        ModeleContratDTO modeleContrat = new ModeleContratDTO();
        modeleContrat.nom = nom;
        modeleContrat.description = description;
        modeleContrat.producteur = idProducteur;
        modeleContrat.dateFinInscription = dateFinInscription;
        modeleContrat.frequence = FrequenceLivraison.UNE_FOIS_PAR_SEMAINE;
        modeleContrat.gestionPaiement = GestionPaiement.GESTION_STANDARD;
        modeleContrat.nature = NatureContrat.CARTE_PREPAYEE;
        modeleContrat.cartePrepayeeDelai = 4;
        modeleContrat.jokerMode = JokerMode.INSCRIPTION;
        modeleContrat.retardataireAutorise = RetardataireAutorise.NON;
        modeleContrat.dateDebut = dateDebut;
        modeleContrat.dateFin = dateFin;
        new GestionContratDateUtils().computeDateLivraison(modeleContrat);
        modeleContrat.produits = this.getProduits(idProducteur.intValue(), em);
        modeleContrat.libCheque = em.find(Producteur.class, (Object)idProducteur).nom.toLowerCase();
        modeleContrat.dateRemiseCheque = dateFinInscription;
        new GestionContratDateUtils().computeDatePaiement(modeleContrat);
        modeleContrat.idPeriodeCotisation = idPeriodeCotisation;
        new GestionContratService().saveNewModeleContrat(modeleContrat);
    }
}

