/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.docengagement;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.StackUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.contrat.modele.GestionDocEngagement;
import fr.amapj.model.models.contrat.modele.ModeleContrat;
import fr.amapj.model.models.contrat.reel.Contrat;
import fr.amapj.service.engine.generator.CoreGenerator;
import fr.amapj.service.services.docengagement.signonline.core.DocEngagementSignOnLineTools;
import fr.amapj.service.services.edgenerator.bin.BGDocEngagementSigne;
import fr.amapj.service.services.edgenerator.pdf.PGEngagement;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DocEngagementGeneralService {
    private static final Logger logger = LogManager.getLogger();

    @DbRead
    public DocInfo getDocumentEngagementForContrat(Long idContrat) {
        try {
            DocInfo docInfo;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Contrat c = em.find(Contrat.class, idContrat);
            ModeleContrat mc = c.modeleContrat;
            DocInfo res = new DocInfo();
            res.gestionDocEngagement = mc.gestionDocEngagement;
            if (mc.gestionDocEngagement == GestionDocEngagement.AUCUNE_GESTION) {
                docInfo = res;
            } else if (mc.gestionDocEngagement == GestionDocEngagement.GENERATION_DOCUMENT_SEUL) {
                res.generator = new PGEngagement(PGEngagement.PGEngagementMode.UN_CONTRAT, mc.id, c.id, null);
                docInfo = res;
            } else if (mc.gestionDocEngagement == GestionDocEngagement.SIGNATURE_EN_LIGNE) {
                if (c.docEngagementSigne != null) {
                    res.generator = new BGDocEngagementSigne(idContrat);
                    res.isSigned = true;
                    docInfo = res;
                } else {
                    res.generator = new PGEngagement(PGEngagement.PGEngagementMode.UN_CONTRAT, mc.id, c.id, null);
                    docInfo = res;
                }
            } else {
                throw new AmapjRuntimeException();
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return docInfo;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    public void checkSizeAndSignatureDocumentEngagement(RdbLink em, ModeleContrat mc) {
        if (mc.gestionDocEngagement != GestionDocEngagement.SIGNATURE_EN_LIGNE) {
            return;
        }
        byte[] pdf = this.getDocument(mc.id);
        if (pdf == null) {
            return;
        }
        int len = pdf.length;
        logger.info("Taille du document : " + len);
        if (len > 80000) {
            throw new AmapjRuntimeException("La taille du document d'engagement est trop importante. Il faut diminuer sa taille en supprimant les logos et autres \u00e9lements non n\u00e9cessaires. Taille maximale autoris\u00e9e: 80Ko - Taille actuelle : " + len / 100 + " Ko.");
        }
        if (!new DocEngagementSignOnLineTools().hasSignatureAmapienAndProducteur(pdf)) {
            throw new AmapjRuntimeException("Le document d'engagement ne contient pas les champs  $contrat.signatureAmapien et $contrat.signatureProducteur qui permettent de poser la signature sur le contrat");
        }
    }

    private byte[] getDocument(Long id) {
        try {
            return new PGEngagement(PGEngagement.PGEngagementMode.UN_VIERGE, id, null, null).getByteArrayContent();
        }
        catch (Exception e) {
            logger.info("Erreur verification taille signature contrat : " + StackUtils.asString(e));
            return null;
        }
    }

    public static class DocInfo {
        public CoreGenerator generator;
        public GestionDocEngagement gestionDocEngagement;
        public boolean isSigned = false;
    }
}

