/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.docengagement.signonline.avenant;

import fr.amapj.common.DateUtils;
import fr.amapj.common.velocity.VelocityTools;
import fr.amapj.common.velocity.VelocityVar;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.contrat.reel.Contrat;
import fr.amapj.model.models.contrat.reel.DocEngagementSigne;
import fr.amapj.service.engine.generator.pdf.Html2PdfConverter;
import fr.amapj.service.engine.pdftools.PdfTools;
import fr.amapj.service.services.docengagement.signonline.avenant.AvenantHtmlGenerator;
import fr.amapj.service.services.docengagement.signonline.core.DocEngagementSignOnLineTools;
import fr.amapj.service.services.docengagement.signonline.model.DocEngagementBin;
import fr.amapj.service.services.docengagement.signonline.model.DocEngagementData;
import fr.amapj.service.services.docengagement.signonline.model.DocEngagementVar;
import fr.amapj.service.services.edgenerator.velocity.VCBuilder;
import fr.amapj.service.services.mescontrats.DocEngagementDTO;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;

public class AvenantManager {
    public DocEngagementData computeAvenantData(DocEngagementDTO docEngagementDTO) {
        DocEngagementData data = new DocEngagementData();
        data.part1NbPage = new PdfTools().getNbPages(docEngagementDTO.pdfContent);
        data.part1Vars = this.convert(docEngagementDTO.vars);
        data.part2Hash = null;
        return data;
    }

    public ResultAvenant updateWithAvenant(RdbLink em, Contrat c, DocEngagementBin docEngagementBin) {
        DocEngagementSigne ds = c.docEngagementSigne;
        DocEngagementData data = docEngagementBin.docEngagementData;
        if (c.dateModification == null || c.dateModification.equals(ds.avenantDate) || c.dateModification.before(ds.avenantDate)) {
            return ResultAvenant.NOTHING_TO_DO;
        }
        VelocityTools vt = new VelocityTools();
        VCBuilder.addContrat(vt, c.modeleContrat, c, null, em);
        List<VelocityVar> allVars = vt.getAllVars();
        if (data.part2Hash == null) {
            List<VelocityVar> modified1Vars = this.getModifiedVars(data.part1Vars, allVars);
            if (modified1Vars.size() == 0) {
                return ResultAvenant.UPDATE_AVENANT_DATE;
            }
            String avenantHtml = new AvenantHtmlGenerator().createAvenantAsHtml(vt, modified1Vars, c.dateModification);
            return this.updateOrCreateAvenant(docEngagementBin, avenantHtml);
        }
        List<VelocityVar> modified1Vars = this.getModifiedVars(data.part1Vars, allVars);
        if (modified1Vars.size() == 0) {
            return this.suppressAvenant(docEngagementBin);
        }
        String avenantHtml = new AvenantHtmlGenerator().createAvenantAsHtml(vt, modified1Vars, c.dateModification);
        if (this.hash(avenantHtml).equals(data.part2Hash)) {
            return ResultAvenant.UPDATE_AVENANT_DATE;
        }
        return this.updateOrCreateAvenant(docEngagementBin, avenantHtml);
    }

    private byte[] updateAvenantDate(byte[] content, DocEngagementSigne ds) {
        ds.avenantDate = DateUtils.getDate();
        return content;
    }

    private ResultAvenant suppressAvenant(DocEngagementBin docEngagementBin) {
        docEngagementBin.pdfContent = new DocEngagementSignOnLineTools().getFirstPages(docEngagementBin.pdfContent, docEngagementBin.docEngagementData.part1NbPage);
        docEngagementBin.docEngagementData.part2Hash = null;
        return ResultAvenant.UPDATE_DOCENGAGEMENTBIN;
    }

    private ResultAvenant updateOrCreateAvenant(DocEngagementBin docEngagementBin, String avenantHtml) {
        byte[] avenant = new Html2PdfConverter().convertHtmlToPdf(avenantHtml);
        byte[] pdfFinal = new DocEngagementSignOnLineTools().concateTwoPdf(docEngagementBin.pdfContent, docEngagementBin.docEngagementData.part1NbPage, avenant);
        docEngagementBin.pdfContent = pdfFinal;
        docEngagementBin.docEngagementData.part2Hash = this.hash(avenantHtml);
        return ResultAvenant.UPDATE_DOCENGAGEMENTBIN;
    }

    public List<DocEngagementVar> convert(List<VelocityVar> vars) {
        return vars.stream().map(e -> this.convert((VelocityVar)e)).collect(Collectors.toList());
    }

    public DocEngagementVar convert(VelocityVar var) {
        DocEngagementVar res = new DocEngagementVar();
        res.varName = var.varName;
        res.hash = this.hash(var.content);
        return res;
    }

    private String hash(String content) {
        if (content == null) {
            return this.hash("");
        }
        return DigestUtils.sha1Hex((String)content);
    }

    private List<VelocityVar> getModifiedVars(List<DocEngagementVar> docVars, List<VelocityVar> currentVars) {
        ArrayList<VelocityVar> res = new ArrayList<VelocityVar>();
        for (DocEngagementVar docVar : docVars) {
            VelocityVar currentVar = this.findCurrent(docVar, currentVars);
            if (currentVar == null || this.hash(currentVar.content).equals(docVar.hash)) continue;
            res.add(currentVar);
        }
        return res;
    }

    private VelocityVar findCurrent(DocEngagementVar docVar, List<VelocityVar> currentVars) {
        for (VelocityVar currentVar : currentVars) {
            if (!currentVar.varName.equals(docVar.varName)) continue;
            return currentVar;
        }
        return null;
    }

    public static enum ResultAvenant {
        NOTHING_TO_DO,
        UPDATE_AVENANT_DATE,
        UPDATE_DOCENGAGEMENTBIN;

    }
}

