/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.docengagement.signonline.core;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.common.DateUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.engine.transaction.DbRead;
import fr.amapj.model.engine.transaction.DbWrite;
import fr.amapj.model.engine.transaction.NewTransaction;
import fr.amapj.model.engine.transaction.Transaction;
import fr.amapj.model.models.contrat.reel.Contrat;
import fr.amapj.model.models.contrat.reel.DocEngagementSigne;
import fr.amapj.model.models.fichierbase.Producteur;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.service.services.docengagement.signonline.avenant.AvenantManager;
import fr.amapj.service.services.docengagement.signonline.core.DocEngagementSignOnLineTools;
import fr.amapj.service.services.docengagement.signonline.model.DocEngagementBin;
import fr.amapj.service.services.mescontrats.DocEngagementDTO;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class CoreDocEngagementSignOnLineService {
    private static final Logger logger = LogManager.getLogger();

    @DbRead
    public byte[] loadDocEngagementSignePdf(Long idContrat) {
        try {
            byte[] byArray;
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$1$c8455117();
            RdbLink em = RdbLink.get();
            Contrat c = em.find(Contrat.class, idContrat);
            DocEngagementSigne ds = c.docEngagementSigne;
            if (ds == null) {
                throw new AmapjRuntimeException("Pas de document d'engagement");
            }
            DocEngagementBin bin = new DocEngagementBin();
            bin.fromBytes(ds.getDocEngagementBin());
            AvenantManager.ResultAvenant res = new AvenantManager().updateWithAvenant(em, c, bin);
            logger.info("Mise \u00e0 jour avenant : " + (Object)((Object)res) + " idContrat=" + idContrat);
            switch (res) {
                case NOTHING_TO_DO: {
                    byArray = bin.pdfContent;
                    break;
                }
                case UPDATE_AVENANT_DATE: {
                    NewTransaction.write(em2 -> this.updateAvenantDate((RdbLink)em2, idContrat));
                    byArray = bin.pdfContent;
                    break;
                }
                case UPDATE_DOCENGAGEMENTBIN: {
                    NewTransaction.write(em2 -> this.updateDocEngagementBin((RdbLink)em2, idContrat, bin.toBytes()));
                    byArray = bin.pdfContent;
                    break;
                }
                default: {
                    throw new AmapjRuntimeException();
                }
            }
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$2$c8455117();
            return byArray;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$3$c8455117();
            throw throwable;
        }
    }

    private void updateDocEngagementBin(RdbLink em2, Long idContrat, byte[] bs) {
        DocEngagementSigne ds = em2.find(Contrat.class, (Object)idContrat).docEngagementSigne;
        ds.avenantDate = DateUtils.getDate();
        ds.setDocEngagementBin(em2, bs);
    }

    private void updateAvenantDate(RdbLink em2, Long idContrat) {
        DocEngagementSigne ds = em2.find(Contrat.class, (Object)idContrat).docEngagementSigne;
        ds.avenantDate = DateUtils.getDate();
    }

    public void saveDocEngagementSigneByAmapien(DocEngagementDTO docEngagementDTO, Contrat c, RdbLink em, Date now) {
        DocEngagementSigne ds;
        if (docEngagementDTO == null) {
            return;
        }
        if (docEngagementDTO.pdfContent.length > 140000) {
            throw new AmapjRuntimeException("La taille du pdf est trop importante : " + docEngagementDTO.pdfContent.length);
        }
        boolean create = c.docEngagementSigne == null;
        c.docEngagementSigne = ds = create ? new DocEngagementSigne() : c.docEngagementSigne;
        ds.amapienDateSignature = now;
        ds.amapienLibSignature = String.valueOf(c.utilisateur.nom) + " " + c.utilisateur.prenom;
        ds.producteurDateSignature = null;
        ds.producteurLibSignature = null;
        ds.avenantDate = now;
        if (create) {
            em.persist(ds);
        }
        byte[] pdfContent = new DocEngagementSignOnLineTools().addSignatureAmapien(docEngagementDTO.pdfContent, ds.amapienDateSignature, ds.amapienLibSignature);
        DocEngagementBin bin = new DocEngagementBin();
        bin.pdfContent = pdfContent;
        bin.docEngagementData = new AvenantManager().computeAvenantData(docEngagementDTO);
        ds.setDocEngagementBin(em, bin.toBytes());
    }

    @DbWrite
    public void saveDocEngagementSigneByAmapien(DocEngagementDTO docEngagementDTO, Long idContrat) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            Contrat c = em.find(Contrat.class, idContrat);
            this.saveDocEngagementSigneByAmapien(docEngagementDTO, c, em, DateUtils.getDate());
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    @DbWrite
    public void saveDocEngagementSigneByProducteur(Long idContrat, Long userId) {
        try {
            Transaction.aspectOf().ajc$before$fr_amapj_model_engine_transaction_Transaction$4$5f8be120();
            RdbLink em = RdbLink.get();
            Contrat c = em.find(Contrat.class, idContrat);
            DocEngagementSigne ds = c.docEngagementSigne;
            Utilisateur u = em.find(Utilisateur.class, userId);
            Producteur p = c.modeleContrat.producteur;
            ds.producteurDateSignature = DateUtils.getDate();
            ds.producteurLibSignature = String.valueOf(u.nom) + " " + u.prenom + " (" + p.nom + ")";
            DocEngagementBin docEngagementBin = new DocEngagementBin();
            docEngagementBin.fromBytes(ds.getDocEngagementBin());
            docEngagementBin.pdfContent = new DocEngagementSignOnLineTools().addSignatureProducteur(docEngagementBin.pdfContent, ds.producteurDateSignature, ds.producteurLibSignature);
            ds.setDocEngagementBin(em, docEngagementBin.toBytes());
            Transaction.aspectOf().ajc$afterReturning$fr_amapj_model_engine_transaction_Transaction$5$5f8be120();
            return;
        }
        catch (Throwable throwable) {
            Transaction.aspectOf().ajc$afterThrowing$fr_amapj_model_engine_transaction_Transaction$6$5f8be120();
            throw throwable;
        }
    }

    public void deleteDocEngagementSigne(RdbLink em, Contrat c) {
        DocEngagementSigne cs = c.docEngagementSigne;
        if (cs == null) {
            return;
        }
        c.docEngagementSigne = null;
        cs.setDocEngagementBin(em, null);
        em.remove(cs);
    }
}

