/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.bin;

import fr.amapj.common.AmapjRuntimeException;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.contrat.reel.Contrat;
import fr.amapj.service.engine.generator.bin.AbstractBinGenerator;
import fr.amapj.service.services.docengagement.signonline.core.CoreDocEngagementSignOnLineService;

public class BGDocEngagementSigne
extends AbstractBinGenerator {
    private Long idContrat;

    public BGDocEngagementSigne(Long idContrat) {
        this.idContrat = idContrat;
    }

    @Override
    public byte[] generateContent(RdbLink em) {
        byte[] bs = new CoreDocEngagementSignOnLineService().loadDocEngagementSignePdf(this.idContrat);
        if (bs == null) {
            throw new AmapjRuntimeException("Le document d'engagement doit \u00eatre sign\u00e9 par l'amapien au moins.");
        }
        return bs;
    }

    @Override
    public String getFileName(RdbLink em) {
        Contrat c = em.find(Contrat.class, this.idContrat);
        return "document-engagement-" + c.modeleContrat.nom + "-" + c.utilisateur.nom + " " + c.utilisateur.prenom + " " + this.getSuffix(c);
    }

    @Override
    public String getNameToDisplay(RdbLink em) {
        Contrat c = em.find(Contrat.class, this.idContrat);
        return "le document d'engagement " + c.modeleContrat.nom + " pour " + c.utilisateur.nom + " " + c.utilisateur.prenom + " " + this.getSuffix(c);
    }

    private String getSuffix(Contrat c) {
        if (c.docEngagementSigne.producteurDateSignature == null) {
            return "(sign\u00e9 par l'amapien)";
        }
        return "(sign\u00e9 par l'amapien et le producteur)";
    }

    @Override
    public String getExtension() {
        return "pdf";
    }
}

