/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.excel;

import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.cotisation.PeriodeCotisation;
import fr.amapj.model.models.fichierbase.Utilisateur;
import fr.amapj.service.engine.generator.excel.AbstractExcelGenerator;
import fr.amapj.service.engine.generator.excel.ExcelFormat;
import fr.amapj.service.engine.generator.excel.ExcelGeneratorTool;
import fr.amapj.service.services.gestioncotisation.BilanAdhesionDTO;
import fr.amapj.service.services.gestioncotisation.GestionCotisationService;
import fr.amapj.service.services.gestioncotisation.PeriodeCotisationUtilisateurDTO;
import fr.amapj.service.services.utilisateur.util.UtilisateurUtil;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class EGBilanAdhesion
extends AbstractExcelGenerator {
    Long periodeCotisationId;
    SimpleDateFormat df = new SimpleDateFormat("dd/MM/yyyy");

    public EGBilanAdhesion(Long periodeCotisationId) {
        this.periodeCotisationId = periodeCotisationId;
    }

    @Override
    public void fillExcelFile(RdbLink em, ExcelGeneratorTool et) {
        BilanAdhesionDTO bilan = new GestionCotisationService().loadBilanAdhesion(this.periodeCotisationId);
        et.addSheet("Adh\u00e9sion", 7, 20);
        et.setColumnWidth(6, 40);
        et.addRow("Bilan des adh\u00e9sions pour la p\u00e9riode de " + bilan.periodeCotisationDTO.nom, et.grasGaucheNonWrappe);
        et.addRow("", et.grasGaucheNonWrappe);
        et.addRow("Nombre total d'adh\u00e9sions : " + bilan.utilisateurDTOs.size(), et.grasGaucheNonWrappe);
        et.addRow("Nombre de paiements \u00e0 r\u00e9cup\u00e9rer : " + bilan.periodeCotisationDTO.nbPaiementARecuperer, et.grasGaucheNonWrappe);
        et.addRow("Nombre de paiements r\u00e9ceptionn\u00e9s : " + bilan.periodeCotisationDTO.nbPaiementDonnes, et.grasGaucheNonWrappe);
        et.addRow("Ordre des ch\u00e8ques : " + bilan.periodeCotisationDTO.getLibCheque(), et.grasGaucheNonWrappe);
        et.addRow("", et.grasGaucheNonWrappe);
        et.addRow();
        et.setCell(0, "Nom", et.grasCentreBordure);
        et.setCell(1, "Pr\u00e9nom", et.grasCentreBordure);
        et.setCell(2, "Montant", et.grasCentreBordure);
        et.setCell(3, "Etat du paiement", et.grasCentreBordure);
        et.setCell(4, "Type du paiement", et.grasCentreBordure);
        et.setCell(5, "Date de r\u00e9ception", et.grasCentreBordure);
        et.setCell(6, "E mail", et.grasCentreBordure);
        for (PeriodeCotisationUtilisateurDTO u : bilan.utilisateurDTOs) {
            this.addRow(em, u, et);
        }
        et.addRow("", et.grasGaucheNonWrappe);
        this.addRowCumul(et, bilan.utilisateurDTOs.size());
    }

    private void addRow(RdbLink em, PeriodeCotisationUtilisateurDTO pu, ExcelGeneratorTool et) {
        Utilisateur u = em.find(Utilisateur.class, pu.idUtilisateur);
        et.addRow();
        et.setCell(0, u.nom, et.grasGaucheNonWrappeBordure);
        et.setCell(1, u.prenom, et.nonGrasGaucheBordure);
        et.setCellPrix(2, pu.montantAdhesion, et.prixCentreBordure);
        et.setCell(3, pu.etatPaiementAdhesion.toString(), et.nonGrasCentreBordure);
        et.setCell(4, pu.typePaiementAdhesion.toString(), et.nonGrasCentreBordure);
        et.setCell(5, this.getDate(pu.dateReceptionCheque), et.nonGrasCentreBordure);
        et.setCell(6, UtilisateurUtil.libMail(u), et.nonGrasGaucheBordure);
    }

    private String getDate(Date dateReceptionCheque) {
        if (dateReceptionCheque == null) {
            return "";
        }
        return this.df.format(dateReceptionCheque);
    }

    private void addRowCumul(ExcelGeneratorTool et, int nbAdhesion) {
        et.addRow();
        et.setCell(0, "Total", et.grasGaucheNonWrappeBordure);
        et.setCell(1, "", et.nonGrasGaucheBordure);
        et.setCellSumInColUp(2, 2, nbAdhesion, et.prixCentreBordure);
        et.setCell(3, "", et.nonGrasGaucheBordure);
        et.setCell(4, "", et.nonGrasGaucheBordure);
        et.setCell(5, "", et.nonGrasGaucheBordure);
        et.setCell(6, "", et.nonGrasGaucheBordure);
    }

    @Override
    public String getFileName(RdbLink em) {
        PeriodeCotisation pc = em.find(PeriodeCotisation.class, this.periodeCotisationId);
        return "bilan-adh\u00e9sion-" + pc.nom;
    }

    @Override
    public String getNameToDisplay(RdbLink em) {
        PeriodeCotisation pc = em.find(PeriodeCotisation.class, this.periodeCotisationId);
        return "le bilan des adh\u00e9sions pour " + pc.nom;
    }

    @Override
    public ExcelFormat getFormat() {
        return ExcelFormat.XLS;
    }

    public static void main(String[] args) throws IOException {
        new EGBilanAdhesion(12652L).test();
    }
}

