/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.excel;

import fr.amapj.common.DateUtils;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.fichierbase.EtatUtilisateur;
import fr.amapj.service.engine.generator.excel.AbstractExcelGenerator;
import fr.amapj.service.engine.generator.excel.ExcelFormat;
import fr.amapj.service.engine.generator.excel.ExcelGeneratorTool;
import fr.amapj.service.services.parametres.paramecran.PEListeAdherentDTO;
import fr.amapj.service.services.utilisateur.UtilisateurDTO;
import fr.amapj.service.services.utilisateur.UtilisateurService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public class EGListeAdherent
extends AbstractExcelGenerator {
    Type type;
    PEListeAdherentDTO peListeAdherentDTO;

    public EGListeAdherent(Type type) {
        this.type = type;
        this.peListeAdherentDTO = new PEListeAdherentDTO();
    }

    public EGListeAdherent(Type type, PEListeAdherentDTO peListeAdherentDTO) {
        this.type = type;
        this.peListeAdherentDTO = peListeAdherentDTO;
    }

    @Override
    public void fillExcelFile(RdbLink em, ExcelGeneratorTool et) {
        List<Object> utilisateurs;
        et.addSheet("Liste des adh\u00e9rents", 10, 20);
        et.setColumnWidth(2, 40);
        et.setColumnWidth(5, 40);
        et.setColumnWidth(7, 40);
        if (this.type == Type.EXAMPLE) {
            utilisateurs = new ArrayList();
            UtilisateurDTO dto = new UtilisateurDTO();
            dto.setNom("DURAND");
            dto.setPrenom("Paul");
            dto.setEmail("paul@gmail.com");
            dto.setNumTel1("01 23 45 67 89");
            dto.setNumTel2("06 12 34 56 78");
            dto.setLibAdr1("La grande rue");
            dto.setCodePostal("26150");
            dto.setVille("Die");
            utilisateurs.add(dto);
        } else {
            utilisateurs = this.type == Type.STD ? new UtilisateurService().getAllUtilisateurs(EtatUtilisateur.ACTIF) : new UtilisateurService().getAllUtilisateurs(null);
        }
        this.contructEntete(et);
        int i = 0;
        while (i < utilisateurs.size()) {
            UtilisateurDTO utilisateur = (UtilisateurDTO)utilisateurs.get(i);
            this.contructRow(et, utilisateur);
            ++i;
        }
    }

    private void contructEntete(ExcelGeneratorTool et) {
        SimpleDateFormat df1 = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        et.addRow("Extrait le " + df1.format(DateUtils.getDate()), et.grasGaucheNonWrappe);
        et.addRow();
        et.addRow();
        et.setCell(0, "Nom", et.grasGaucheNonWrappeBordure);
        et.setCell(1, "Pr\u00e9nom", et.grasGaucheNonWrappeBordure);
        et.setCell(2, "E mail", et.grasGaucheNonWrappeBordure);
        et.setCell(3, "Tel1", et.grasGaucheNonWrappeBordure);
        et.setCell(4, "Tel2", et.grasGaucheNonWrappeBordure);
        et.setCell(5, "Adr", et.grasGaucheNonWrappeBordure);
        et.setCell(6, "Code Postal", et.grasGaucheNonWrappeBordure);
        et.setCell(7, "Ville", et.grasGaucheNonWrappeBordure);
        if (this.type != Type.EXAMPLE) {
            et.setCell(8, "R\u00f4le", et.grasGaucheNonWrappeBordure);
        }
        if (this.type == Type.AVEC_INACTIF) {
            et.setCell(9, "Actif/Inactif", et.grasGaucheNonWrappeBordure);
        }
    }

    private void contructRow(ExcelGeneratorTool et, UtilisateurDTO u) {
        et.addRow();
        int i = 0;
        while (i < 8) {
            et.setCell(i, "", et.nonGrasGaucheBordure);
            ++i;
        }
        et.setCell(0, u.getNom(), et.grasGaucheNonWrappeBordure);
        et.setCell(0, u.getNom(), et.grasGaucheNonWrappeBordure);
        et.setCell(1, u.getPrenom(), et.nonGrasGaucheBordure);
        if (this.peListeAdherentDTO.canAccessEmail) {
            et.setCell(2, u.getEmail(), et.nonGrasGaucheBordure);
        }
        if (this.peListeAdherentDTO.canAccessTel1) {
            et.setCell(3, u.getNumTel1(), et.nonGrasGaucheBordure);
        }
        if (this.peListeAdherentDTO.canAccessTel2) {
            et.setCell(4, u.getNumTel2(), et.nonGrasGaucheBordure);
        }
        if (this.peListeAdherentDTO.canAccessAdress) {
            et.setCell(5, u.getLibAdr1(), et.nonGrasGaucheBordure);
            et.setCell(6, u.getCodePostal(), et.nonGrasGaucheBordure);
            et.setCell(7, u.getVille(), et.nonGrasGaucheBordure);
        }
        if (this.type != Type.EXAMPLE) {
            et.setCell(8, u.getRoles(), et.nonGrasGaucheBordure);
        }
        if (this.type == Type.AVEC_INACTIF) {
            et.setCell(9, u.getEtatUtilisateur().name(), et.nonGrasGaucheBordure);
        }
    }

    @Override
    public String getFileName(RdbLink em) {
        return "liste-adherents";
    }

    @Override
    public String getNameToDisplay(RdbLink em) {
        if (this.type == Type.EXAMPLE) {
            return "un exemple de fichier pour charger les utilisateurs";
        }
        if (this.type == Type.STD) {
            return "la liste des adh\u00e9rents actifs";
        }
        return "la liste des adh\u00e9rents (actifs et inactifs)";
    }

    @Override
    public ExcelFormat getFormat() {
        return ExcelFormat.XLS;
    }

    public static enum Type {
        STD,
        AVEC_INACTIF,
        EXAMPLE;

    }
}

