/*
 * Decompiled with CFR 0.152.
 */
package fr.amapj.service.services.edgenerator.excel;

import fr.amapj.common.DateUtils;
import fr.amapj.common.html.HtmlToPlainText;
import fr.amapj.model.engine.rdblink.RdbLink;
import fr.amapj.model.models.fichierbase.Producteur;
import fr.amapj.service.engine.generator.excel.AbstractExcelGenerator;
import fr.amapj.service.engine.generator.excel.ExcelFormat;
import fr.amapj.service.engine.generator.excel.ExcelGeneratorTool;
import fr.amapj.service.services.importdonnees.ImportDonneesService;
import fr.amapj.service.services.importdonnees.ImportProduitProducteurDTO;
import fr.amapj.service.services.produit.ProduitService;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;

public class EGListeProduitProducteur
extends AbstractExcelGenerator {
    private Type type;
    private Long idProducteur;

    public EGListeProduitProducteur(Long idProducteur, Type type) {
        this.idProducteur = idProducteur;
        this.type = type;
    }

    @Override
    public void fillExcelFile(RdbLink em, ExcelGeneratorTool et) {
        List<Object> prods;
        et.addSheet("Liste des produits et des producteurs", 4, 60);
        if (this.type == Type.EXAMPLE) {
            prods = new ArrayList();
            ImportProduitProducteurDTO importProduitProducteurDTO = new ImportProduitProducteurDTO();
            importProduitProducteurDTO.producteur = "EARL BIO LAIT";
            importProduitProducteurDTO.produit = "Faisselle";
            importProduitProducteurDTO.conditionnement = "le pot de 500 g";
            prods.add(importProduitProducteurDTO);
            ImportProduitProducteurDTO importProduitProducteurDTO2 = new ImportProduitProducteurDTO();
            importProduitProducteurDTO2.producteur = "EARL BIO LAIT";
            importProduitProducteurDTO2.produit = "Yaourt";
            importProduitProducteurDTO2.conditionnement = "le pot de 1 kg";
            prods.add(importProduitProducteurDTO2);
            ImportProduitProducteurDTO importProduitProducteurDTO3 = new ImportProduitProducteurDTO();
            importProduitProducteurDTO3.producteur = "EARL PAIN";
            importProduitProducteurDTO3.produit = "Pain de seigle";
            importProduitProducteurDTO3.conditionnement = "la pi\u00e8ce de 900 g";
            prods.add(importProduitProducteurDTO3);
            ImportProduitProducteurDTO importProduitProducteurDTO4 = new ImportProduitProducteurDTO();
            importProduitProducteurDTO4.producteur = "EARL PAIN";
            importProduitProducteurDTO4.produit = "Pain de campagne";
            importProduitProducteurDTO4.conditionnement = "la pi\u00e8ce de 900 g";
            prods.add(importProduitProducteurDTO4);
        } else {
            prods = this.idProducteur == null ? new ImportDonneesService().getAllProduits() : new ImportDonneesService().getAllProduits(this.idProducteur);
        }
        this.contructEntete(et);
        for (ImportProduitProducteurDTO importProduitProducteurDTO : prods) {
            this.contructRow(et, importProduitProducteurDTO);
        }
    }

    private void contructEntete(ExcelGeneratorTool et) {
        SimpleDateFormat df1 = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
        et.addRow("Extrait le " + df1.format(DateUtils.getDate()), et.grasGaucheNonWrappe);
        et.addRow();
        et.addRow();
        et.setCell(0, "Producteur", et.grasGaucheNonWrappeBordure);
        et.setCell(1, "Nom du produit", et.grasGaucheNonWrappeBordure);
        et.setCell(2, "Conditionnement du produit", et.grasGaucheNonWrappeBordure);
        et.setCell(3, "Description du produit", et.grasGaucheNonWrappeBordure);
    }

    private void contructRow(ExcelGeneratorTool et, ImportProduitProducteurDTO u) {
        et.addRow();
        et.setCell(0, u.producteur, et.grasGaucheNonWrappeBordure);
        et.setCell(1, u.produit, et.nonGrasGaucheBordure);
        et.setCell(2, u.conditionnement, et.nonGrasGaucheBordure);
        et.setCell(3, this.getDescription(u.idProduit), et.nonGrasGaucheBordure);
    }

    private String getDescription(Long idProduit) {
        if (idProduit == null) {
            return "";
        }
        String description = new ProduitService().loadWebPage((Long)idProduit).content;
        if (description == null) {
            return "";
        }
        return HtmlToPlainText.toPlainText(description);
    }

    @Override
    public String getFileName(RdbLink em) {
        if (this.idProducteur != null) {
            Producteur p = em.find(Producteur.class, this.idProducteur);
            return "liste-produits-" + p.nom;
        }
        return "liste-produits";
    }

    @Override
    public String getNameToDisplay(RdbLink em) {
        if (this.type == Type.EXAMPLE) {
            return "un exemple de fichier pour charger les produits et les producteurs";
        }
        if (this.idProducteur != null) {
            Producteur p = em.find(Producteur.class, this.idProducteur);
            return "la liste des produits du producteur : " + p.nom;
        }
        return "la liste de tous les produits et tous les producteurs";
    }

    @Override
    public ExcelFormat getFormat() {
        return ExcelFormat.XLS;
    }

    public static enum Type {
        STD,
        EXAMPLE;

    }
}

